/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.database.DatabaseHelper;
import com.shopgun.android.sdk.database.DbUtils;
import com.shopgun.android.sdk.database.ItemSQLiteHelper;
import com.shopgun.android.sdk.database.ListSQLiteHelper;
import com.shopgun.android.sdk.database.SQLDataSource;
import com.shopgun.android.sdk.database.ShareSQLiteHelper;
import com.shopgun.android.sdk.model.Share;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.model.ShoppinglistItem;
import com.shopgun.android.sdk.model.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;

public class DataSource
extends SQLDataSource {
    public static final String TAG = Constants.getTag(DataSource.class);

    public DataSource(Context c) {
        super(new DatabaseHelper(c));
    }

    public int clear() {
        String whereClause = "1";
        int count = this.delete("shoppinglistitems", whereClause, null);
        count += this.delete("shoppinglists", whereClause, null);
        return count += this.delete("shares", whereClause, null);
    }

    public int clear(int userId) {
        String whereClause = "user=?";
        String[] whereArgs = new String[]{String.valueOf(userId)};
        int count = this.delete("shoppinglistitems", whereClause, whereArgs);
        count += this.delete("shoppinglists", whereClause, whereArgs);
        return count += this.delete("shares", whereClause, whereArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int delete(String table, String whereClause, String[] whereArgs) {
        try {
            int n = this.acquireDb().delete(table, whereClause, whereArgs);
            return n;
        }
        catch (IllegalStateException e) {
            this.log(TAG, e);
            int n = 0;
            return n;
        }
        finally {
            this.releaseDb();
        }
    }

    public int insertList(Shoppinglist sl, String userId) {
        ArrayList<Shoppinglist> list = new ArrayList<Shoppinglist>(1);
        list.add(sl);
        return this.insertList(list, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertList(List<Shoppinglist> list, String userId) {
        if (list.isEmpty()) {
            return 0;
        }
        SQLiteDatabase db = this.acquireDb();
        try {
            int count = 0;
            db.beginTransaction();
            SQLiteStatement s = ListSQLiteHelper.getInsertStatement(db);
            for (Shoppinglist sl : list) {
                ListSQLiteHelper.bind(s, sl, userId);
                if (s.executeInsert() <= -1L) continue;
                this.deleteShares(sl.getId(), userId);
                this.insertSharesTransactionLess(db, sl.getShares().values(), userId);
                ++count;
            }
            db.setTransactionSuccessful();
            int n = count;
            return n;
        }
        catch (IllegalStateException e) {
            this.log(TAG, e);
            int n = -1;
            return n;
        }
        finally {
            db.endTransaction();
            this.releaseDb();
        }
    }

    public Shoppinglist getList(String id, String userId) {
        String selection = "id=? AND user=? AND state!=?";
        String[] selectionArgs = new String[]{id, userId, String.valueOf(4)};
        List<Shoppinglist> list = this.getLists(selection, selectionArgs, userId);
        return list.isEmpty() ? null : list.get(0);
    }

    public List<Shoppinglist> getLists(String userId, boolean includeDeleted) {
        String selection = "user=? AND state!=?";
        String[] selectionArgs = new String[]{userId, String.valueOf(4)};
        if (includeDeleted) {
            selection = "user=?";
            selectionArgs = new String[]{userId};
        }
        return this.getLists(selection, selectionArgs, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Shoppinglist> getLists(String selection, String[] selectionArgs, String userId) {
        List<Shoppinglist> list;
        Cursor c = null;
        SQLiteDatabase db = this.acquireDb();
        try {
            db.beginTransaction();
            c = db.query(false, "shoppinglists", null, selection, selectionArgs, null, null, "name", null);
            List<Shoppinglist> lists = ListSQLiteHelper.cursorToList(c);
            for (Shoppinglist sl : lists) {
                List<Share> shares = this.getShares(sl.getId(), userId, false);
                sl.setShares(shares);
            }
            db.setTransactionSuccessful();
            list = lists;
            DbUtils.closeCursor(c);
        }
        catch (IllegalStateException e) {
            this.log(TAG, e);
            ArrayList<Shoppinglist> arrayList = new ArrayList<Shoppinglist>();
            return arrayList;
        }
        finally {
            DbUtils.closeCursor(c);
            db.endTransaction();
            this.releaseDb();
        }
        db.endTransaction();
        this.releaseDb();
        return list;
    }

    public int deleteList(String shoppinglistId, String userId) {
        String whereClause = "id=? AND user=? ";
        String[] whereArgs = new String[]{shoppinglistId, userId};
        return this.delete("shoppinglists", whereClause, whereArgs);
    }

    public Shoppinglist getListPrevious(String previousId, String userId) {
        String selection = "previous_id=? AND user=?";
        String[] selectionArgs = new String[]{previousId, userId};
        List<Shoppinglist> list = this.getLists(selection, selectionArgs, userId);
        return list.isEmpty() ? null : list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int editItemState(String shoppinglistId, String userId, Date modified, int syncState) {
        try {
            ContentValues cv = ItemSQLiteHelper.stateToContentValues(modified, syncState);
            String whereClause = "shopping_list_id=? AND user=? ";
            String[] whereArgs = new String[]{shoppinglistId, userId};
            int n = this.acquireDb().updateWithOnConflict("shoppinglistitems", cv, whereClause, whereArgs, 5);
            return n;
        }
        catch (IllegalStateException e) {
            this.log(TAG, e);
            int n = 0;
            return n;
        }
        finally {
            this.releaseDb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertItem(ShoppinglistItem sli, String userId) {
        try {
            ContentValues cv = ItemSQLiteHelper.objectToContentValues(sli, userId);
            long l = this.acquireDb().insertWithOnConflict("shoppinglistitems", null, cv, 5);
            return l;
        }
        catch (IllegalStateException e) {
            this.log(TAG, e);
            long l = 0L;
            return l;
        }
        finally {
            this.releaseDb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertItem(List<ShoppinglistItem> list, String userId) {
        if (list.isEmpty()) {
            return -1;
        }
        SQLiteDatabase db = this.acquireDb();
        db.beginTransaction();
        int count = 0;
        try {
            SQLiteStatement s = ItemSQLiteHelper.getInsertStatement(db);
            for (ShoppinglistItem sli : list) {
                ItemSQLiteHelper.bind(s, sli, userId);
                if (s.executeInsert() <= -1L) continue;
                ++count;
            }
            db.setTransactionSuccessful();
            int n = count;
            return n;
        }
        catch (IllegalStateException e) {
            this.log(TAG, e);
            int n = count;
            return n;
        }
        finally {
            db.endTransaction();
            this.releaseDb();
        }
    }

    public ShoppinglistItem getItem(String itemId, String userId) {
        String selection = "id=? AND user=? AND state!=?";
        String[] selectionArgs = new String[]{itemId, userId, String.valueOf(4)};
        List<ShoppinglistItem> list = this.getItems(selection, selectionArgs);
        return list.isEmpty() ? null : list.get(0);
    }

    public List<ShoppinglistItem> getItems(String shoppinglistId, String userId, boolean includeDeleted) {
        String selection = "shopping_list_id=? AND user=? AND state!=?";
        String[] selectionArgs = new String[]{shoppinglistId, userId, String.valueOf(4)};
        if (includeDeleted) {
            selection = "shopping_list_id=? AND user=?";
            selectionArgs = new String[]{shoppinglistId, userId};
        }
        return this.getItems(selection, selectionArgs);
    }

    public ShoppinglistItem getItemPrevious(String shoppinglistId, String previousId, String userId) {
        String selection = "shopping_list_id=? AND previous_id=? AND user=?";
        String[] selectionArgs = new String[]{shoppinglistId, previousId, userId};
        List<ShoppinglistItem> list = this.getItems(selection, selectionArgs);
        return list.isEmpty() ? null : list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ShoppinglistItem> getItems(String selection, String[] selectionArgs) {
        List<ShoppinglistItem> list;
        Cursor c = null;
        try {
            c = this.acquireDb().query(false, "shoppinglistitems", null, selection, selectionArgs, null, null, null, null);
            list = ItemSQLiteHelper.cursorToList(c);
        }
        catch (IllegalStateException e) {
            ArrayList<ShoppinglistItem> arrayList;
            try {
                this.log(TAG, e);
                arrayList = new ArrayList<ShoppinglistItem>();
            }
            catch (Throwable throwable) {
                DbUtils.closeCursor(c);
                this.releaseDb();
                throw throwable;
            }
            DbUtils.closeCursor(c);
            this.releaseDb();
            return arrayList;
        }
        DbUtils.closeCursor(c);
        this.releaseDb();
        return list;
    }

    public int deleteItem(String itemId, String userId) {
        String whereClause = "id=? AND user=? ";
        String[] whereArgs = new String[]{itemId, userId};
        return this.delete("shoppinglistitems", whereClause, whereArgs);
    }

    public int deleteItems(String shoppinglistId, Boolean state, String userId) {
        String whereClause = "shopping_list_id=? AND user=? ";
        String[] whereArgs = new String[]{shoppinglistId, userId};
        if (state != null) {
            whereClause = "shopping_list_id=? AND user=?  AND tick=?";
            whereArgs = new String[]{shoppinglistId, userId, DbUtils.unescape(state)};
        }
        return this.delete("shoppinglistitems", whereClause, whereArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertShare(Share s, String userId) {
        try {
            ContentValues cv = ShareSQLiteHelper.objectToContentValues(s, userId);
            long l = this.acquireDb().insertWithOnConflict("shares", null, cv, 5);
            return l;
        }
        catch (IllegalStateException e) {
            this.log(TAG, e);
            long l = -1L;
            return l;
        }
        finally {
            this.releaseDb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertShares(Shoppinglist sl, String userId) {
        SQLiteDatabase db = this.acquireDb();
        db.beginTransaction();
        try {
            int count = this.insertSharesTransactionLess(db, sl.getShares().values(), userId);
            db.setTransactionSuccessful();
            int n = count;
            return n;
        }
        catch (IllegalStateException e) {
            this.log(TAG, e);
            int n = -1;
            return n;
        }
        finally {
            db.endTransaction();
            this.releaseDb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertSharesTransactionLess(SQLiteDatabase db, Collection<Share> shares, String userId) {
        db.acquireReference();
        try {
            int count = 0;
            SQLiteStatement s = ShareSQLiteHelper.getInsertStatement(db);
            for (Share share : shares) {
                ShareSQLiteHelper.bind(s, share, userId);
                if (s.executeInsert() <= -1L) continue;
                ++count;
            }
            int n = count;
            return n;
        }
        catch (IllegalStateException e) {
            this.log(TAG, e);
            int n = 0;
            return n;
        }
        finally {
            db.releaseReference();
        }
    }

    public List<Share> getShares(String shoppinglistId, String userId, boolean includeDeleted) {
        String selection = "shopping_list_id=? AND user=? AND state!=?";
        String[] selectionArgs = new String[]{shoppinglistId, userId, String.valueOf(4)};
        if (includeDeleted) {
            selection = "shopping_list_id=? AND user=?";
            selectionArgs = new String[]{shoppinglistId, userId};
        }
        return this.getShares(selection, selectionArgs, shoppinglistId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Share> getShares(String selection, String[] selectionArgs, String shoppinglistId) {
        List<Share> list;
        Cursor c = null;
        try {
            c = this.acquireDb().query(false, "shares", null, selection, selectionArgs, null, null, null, null);
            list = ShareSQLiteHelper.cursorToList(c, shoppinglistId);
        }
        catch (IllegalStateException e) {
            ArrayList<Share> arrayList;
            try {
                this.log(TAG, e);
                arrayList = new ArrayList<Share>();
            }
            catch (Throwable throwable) {
                DbUtils.closeCursor(c);
                this.releaseDb();
                throw throwable;
            }
            DbUtils.closeCursor(c);
            this.releaseDb();
            return arrayList;
        }
        DbUtils.closeCursor(c);
        this.releaseDb();
        return list;
    }

    public int deleteShare(Share s, User user) {
        return this.deleteShare(s.getEmail(), s.getShoppinglistId(), user.getId());
    }

    public int deleteShare(String shareEmail, String shareShoppinglistId, String userId) {
        String whereClause = "email=? AND shopping_list_id=? AND user=?";
        String[] whereArgs = new String[]{shareEmail, shareShoppinglistId, userId};
        return this.delete("shares", whereClause, whereArgs);
    }

    public int deleteShares(String shoppinglistId, String userId) {
        String whereClause = "shopping_list_id=? AND user=? ";
        String[] whereArgs = new String[]{shoppinglistId, userId};
        return this.delete("shares", whereClause, whereArgs);
    }

    public int clean() {
        int c = this.cleanItemsForOfflineUser();
        return c += this.cleanListssForOfflineUser();
    }

    private int cleanItemsForOfflineUser() {
        String whereClause = "user=? AND state=? ";
        String[] whereArgs = new String[]{"-1", String.valueOf(4)};
        return this.delete("shoppinglistitems", whereClause, whereArgs);
    }

    private int cleanListssForOfflineUser() {
        String whereClause = "user=? AND state=? ";
        String[] whereArgs = new String[]{"-1", String.valueOf(4)};
        return this.delete("shoppinglists", whereClause, whereArgs);
    }

    public JSONArray dumpListTable() {
        return this.dumpTable("shoppinglists");
    }

    public JSONArray dumpItemTable() {
        return this.dumpTable("shoppinglistitems");
    }

    public JSONArray dumpShareTable() {
        return this.dumpTable("shares");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray dumpTable(String table) {
        try {
            JSONArray jSONArray = DbUtils.dumpTableToJSONArray(this.acquireDb(), table);
            return jSONArray;
        }
        catch (IllegalStateException e) {
            this.log(TAG, e);
            JSONArray jSONArray = new JSONArray();
            return jSONArray;
        }
        finally {
            this.releaseDb();
        }
    }
}

