/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.api;

import com.shopgun.android.sdk.utils.Utils;

public class Endpoints {
    public static final String CATALOG_LIST = "/v2/catalogs";
    public static final String CATALOG_ID = "/v2/catalogs/";
    public static final String CATALOG_SEARCH = "/v2/catalogs/search";
    public static final String CATALOG_TYPEAHEAD = "/v2/catalogs/typeahead";
    public static final String CATALOG_SUGGEST = "/v2/catalogs/suggest";
    public static final String DEALER_LIST = "/v2/dealers";
    public static final String DEALER_ID = "/v2/dealers/";
    public static final String DEALER_SEARCH = "/v2/dealers/search";
    public static final String DEALER_SUGGEST = "/v2/dealers/suggest";
    public static final String OFFER_LIST = "/v2/offers";
    public static final String OFFER_ID = "/v2/offers/";
    public static final String OFFER_SEARCH = "/v2/offers/search";
    public static final String OFFER_TYPEAHEAD = "/v2/offers/typeahead";
    public static final String STORE_LIST = "/v2/stores";
    public static final String STORE_ID = "/v2/stores/";
    public static final String STORE_SEARCH = "/v2/stores/search";
    public static final String STORE_QUICK_SEARCH = "/v2/stores/quicksearch";
    public static final String FAVORITES_DEALERS_ID = "/v2/favorites/dealers/";
    public static final String FAVORITES_DEALERS_LIST = "/v2/favorites/dealers";
    public static final String SESSIONS = "/v2/sessions";
    public static final String USER = "/v2/users";
    public static final String USER_RESET = "/v2/users/reset";
    public static final String CATEGORIES = "/v2/categories";
    public static final String COUNTRIES = "/v2/countries";
    public static final String PUSH_PAYLOAD_ID = "/v2/push/payloads/";
    public static final String PUSH_DEVICE_ID = "/v2/push/devices";
    public static final String APP_LOG_ENDPOINT = "/v2/admin/utils/apps/log";
    public static final String SHOPPINGLIST_OFFERS = "/v2/shoppinglists/offers";

    public static String offerId(String offerId) {
        return String.format("/v2/offers/%s", offerId);
    }

    public static String storeId(String storeId) {
        return String.format("/v2/stores/%s", storeId);
    }

    public static String dealerId(String dealerId) {
        return String.format("/v2/dealers/%s", dealerId);
    }

    public static String catalogId(String catalogId) {
        return String.format("/v2/catalogs/%s", catalogId);
    }

    public static String catalogPages(String catalogId) {
        return String.format("/v2/catalogs/%s/pages", catalogId);
    }

    public static String catalogHotspots(String catalogId) {
        return String.format("/v2/catalogs/%s/hotspots", catalogId);
    }

    public static String catalogCollect(String catalogId) {
        return String.format("/v2/catalogs/%s/collect", catalogId);
    }

    public static String offerCollect(String offerId) {
        return String.format("/v2/offers/%s/collect", offerId);
    }

    public static String storeCollect(String storeId) {
        return String.format("/v2/stores/%s/collect", storeId);
    }

    public static String facebook(int userId) {
        return String.format("/v2/users/%s/facebook", userId);
    }

    public static String lists(int userId) {
        return String.format("/v2/users/%s/shoppinglists", userId);
    }

    public static String list(int userId, String listId) {
        return String.format("/v2/users/%s/shoppinglists/%s", userId, listId);
    }

    public static String listModified(int userId, String listId) {
        return String.format("/v2/users/%s/shoppinglists/%s/modified", userId, listId);
    }

    public static String listEmpty(int userId, String listId) {
        return String.format("/v2/users/%s/shoppinglists/%s/empty", userId, listId);
    }

    public static String listShares(int userId, String listId) {
        return String.format("/v2/users/%s/shoppinglists/%s/shares", userId, listId);
    }

    public static String listShareEmail(int userId, String listId, String email) {
        return String.format("/v2/users/%s/shoppinglists/%s/shares/%s", userId, listId, Utils.encode(email, "UTF-8"));
    }

    public static String listitems(int userId, String listId) {
        return String.format("/v2/users/%s/shoppinglists/%s/items", userId, listId);
    }

    public static String listitem(int userId, String listId, String itemId) {
        return String.format("/v2/users/%s/shoppinglists/%s/items/%s", userId, listId, itemId);
    }

    public static String listitemModifiedById(int userId, String listId, String itemId) {
        return String.format("/v2/users/%s/shoppinglists/%s/items/%s/modified", userId, listId, itemId);
    }

    public static String pushPayload(String payloadId) {
        return String.format("/v2/push/payloads/%s", payloadId);
    }
}

