/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.SessionManager;
import com.shopgun.android.sdk.Settings;
import com.shopgun.android.sdk.SgnLocation;
import com.shopgun.android.sdk.SgnThreadFactory;
import com.shopgun.android.sdk.api.Environment;
import com.shopgun.android.sdk.api.ThemeEnvironment;
import com.shopgun.android.sdk.database.DatabaseWrapper;
import com.shopgun.android.sdk.log.DefaultLogger;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.log.SgnLogger;
import com.shopgun.android.sdk.model.User;
import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.Network;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.RequestQueue;
import com.shopgun.android.sdk.network.impl.DefaultRedirectProtocol;
import com.shopgun.android.sdk.network.impl.HttpURLNetwork;
import com.shopgun.android.sdk.network.impl.MemoryCache;
import com.shopgun.android.sdk.network.impl.NetworkImpl;
import com.shopgun.android.sdk.shoppinglists.ListManager;
import com.shopgun.android.sdk.shoppinglists.SyncManager;
import com.shopgun.android.sdk.utils.ActivityCounter;
import com.shopgun.android.sdk.utils.Utils;
import com.shopgun.android.sdk.utils.Validator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ShopGun
implements ActivityCounter.OnLifecycleEvent {
    public static final String TAG = Constants.getTag(ShopGun.class);
    public static final int VERSION = 302001;
    private static final int DEFAULT_THREAD_COUNT = 3;
    private static ShopGun mShopGun;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final ActivityCounter mActivityCounter;
    private final Context mContext;
    private String mApiKey;
    private String mApiSecret;
    private String mAppVersion;
    private final Settings mSettings;
    private final SessionManager mSessionManager;
    private final SgnLocation mLocation;
    private final ListManager mListManager;
    private final SyncManager mSyncManager;
    private final RequestQueue mRequestQueue;
    private final ExecutorService mExecutor;
    private boolean mDevelop = false;
    private Environment mEnvironment;
    private ThemeEnvironment mThemeEnvironment;

    private ShopGun(Context context, ExecutorService executorService, Cache cache, Network network, Environment environment, ThemeEnvironment themeEnvironment, boolean develop) {
        this.mContext = context;
        this.mActivityCounter = new ActivityCounter(this, 1000, this.mHandler);
        this.mDevelop = develop;
        this.mEnvironment = environment;
        this.mThemeEnvironment = themeEnvironment;
        this.ensureKeys(this.mContext);
        this.setAppVersion(Utils.getAppVersion(this.mContext));
        this.mExecutor = executorService;
        this.mSettings = new Settings(this.mContext);
        this.mRequestQueue = new RequestQueue(this, cache, network);
        this.mRequestQueue.start();
        this.mLocation = this.mSettings.getLocation();
        this.mSessionManager = new SessionManager(this);
        DatabaseWrapper db = DatabaseWrapper.getInstance(this);
        this.mListManager = new ListManager(this, db);
        this.mSyncManager = new SyncManager(this, db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShopGun getInstance(Context ctx) {
        if (mShopGun != null) return mShopGun;
        Class<ShopGun> clazz = ShopGun.class;
        synchronized (ShopGun.class) {
            if (mShopGun != null) return mShopGun;
            mShopGun = new Builder(ctx).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mShopGun;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasInstance() {
        Class<ShopGun> clazz = ShopGun.class;
        synchronized (ShopGun.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return mShopGun != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRunning() {
        Class<ShopGun> clazz = ShopGun.class;
        synchronized (ShopGun.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ShopGun.hasInstance() && mShopGun.isStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static ShopGun getInstance() {
        Class<ShopGun> clazz = ShopGun.class;
        synchronized (ShopGun.class) {
            if (mShopGun == null) {
                throw new IllegalStateException("ShopGun instance not created. See ShopGun.getInstance(Context)");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mShopGun;
        }
    }

    @Deprecated
    public static ShopGun create(Context ctx) {
        return ShopGun.getInstance(ctx);
    }

    @Deprecated
    public static boolean isCreated() {
        return ShopGun.hasInstance();
    }

    public ExecutorService getExecutor() {
        return this.mExecutor;
    }

    public boolean isOnline() {
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnected();
    }

    public Context getContext() {
        return this.mContext;
    }

    public synchronized String getApiKey() {
        this.ensureKeys(this.mContext);
        return this.mApiKey;
    }

    public String getAppVersion() {
        return this.mAppVersion;
    }

    public void setAppVersion(String appVersion) {
        if (Validator.isAppVersionValid(appVersion)) {
            this.mAppVersion = appVersion;
        }
        SgnLog.v(TAG, "AppVersion: " + String.valueOf(this.mAppVersion));
    }

    public synchronized String getApiSecret() {
        this.ensureKeys(this.mContext);
        return this.mApiSecret;
    }

    public Environment getEnvironment() {
        return this.mEnvironment;
    }

    public void setEnvironment(Environment e) {
        this.mEnvironment = e;
    }

    public ThemeEnvironment getThemeEnvironment() {
        return this.mThemeEnvironment;
    }

    public void setThemeEnvironment(ThemeEnvironment e) {
        this.mThemeEnvironment = e;
    }

    public Request<?> add(Request<?> request) {
        return this.mRequestQueue.add(request);
    }

    public RequestQueue getRequestQueue() {
        return this.mRequestQueue;
    }

    public SessionManager getSessionManager() {
        return this.mSessionManager;
    }

    public User getUser() {
        return this.mSessionManager.getSession().getUser();
    }

    public Settings getSettings() {
        return this.mSettings;
    }

    public SgnLocation getLocation() {
        return this.mLocation;
    }

    public ListManager getListManager() {
        return this.mListManager;
    }

    public SyncManager getSyncManager() {
        return this.mSyncManager;
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public boolean isStarted() {
        return this.mActivityCounter.isStarted();
    }

    public boolean isDevelop() {
        return this.mDevelop;
    }

    @Deprecated
    public synchronized void setDevelop(boolean develop) {
        if (this.mDevelop != develop) {
            this.mDevelop = develop;
            this.mApiKey = null;
            this.mApiSecret = null;
            this.ensureKeys(this.mContext);
        }
    }

    private synchronized boolean isKeySecretOk() {
        if (this.mApiKey == null || this.mApiSecret == null) {
            this.mApiKey = null;
            this.mApiSecret = null;
        }
        return this.mApiKey != null && this.mApiSecret != null;
    }

    private synchronized void ensureKeys(Context c) {
        if (this.isKeySecretOk()) {
            return;
        }
        Bundle b = Utils.getMetaData(c);
        if (b == null) {
            throw new IllegalStateException("Package meta data not available.");
        }
        if (this.isDevelop()) {
            this.mApiKey = b.getString("com.shopgun.android.sdk.develop.api_key");
            this.mApiSecret = b.getString("com.shopgun.android.sdk.develop.api_secret");
            if (this.isKeySecretOk()) {
                SgnLog.i(TAG, "Using development key/secret");
            } else {
                SgnLog.w(TAG, "Debug flag set, but no develop keys found in AndroidManifest.");
            }
        }
        if (!this.isKeySecretOk()) {
            this.mApiKey = b.getString("com.shopgun.android.sdk.api_key");
            this.mApiSecret = b.getString("com.shopgun.android.sdk.api_secret");
        }
        if (!this.isKeySecretOk()) {
            throw new IllegalStateException("API key/secret missing from AndroidManifest.xml");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Class<ShopGun> clazz = ShopGun.class;
        synchronized (ShopGun.class) {
            this.onPerformStop();
            this.clear();
            mShopGun = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void clear() {
        if (!this.isStarted()) {
            this.mSessionManager.invalidate();
            this.mSettings.clear();
            this.mLocation.clear();
            this.mRequestQueue.clear();
            this.mListManager.clear();
            SgnLog.getLogger().getLog().clear();
        }
    }

    public void onStart() {
        this.mActivityCounter.start();
    }

    public void onStop() {
        this.mActivityCounter.stop();
    }

    @Override
    public void onPerformStart() {
        this.mSessionManager.onStart();
        this.mListManager.onStart();
        this.mSyncManager.onStart();
        this.mSettings.incrementUsageCount();
        SgnLog.v(TAG, "onPerformStart");
    }

    @Override
    public void onPerformStop() {
        this.mSettings.saveLocation(this.mLocation);
        this.mListManager.onStop();
        this.mSyncManager.onStop();
        this.mSessionManager.onStop();
        this.mSettings.setLastUsedTimeNow();
        SgnLog.v(TAG, "onPerformStop");
    }

    public static class Builder {
        Context mContext;
        ExecutorService mExecutor;
        Cache mCache;
        Network mNetwork;
        SgnLogger mLog;
        Boolean mDevelop;
        Environment mEnvironment;
        ThemeEnvironment mThemeEnvironment;

        public Builder(Context ctx) {
            if (ctx == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.mContext = ctx.getApplicationContext();
        }

        public Builder setCache(Cache cache) {
            if (cache == null) {
                throw new IllegalArgumentException("Cache must not be null.");
            }
            if (this.mCache != null) {
                throw new IllegalStateException("Cache already set.");
            }
            this.mCache = cache;
            return this;
        }

        public Builder setNetwork(Network network) {
            if (network == null) {
                throw new IllegalArgumentException("Network must not be null.");
            }
            if (this.mNetwork != null) {
                throw new IllegalStateException("Network already set.");
            }
            this.mNetwork = network;
            return this;
        }

        public Builder setExecutorService(ExecutorService executorService) {
            if (executorService == null) {
                throw new IllegalArgumentException("ExecutorService must not be null.");
            }
            if (this.mExecutor != null) {
                throw new IllegalStateException("ExecutorService already set.");
            }
            this.mExecutor = executorService;
            return this;
        }

        public Builder setLogger(SgnLogger logger) {
            if (logger == null) {
                throw new IllegalArgumentException("SgnLogger must not be null.");
            }
            if (this.mLog != null) {
                throw new IllegalStateException("SgnLogger already set.");
            }
            this.mLog = logger;
            return this;
        }

        public Builder setDevelop(boolean develop) {
            if (this.mDevelop != null) {
                throw new IllegalStateException("SgnLogger already set.");
            }
            this.mDevelop = develop;
            return this;
        }

        public Builder setEnvironment(Environment environment) {
            if (environment == null) {
                throw new IllegalArgumentException("Environment must not be null.");
            }
            if (this.mEnvironment != null) {
                throw new IllegalStateException("Environment already set.");
            }
            this.mEnvironment = environment;
            return this;
        }

        public Builder setThemeEnvironment(ThemeEnvironment themeEnvironment) {
            if (themeEnvironment == null) {
                throw new IllegalArgumentException("ThemeEnvironment must not be null.");
            }
            if (this.mThemeEnvironment != null) {
                throw new IllegalStateException("ThemeEnvironment already set.");
            }
            this.mThemeEnvironment = themeEnvironment;
            return this;
        }

        public ShopGun build() {
            if (mShopGun != null) {
                SgnLog.d(TAG, "ShopGun instance already build and set.");
                return mShopGun;
            }
            if (this.mExecutor == null) {
                this.mExecutor = Executors.newFixedThreadPool(3, new SgnThreadFactory());
            }
            if (this.mCache == null) {
                this.mCache = new MemoryCache();
            }
            if (this.mNetwork == null) {
                this.mNetwork = new NetworkImpl(new HttpURLNetwork(new DefaultRedirectProtocol()));
            }
            if (this.mLog == null) {
                this.mLog = new DefaultLogger();
            }
            if (this.mDevelop == null) {
                this.mDevelop = false;
            }
            if (this.mEnvironment == null) {
                this.mEnvironment = Environment.PRODUCTION;
            }
            if (this.mThemeEnvironment == null) {
                this.mThemeEnvironment = ThemeEnvironment.PRODUCTION;
            }
            SgnLog.setLogger(this.mLog);
            mShopGun = new ShopGun(this.mContext, this.mExecutor, this.mCache, this.mNetwork, this.mEnvironment, this.mThemeEnvironment, this.mDevelop);
            return ShopGun.getInstance(this.mContext);
        }
    }
}

