/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.Store;
import com.shopgun.android.sdk.utils.SgnJson;
import org.json.JSONObject;

public class SgnLocation
extends Location {
    public static final String TAG = Constants.getTag(SgnLocation.class);
    public static final int RADIUS_MIN = 0;
    public static final int RADIUS_MAX = 700000;
    public static final int DEFAULT_RADIUS = 100000;
    public static final Parcelable.Creator<SgnLocation> CREATOR = new Parcelable.Creator<SgnLocation>(){

        public SgnLocation createFromParcel(Parcel in) {
            return new SgnLocation(in);
        }

        public SgnLocation[] newArray(int size) {
            return new SgnLocation[size];
        }
    };
    private static final String ERROR_RADIUS = "Radius must be within range %s to %s, provided radius: %s";
    private static final String SHOPGUN_PROVIDER = "shopgun";
    private static final String GMAPS_PROVIDER = "fused";
    private static final String PASSIVE_PROVIDER = "passive";
    private int mRadius = 100000;
    private boolean mSensor = false;
    private String mAddress = null;
    private double mBoundNorth = 0.0;
    private double mBoundEast = 0.0;
    private double mBoundSouth = 0.0;
    private double mBoundWest = 0.0;

    public SgnLocation() {
        super(SHOPGUN_PROVIDER);
    }

    public SgnLocation(SgnLocation l) {
        this();
        this.set(l);
    }

    public static SgnLocation fromJSON(JSONObject object) {
        SgnLocation l = new SgnLocation();
        if (object == null) {
            return l;
        }
        SgnJson o = new SgnJson(object);
        l.setAccuracy(o.getFloat("accuracy"));
        l.setAddress(o.getString("address"));
        l.setAltitude(o.getDouble("altitude"));
        l.setBearing(o.getFloat("bearing"));
        l.setLatitude(o.getDouble("r_lat"));
        l.setLongitude(o.getDouble("r_lng"));
        l.setProvider(o.getString("provider", SHOPGUN_PROVIDER));
        l.setRadius(o.getInt("r_radius", 100000));
        l.setSpeed(o.getFloat("speed"));
        l.setTime(o.getLong("time"));
        l.setSensor(o.getBoolean("r_sensor"));
        double east = o.getDouble("b_east");
        double west = o.getDouble("b_west");
        double north = o.getDouble("b_north");
        double south = o.getDouble("b_south");
        l.setBounds(north, east, south, west);
        return l;
    }

    protected SgnLocation(Parcel in) {
        super(SHOPGUN_PROVIDER);
        this.set((Location)Location.CREATOR.createFromParcel(in));
        this.mRadius = in.readInt();
        this.mSensor = in.readByte() != 0;
        this.mAddress = in.readString();
        this.mBoundNorth = in.readDouble();
        this.mBoundEast = in.readDouble();
        this.mBoundSouth = in.readDouble();
        this.mBoundWest = in.readDouble();
    }

    public static boolean isFromSensor(Location l) {
        String provider = l.getProvider();
        return "gps".equals(provider) || "network".equals(provider) || PASSIVE_PROVIDER.equals(provider) || GMAPS_PROVIDER.equals(provider);
    }

    public static boolean isValidLocation(Location location) {
        return SgnLocation.isValid(location.getLatitude()) && SgnLocation.isValid(location.getLongitude());
    }

    public static boolean isValidLocation(double lat, double lng) {
        return SgnLocation.isValid(lat) && SgnLocation.isValid(lng);
    }

    private static boolean isValid(double coordinate) {
        return !(-0.1 < coordinate) || !(coordinate < 0.1);
    }

    public JSONObject toJSON() {
        SgnJson o = new SgnJson();
        o.put("accuracy", this.getAccuracy());
        o.put("address", this.getAddress());
        o.put("altitude", this.getAltitude());
        o.put("bearing", this.getBearing());
        o.put("r_lat", this.getLatitude());
        o.put("r_lng", this.getLongitude());
        o.put("provider", this.getProvider());
        o.put("r_radius", this.getRadius());
        o.put("speed", this.getSpeed());
        o.put("time", this.getTime());
        o.put("r_sensor", this.isSensor());
        if (this.isBoundsSet()) {
            o.put("b_east", this.getBoundEast());
            o.put("b_north", this.getBoundNorth());
            o.put("b_south", this.getBoundSouth());
            o.put("b_west", this.getBoundWest());
        }
        return o.toJSON();
    }

    public void set(Location l) {
        super.set(l);
        this.mSensor = true;
    }

    public void set(SgnLocation l) {
        super.set((Location)l);
        this.mAddress = l.getAddress();
        this.mBoundEast = l.getBoundEast();
        this.mBoundNorth = l.getBoundNorth();
        this.mBoundSouth = l.getBoundSouth();
        this.mBoundWest = l.getBoundWest();
        this.mRadius = l.getRadius();
        this.mSensor = l.isSensor();
    }

    public int getRadius() {
        return this.mRadius;
    }

    public void setRadius(@IntRange(from=0L, to=700000L) int radius) {
        if (radius < 0 || radius > 700000) {
            throw new IllegalArgumentException(String.format(ERROR_RADIUS, 0, 700000, radius));
        }
        this.mRadius = radius;
        this.setTimeNow();
    }

    public void setLatitude(double latitude) {
        super.setLatitude(latitude);
        this.setTimeNow();
    }

    public void setLongitude(double longitude) {
        super.setLongitude(longitude);
        this.setTimeNow();
    }

    private void setTimeNow() {
        super.setTime(System.currentTimeMillis());
    }

    public boolean isSensor() {
        return this.mSensor;
    }

    public void setSensor(boolean sensor) {
        this.mSensor = sensor;
        this.setTimeNow();
    }

    public String getAddress() {
        return this.mAddress;
    }

    public void setAddress(String address) {
        this.mAddress = address;
        this.setTimeNow();
    }

    public boolean isSet() {
        return SgnLocation.isValidLocation(this);
    }

    public boolean isBoundsSet() {
        return this.mBoundNorth != 0.0 && this.mBoundSouth != 0.0 && this.mBoundEast != 0.0 && this.mBoundWest != 0.0;
    }

    public int distanceTo(Store store) {
        Location tmp = new Location(SHOPGUN_PROVIDER);
        tmp.setLatitude(store.getLatitude().doubleValue());
        tmp.setLongitude(store.getLongitude().doubleValue());
        float dist = this.distanceTo(tmp);
        return (int)dist;
    }

    public void setBounds(double boundNorth, double boundEast, double boundSouth, double boundWest) {
        this.mBoundEast = boundEast;
        this.mBoundNorth = boundNorth;
        this.mBoundSouth = boundSouth;
        this.mBoundWest = boundWest;
        this.setTimeNow();
    }

    public double getBoundEast() {
        return this.mBoundEast;
    }

    public double getBoundNorth() {
        return this.mBoundNorth;
    }

    public double getBoundSouth() {
        return this.mBoundSouth;
    }

    public double getBoundWest() {
        return this.mBoundWest;
    }

    public void clear() {
        super.setAccuracy(0.0f);
        super.setAltitude(0.0);
        super.setBearing(0.0f);
        super.setExtras(null);
        super.setLatitude(0.0);
        super.setLongitude(0.0);
        super.setProvider(SHOPGUN_PROVIDER);
        super.setSpeed(0.0f);
        this.setTimeNow();
        this.mAddress = null;
        this.mBoundEast = 0.0;
        this.mBoundNorth = 0.0;
        this.mBoundSouth = 0.0;
        this.mBoundWest = 0.0;
        this.mRadius = 100000;
        this.mSensor = false;
    }

    public String toString() {
        return "Location[provider=" + this.getProvider() + ", time=" + this.getTime() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", address=[" + this.getAddress() + "]" + ", radius=" + this.mRadius + ", sensor=" + this.mSensor + ", bounds=[west=" + this.getBoundWest() + ", north=" + this.getBoundNorth() + ", east=" + this.getBoundEast() + ", south=" + this.getBoundSouth() + "]" + "]";
    }

    public boolean isValid() {
        return SgnLocation.isValidLocation(this.getLatitude(), this.getLongitude());
    }

    public boolean isSame(SgnLocation other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.mRadius != other.mRadius) {
            return false;
        }
        if (this.mSensor != other.mSensor) {
            return false;
        }
        return !(this.distanceTo(other) > 1.0f);
    }

    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mRadius);
        dest.writeByte((byte)(this.mSensor ? 1 : 0));
        dest.writeString(this.mAddress);
        dest.writeDouble(this.mBoundNorth);
        dest.writeDouble(this.mBoundEast);
        dest.writeDouble(this.mBoundSouth);
        dest.writeDouble(this.mBoundWest);
    }
}

