/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.SgnLocation;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.utils.SharedPreferencesUtils;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class Settings {
    public static final String TAG = Constants.getTag(Settings.class);
    private static final String PREFS_NAME = "com.shopgun.android.sdk_preferences";
    private static final String LAST_USED_VERSION = "last_used_version";
    private static final String LAST_USED_TIME = "last_used_time";
    private static final String USAGE_COUNT = "usage_count";
    private static final String SESSION_JSON = "session_json";
    private static final String SESSION_USER = "session_user";
    private static final String SESSION_FACEBOOK = "session_facebook";
    private static final String LOCATION = "location_json";
    private static final String CLIENT_ID = "client_id";
    private SharedPreferences mSharedPrefs;
    private static boolean mMovedSharedPrefs = false;

    public Settings(Context context) {
        this.mSharedPrefs = Settings.getPrefs(context);
        this.performMigration();
    }

    public static SharedPreferences getPrefs(Context context) {
        if (!mMovedSharedPrefs) {
            mMovedSharedPrefs = true;
            SharedPreferencesUtils.moveSharedPreferences(context, "eta_sdk", PREFS_NAME);
        }
        return context.getSharedPreferences(PREFS_NAME, 0);
    }

    public boolean clear() {
        return this.mSharedPrefs.edit().clear().commit();
    }

    public JSONObject getSessionJson() {
        try {
            String json = this.mSharedPrefs.getString(SESSION_JSON, null);
            return json == null ? null : new JSONObject(json);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public void incrementUsageCount() {
        this.mSharedPrefs.edit().putInt(USAGE_COUNT, this.mSharedPrefs.getInt(USAGE_COUNT, 0)).apply();
    }

    public int getUsageCount() {
        return this.mSharedPrefs.getInt(USAGE_COUNT, 0);
    }

    public long getLastUsedTime() {
        return this.mSharedPrefs.getLong(LAST_USED_TIME, 0L);
    }

    public void setLastUsedTimeNow() {
        this.setLastUsedTime(new Date());
    }

    public void setLastUsedTime(Date lastUsed) {
        this.mSharedPrefs.edit().putLong(LAST_USED_TIME, lastUsed.getTime()).apply();
    }

    public void setSessionJson(JSONObject session) {
        this.mSharedPrefs.edit().putString(SESSION_JSON, session.toString()).apply();
    }

    public String getSessionUser() {
        return this.mSharedPrefs.getString(SESSION_USER, null);
    }

    public boolean setSessionUser(String user) {
        return this.mSharedPrefs.edit().putString(SESSION_USER, user).commit();
    }

    public boolean setSessionFacebook(String token) {
        return this.mSharedPrefs.edit().putString(SESSION_FACEBOOK, token).commit();
    }

    public String getSessionFacebook() {
        return this.mSharedPrefs.getString(SESSION_FACEBOOK, null);
    }

    public boolean saveLocation(SgnLocation l) {
        String loc = l.toJSON().toString();
        return this.mSharedPrefs.edit().putString(LOCATION, loc).commit();
    }

    public SgnLocation getLocation() {
        try {
            String s = this.mSharedPrefs.getString(LOCATION, null);
            if (s != null) {
                return SgnLocation.fromJSON(new JSONObject(s));
            }
        }
        catch (JSONException e) {
            SgnLog.e(TAG, "Not able to parse location json from SharedPreferences", e);
        }
        return new SgnLocation();
    }

    public String getClientId() {
        return this.mSharedPrefs.getString(CLIENT_ID, null);
    }

    public void setClientId(String clientId) {
        this.mSharedPrefs.edit().putString(CLIENT_ID, clientId).apply();
    }

    private void performMigration() {
        int version = this.mSharedPrefs.getInt(LAST_USED_VERSION, 0);
        if (version == 302001) {
            return;
        }
        SharedPreferences.Editor e = this.mSharedPrefs.edit();
        if (version == 0) {
            this.migrateLocation();
            e.putLong(LAST_USED_TIME, this.mSharedPrefs.getLong("last_usage", 0L));
            e.remove("last_usage");
        }
        e.putInt(LAST_USED_VERSION, 302001);
        e.apply();
    }

    private void migrateLocation() {
        if (!this.mSharedPrefs.contains("loc_radius")) {
            return;
        }
        SgnLocation l = new SgnLocation();
        l.setSensor(this.mSharedPrefs.getBoolean("loc_sensor", false));
        l.setRadius(this.mSharedPrefs.getInt("loc_radius", Integer.MAX_VALUE));
        l.setLatitude(this.mSharedPrefs.getFloat("loc_latitude", 0.0f));
        l.setLongitude(this.mSharedPrefs.getFloat("loc_longitude", 0.0f));
        double east = this.mSharedPrefs.getFloat("loc_b_east", 0.0f);
        double west = this.mSharedPrefs.getFloat("loc_b_west", 0.0f);
        double north = this.mSharedPrefs.getFloat("loc_b_north", 0.0f);
        double south = this.mSharedPrefs.getFloat("loc_b_south", 0.0f);
        l.setBounds(north, east, south, west);
        l.setAddress(this.mSharedPrefs.getString("loc_address", null));
        l.setTime(this.mSharedPrefs.getLong("loc_time", System.currentTimeMillis()));
        this.saveLocation(l);
        SharedPreferences.Editor e = this.mSharedPrefs.edit();
        e.remove("loc_address");
        e.remove("loc_b_east");
        e.remove("loc_b_north");
        e.remove("loc_b_south");
        e.remove("loc_b_west");
        e.remove("loc_latitude");
        e.remove("loc_longitude");
        e.remove("loc_radius");
        e.remove("loc_sensor");
        e.remove("loc_time");
        e.apply();
    }
}

