/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk;

import android.content.Context;
import android.os.Environment;
import android.support.v4.content.ContextCompat;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Session;
import com.shopgun.android.sdk.utils.Utils;
import java.io.File;
import java.io.RandomAccessFile;

public class ExternalClientIdStore {
    public static final String TAG = Constants.getTag(ExternalClientIdStore.class);
    private static final String CID_RANDOMJUNK = "randomjunkid";

    public static void updateCid(Session s, ShopGun sgn) {
        String extCid = ExternalClientIdStore.getCid(sgn);
        if (CID_RANDOMJUNK.equals(s.getClientId()) || CID_RANDOMJUNK.equals(extCid)) {
            s.setClientId(Utils.createUUID());
        } else if (s.getClientId() == null) {
            s.setClientId(extCid);
        }
        sgn.getSettings().setClientId(s.getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCid(ShopGun sgn) {
        String cid = sgn.getSettings().getClientId();
        if (cid != null) {
            return cid;
        }
        File cidFile = ExternalClientIdStore.getCidFile(sgn.getContext());
        if (cidFile == null) {
            return null;
        }
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(cidFile, "r");
            long longlength = f.length();
            int length = (int)longlength;
            if ((long)length != longlength) {
                String string = null;
                return string;
            }
            byte[] data = new byte[length];
            f.readFully(data);
            String string = new String(data);
            return string;
        }
        catch (Exception e) {
        }
        finally {
            try {
                f.close();
            }
            catch (Exception e) {}
            ExternalClientIdStore.deleteCidFile(sgn.getContext());
        }
        return null;
    }

    public static void clear(ShopGun sgn) {
        ExternalClientIdStore.deleteCidFile(sgn.getContext());
        sgn.getSettings().setClientId(null);
    }

    private static boolean deleteCidFile(Context c) {
        File f = ExternalClientIdStore.getCidFile(c);
        return f != null && f.exists() && f.delete();
    }

    private static File getCidFile(Context context) {
        if ("mounted".equals(Environment.getExternalStorageState()) && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            try {
                File cacheDir = new File(Environment.getExternalStorageDirectory(), "cache");
                if (!cacheDir.exists() && !cacheDir.mkdirs()) {
                    SgnLog.w(TAG, "External directory couldn't be created");
                    return null;
                }
                String fileName = context.getPackageName() + ".txt";
                return new File(cacheDir, fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

