package com.shitu.epathmap.ui.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.CoordinatorLayout;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.shitu.epathmap.R;
import com.shitu.location.epathmap.utils.DensityUtils;
import com.shitu.location.epathmap.utils.L;

public class MyLocationDialog {

    private final View tvLocShare;
    private Context context;
    private BottomSheetBehavior dialog;
    private LinearLayout llLine;
    private TextView tvLoc;
    private View contentView;
    private int height, currentHeight;
    private String loc;
    private String near;
    private boolean isShowing;

    public MyLocationDialog(Context context, View contentView, String loc, View.OnClickListener sendMyLocClick,
                            View.OnClickListener locShareClick) {
        this.context = context;
        this.contentView = contentView;
        llLine = (LinearLayout) contentView.findViewById(R.id.ll_line);
        llLine.setOnClickListener(view -> expandOrCollapsed());
        tvLoc = (TextView) contentView.findViewById(R.id.tv_loc);
        this.loc = loc;
        tvLoc.setText(loc);
        contentView.findViewById(R.id.tv_send_my_loc).setOnClickListener(sendMyLocClick);
        tvLocShare = contentView.findViewById(R.id.tv_loc_share);
        tvLocShare.setOnClickListener(locShareClick);
        height = DensityUtils.dp2px(context, 175);
        currentHeight = height;
        dialog = BottomSheetBehavior.from(contentView);
        int margin = DensityUtils.dp2px(context, 16);

        CoordinatorLayout.LayoutParams lp = new CoordinatorLayout.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT,
                height);

//        CoordinatorLayout.LayoutParams lp = new CoordinatorLayout.LayoutParams(
//                DensityUtils.getScreenWidth(context) - margin * 2,
//                height);
//        lp.setMargins(margin, 0, margin, 0);
        lp.setBehavior(dialog);
        contentView.setLayoutParams(lp);
    }

    public void setLoc(String loc) {
        this.loc = loc;
        if(!TextUtils.isEmpty(near)){
            tvLoc.setText(this.loc+""+this.near);
        }else {
            tvLoc.setText(this.loc);
        }
    }

    public void setNearRegion(String regionName){
        this.near = context.getString(R.string.epath_closest_to,regionName);
        tvLoc.setText(this.loc+" "+this.near);
    }

    public int getCurrentHeight() {
        return currentHeight;
    }

    public void show() {
        if (dialog != null) {
            dialog.setHideable(false);
            contentView.setVisibility(View.VISIBLE);
            dialog.setState(BottomSheetBehavior.STATE_EXPANDED);
            isShowing = true;
        }
    }

    public void setBottomSheetSlideListener(BottomSheetSlideListener bottomSheetSlideListener) {
        dialog.setBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback() {
            @Override
            public void onStateChanged(@NonNull View bottomSheet, int newState) {
                try {
                    switch (newState) {
                        case BottomSheetBehavior.STATE_HIDDEN:
                            currentHeight = 0;
                            break;
                        case BottomSheetBehavior.STATE_COLLAPSED:
                            currentHeight = DensityUtils.dp2px(context, 25);
                            break;
                        case BottomSheetBehavior.STATE_EXPANDED:
                            currentHeight = height;
                            break;
                    }
                    bottomSheetSlideListener.onStateChanged(newState);
                } catch (Exception e) {
                    L.e("bottomSheet", e.toString());
                }
            }

            @Override
            public void onSlide(@NonNull View bottomSheet, float slideOffset) {

            }
        });
    }

    public void dismiss() {
        if (dialog != null && dialog.getState() != BottomSheetBehavior.STATE_HIDDEN) {
            dialog.setHideable(true);
            dialog.setState(BottomSheetBehavior.STATE_HIDDEN);
            //contentView.setVisibility(View.GONE);
        }
        currentHeight = 0;
        isShowing = false;
    }

    public void collapsed() {
        if (dialog != null && dialog.getState() != BottomSheetBehavior.STATE_HIDDEN) {
            dialog.setState(BottomSheetBehavior.STATE_COLLAPSED);
        }
    }

    public void expandOrCollapsed() {
        if (dialog != null && dialog.getState() == BottomSheetBehavior.STATE_EXPANDED) {
            dialog.setState(BottomSheetBehavior.STATE_COLLAPSED);
        } else if (dialog != null && dialog.getState() == BottomSheetBehavior.STATE_COLLAPSED) {
            dialog.setState(BottomSheetBehavior.STATE_EXPANDED);
        }
    }

    public interface BottomSheetSlideListener {
        void onStateChanged(int state);
    }

    public String getLoc() {
//        return tvLoc.getText().toString();
        return this.loc;
    }

    public boolean isShowing(){
        return isShowing;
    }

    public void setShareLocEnable(boolean enable){
        if(enable){
            tvLocShare.setVisibility(View.VISIBLE);
        }else{
            tvLocShare.setVisibility(View.GONE);
        }
    }

}
