package com.shitu.epathmap;

import android.Manifest;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;

import com.shitu.epathmap.model.bean.EpathUserInfo;
import com.shitu.epathmap.ui.activity.EpathMapActivity;
import com.shitu.epathmap.ui.widget.ConfirmDialog;
import com.shitu.location.epathmap.utils.EpUtils;
import com.iflytek.cloud.SpeechConstant;
import com.iflytek.cloud.SpeechUtility;
import com.shitu.location.epathmap.EpathLocationSDK;
import com.shitu.location.epathmap.utils.MixpanelEvent;
import com.tencent.bugly.crashreport.CrashReport;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;

import static com.shitu.epathmap.ui.activity.EpathMapActivity.REQUEST_ID;
import static com.shitu.epathmap.ui.activity.EpathMapActivity.REQUEST_SHARE_LOC_FLOOR;
import static com.shitu.epathmap.ui.activity.EpathMapActivity.REQUEST_SHARE_LOC_GROUP_ID;
import static com.shitu.epathmap.ui.activity.EpathMapActivity.REQUEST_SHARE_LOC_LAT;
import static com.shitu.epathmap.ui.activity.EpathMapActivity.REQUEST_SHARE_LOC_LNG;
import static com.shitu.epathmap.ui.activity.EpathMapActivity.REQUEST_SHARE_LOC_NAME;
import static com.shitu.location.epathmap.utils.MixpanelConstants.LOC_SHARE_JOIN_FROM_COPY;
import static com.shitu.location.epathmap.utils.MixpanelConstants.LOC_SHARE_JOIN_FROM_URL;
import static com.shitu.location.epathmap.utils.MixpanelConstants.LOC_SHARE_JOIN_TYPE_FRIEND_LOCATION;
import static com.shitu.location.epathmap.utils.MixpanelConstants.LOC_SHARE_JOIN_TYPE_LOCATION_REGION;
import static com.shitu.location.epathmap.utils.MixpanelConstants.LOC_SHARE_JOIN_TYPE_LOC_SHARE;


/**
 * author:lfei
 */
public class EpathMapSDK extends EpathLocationSDK {
    protected static final Object monitor = new Object();
    public static Context context;
    private static Configuration configuration;
    public static String appIdBD;
    private static ConfirmDialog confirmDialog;
    public static EpathUserInfo epUser;

    public static void init(Context context, String appKey) {
        init(new Configuration.Builder(context)
                .appKey(appKey)
                .build());
    }

    public static void init(Configuration c) {
        synchronized (monitor) {
            if (c.context == null) {
                throw new RuntimeException("context is null");
            }
            if (c.appKey == null) {
                throw new RuntimeException("appKey is null");
            }
            context = c.context;
            configuration = c;
            initKDXF();
            initShare();
            initBugly();
        }
    }

    private static void initKDXF() {
        StringBuffer param = new StringBuffer();
        param.append(SpeechConstant.APPID + "=5a21205c");
        param.append(",");
        param.append(SpeechConstant.ENGINE_MODE + "=" + SpeechConstant.MODE_MSC);
        SpeechUtility.createUtility(context, param.toString());
    }

    private static void initShare() {
        if (configuration.shareToWechatListener == null) {
            return;
        }
        Application app = (Application) context;
        app.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks() {


            @Override
            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {

            }

            @Override
            public void onActivityStarted(Activity activity) {

            }


            @Override
            public void onActivityResumed(Activity activity) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    if (ContextCompat.checkSelfPermission(context,
                            Manifest.permission.READ_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED) {
                        doClipboard(activity);
                    }
                } else {
                    doClipboard(activity);
                }
            }

            @Override
            public void onActivityPaused(Activity activity) {
                if (confirmDialog != null) {
                    confirmDialog.dismiss();
                    confirmDialog = null;
                }
            }

            @Override
            public void onActivityStopped(Activity activity) {

            }

            @Override
            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

            }

            @Override
            public void onActivityDestroyed(Activity activity) {

            }
        });
    }

    private static void initBugly(){
        CrashReport.UserStrategy userStrategy = new CrashReport.UserStrategy(context);
        userStrategy.setAppChannel("sdkChannel");
        userStrategy.setAppVersion(BuildConfig.SDK_VERSION);
        userStrategy.setAppPackageName(BuildConfig.APPLICATION_ID);
//        CrashReport.initCrashReport(context, "f79f3fe857", true, userStrategy);
//        CrashReport.initCrashReport(context, "f79f3fe857", true);
//        CrashReport.initCrashReport(context, "d4b7406d58", true);
        CrashReport.initCrashReport(context, "f79f3fe857", false,userStrategy);

    }

    private static String shareName = "", shareGroupId = "";
    private static void doClipboard(Activity activity) {
        String text = EpUtils.getFirstClipboard(context);
        if (text.contains("map_id") && app != null && app.getScheme() != null &&
                text.contains(app.getScheme())) {
            String paramsStr = text.substring(text.indexOf(":") + 1, text.length());
            String[] paramsArray = paramsStr.split("&");
            if (paramsArray.length > 0) {
                List<String> params = Arrays.asList(paramsArray);
                Intent intent = new Intent(context, EpathMapActivity.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                for (int i = 0; i < params.size(); i++) {
                    String[] paramArray = params.get(i).split("=");
                    if (paramArray.length == 2) {
                        if (paramArray[0].equals(EpathMapActivity.REQUEST_ID)) {
                            intent.putExtra(EpathMapActivity.REQUEST_ID, paramArray[1]);
                        } else if (paramArray[0].equals(EpathMapActivity.REQUEST_SHARE_LOC_GROUP_ID)) {
                            shareGroupId = paramArray[1];
                            intent.putExtra(EpathMapActivity.REQUEST_SHARE_LOC_GROUP_ID, shareGroupId);
                        } else if (paramArray[0].equals(EpathMapActivity.REQUEST_SHARE_LOC_NAME)) {
                            try {
                                shareName = URLDecoder.decode(paramArray[1], "UTF-8");
                                intent.putExtra(EpathMapActivity.REQUEST_SHARE_LOC_NAME, shareName);
                            } catch (UnsupportedEncodingException e) {
                                intent.putExtra(EpathMapActivity.REQUEST_SHARE_LOC_NAME, "");
                                e.printStackTrace();
                            }
                        } else if (paramArray[0].equals(EpathMapActivity.REQUEST_SHARE_LOC_FLOOR)) {
                            intent.putExtra(EpathMapActivity.REQUEST_SHARE_LOC_FLOOR, paramArray[1]);
                        } else if (paramArray[0].equals(EpathMapActivity.REQUEST_SHARE_LOC_LAT)) {
                            intent.putExtra(EpathMapActivity.REQUEST_SHARE_LOC_LAT, paramArray[1]);
                        } else if (paramArray[0].equals(EpathMapActivity.REQUEST_SHARE_LOC_LNG)) {
                            intent.putExtra(EpathMapActivity.REQUEST_SHARE_LOC_LNG, paramArray[1]);
                        }
                    }
                }
                confirmDialog = new ConfirmDialog(activity, context.getString(R.string.epath_open_a_map_from_a_link), (dialog, which) -> {
                    if (activity.getClass() == EpathMapActivity.class) {
                        activity.finish();
                    }
                    new Handler().postDelayed(() -> {
                        context.startActivity(intent);
                    }, 1000);
                    EpUtils.clearClipboard(context);
                    if (!TextUtils.isEmpty(shareGroupId)) {
                        MixpanelEvent.locShareJoin(LOC_SHARE_JOIN_FROM_COPY, LOC_SHARE_JOIN_TYPE_LOC_SHARE);
                    } else if (!TextUtils.isEmpty(shareName) && context.getString(R.string.epath_friend_position).equals(shareName)) {
                        MixpanelEvent.locShareJoin(LOC_SHARE_JOIN_FROM_COPY, LOC_SHARE_JOIN_TYPE_FRIEND_LOCATION);
                    } else {
                        MixpanelEvent.locShareJoin(LOC_SHARE_JOIN_FROM_COPY, LOC_SHARE_JOIN_TYPE_LOCATION_REGION);
                    }
                }, (dialog, which) -> EpUtils.clearClipboard(context));
            }
        }
    }

    public static class Configuration {
        private Context context;
        private String appKey;
        private boolean debug;
        private ShareToWechatListener shareToWechatListener;

        public static final class Builder {
            private Context context;
            private String appKey;
            private boolean debug;
            private ShareToWechatListener shareToWechatListener;

            public Builder appKey(String appKey) {
                this.appKey = appKey;
                return this;
            }

            public Builder shareToWechatListener(ShareToWechatListener shareToWechatListener) {
                this.shareToWechatListener = shareToWechatListener;
                return this;
            }

            public Builder debug(boolean debug) {
                this.debug = debug;
                return this;
            }

            public Builder(Context context) {
                this.context = context;
            }

            public Configuration build() {
                return new Configuration(this);
            }
        }

        public Configuration(Builder builder) {
            this.context = builder.context;
            this.appKey = builder.appKey;
            this.debug = builder.debug;
            this.shareToWechatListener = builder.shareToWechatListener;
            EpathLocationSDK.init(new EpathLocationSDK.Configuration.Builder(context)
                    .appKey(appKey)
                    .debug(debug)
                    .hasShareListener(shareToWechatListener != null)
                    .build());
        }
    }

    public static void openEpathMapActivity(Context context, String mapId) {
        Intent intent = new Intent(context, EpathMapActivity.class);
        intent.putExtra(EpathMapActivity.REQUEST_ID, mapId);
        context.startActivity(intent);
    }

    public static void openEpathMapActivity(Context context, String mapId,String targetName , String targetId) {
        Intent intent = new Intent(context, EpathMapActivity.class);
        intent.putExtra(EpathMapActivity.REQUEST_ID, mapId);
        intent.putExtra(EpathMapActivity.REQUEST_TARGET_NAME, targetName);
        intent.putExtra(EpathMapActivity.REQUEST_TARGET_ID, targetId);
        context.startActivity(intent);
    }

    public static ShareToWechatListener getShareToWechatListener() {
        return configuration.shareToWechatListener;
    }

    public static void shareLinkToMapView(Intent i) {
        if (Intent.ACTION_VIEW.equals(i.getAction())) {
            Uri uri = i.getData();
            if (uri != null) {
                String mapId = uri.getQueryParameter(REQUEST_ID);
                String groupId = uri.getQueryParameter(REQUEST_SHARE_LOC_GROUP_ID);
                String name = uri.getQueryParameter(REQUEST_SHARE_LOC_NAME);
                String floor = uri.getQueryParameter(REQUEST_SHARE_LOC_FLOOR);
                String lat = uri.getQueryParameter(REQUEST_SHARE_LOC_LAT);
                String lng = uri.getQueryParameter(REQUEST_SHARE_LOC_LNG);
                Intent intent = new Intent(context, EpathMapActivity.class);
                intent.putExtra(REQUEST_ID, mapId);
                intent.putExtra(REQUEST_SHARE_LOC_GROUP_ID, groupId);
                intent.putExtra(REQUEST_SHARE_LOC_NAME, name);
                intent.putExtra(REQUEST_SHARE_LOC_FLOOR, floor);
                intent.putExtra(REQUEST_SHARE_LOC_LAT, lat);
                intent.putExtra(REQUEST_SHARE_LOC_LNG, lng);
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                context.startActivity(intent);
                if (!TextUtils.isEmpty(groupId)) {
                    MixpanelEvent.locShareJoin(LOC_SHARE_JOIN_FROM_URL, LOC_SHARE_JOIN_TYPE_LOC_SHARE);
                } else if (!TextUtils.isEmpty(name) && context.getString(R.string.epath_friend_position).equals(name)) {
                    MixpanelEvent.locShareJoin(LOC_SHARE_JOIN_FROM_URL, LOC_SHARE_JOIN_TYPE_FRIEND_LOCATION);
                } else {
                    MixpanelEvent.locShareJoin(LOC_SHARE_JOIN_FROM_URL, LOC_SHARE_JOIN_TYPE_LOCATION_REGION);
                }
            }
        }
    }


}