/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.baidu.tts.loopj.AsyncHttpClient;
import com.baidu.tts.loopj.SerializableCookie;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentCookieStore
implements CookieStore {
    private static final String LOG_TAG = "PersistentCookieStore";
    private static final String COOKIE_PREFS = "CookiePrefsFile";
    private static final String COOKIE_NAME_STORE = "names";
    private static final String COOKIE_NAME_PREFIX = "cookie_";
    private boolean omitNonPersistentCookies = false;
    private final ConcurrentHashMap<String, Cookie> cookies;
    private final SharedPreferences cookiePrefs;

    public PersistentCookieStore(Context stringArray) {
        this.cookiePrefs = stringArray.getSharedPreferences(COOKIE_PREFS, 0);
        this.cookies = new ConcurrentHashMap();
        stringArray = this.cookiePrefs.getString(COOKIE_NAME_STORE, null);
        if (stringArray != null) {
            for (String string : TextUtils.split((String)stringArray, (String)",")) {
                String string2 = this.cookiePrefs.getString(COOKIE_NAME_PREFIX.concat(String.valueOf(string)), null);
                if (string2 == null || (string2 = this.decodeCookie(string2)) == null) continue;
                this.cookies.put(string, (Cookie)string2);
            }
            this.clearExpired(new Date());
        }
    }

    public void addCookie(Cookie cookie) {
        if (this.omitNonPersistentCookies && !cookie.isPersistent()) {
            return;
        }
        String string = cookie.getName() + cookie.getDomain();
        if (!cookie.isExpired(new Date())) {
            this.cookies.put(string, cookie);
        } else {
            this.cookies.remove(string);
        }
        SharedPreferences.Editor editor = this.cookiePrefs.edit();
        editor.putString(COOKIE_NAME_STORE, TextUtils.join((CharSequence)",", (Iterable)this.cookies.keySet()));
        editor.putString(COOKIE_NAME_PREFIX.concat(String.valueOf(string)), this.encodeCookie(new SerializableCookie(cookie)));
        editor.commit();
    }

    public void clear() {
        SharedPreferences.Editor editor = this.cookiePrefs.edit();
        for (String string : this.cookies.keySet()) {
            editor.remove(COOKIE_NAME_PREFIX.concat(String.valueOf(string)));
        }
        editor.remove(COOKIE_NAME_STORE);
        editor.commit();
        this.cookies.clear();
    }

    public boolean clearExpired(Date date) {
        boolean bl2 = false;
        SharedPreferences.Editor editor = this.cookiePrefs.edit();
        for (Map.Entry<String, Cookie> entry : this.cookies.entrySet()) {
            String string = entry.getKey();
            if (!entry.getValue().isExpired(date)) continue;
            this.cookies.remove(string);
            editor.remove(COOKIE_NAME_PREFIX.concat(String.valueOf(string)));
            bl2 = true;
        }
        if (bl2) {
            editor.putString(COOKIE_NAME_STORE, TextUtils.join((CharSequence)",", (Iterable)this.cookies.keySet()));
        }
        editor.commit();
        return bl2;
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies.values());
    }

    public void setOmitNonPersistentCookies(boolean bl2) {
        this.omitNonPersistentCookies = bl2;
    }

    public void deleteCookie(Cookie object) {
        object = object.getName() + object.getDomain();
        this.cookies.remove(object);
        SharedPreferences.Editor editor = this.cookiePrefs.edit();
        editor.remove(COOKIE_NAME_PREFIX.concat(String.valueOf(object)));
        editor.commit();
    }

    protected String encodeCookie(SerializableCookie serializableCookie) {
        if (serializableCookie == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(byteArrayOutputStream).writeObject(serializableCookie);
        }
        catch (IOException iOException) {
            AsyncHttpClient.log.d(LOG_TAG, "IOException in encodeCookie", iOException);
            return null;
        }
        return this.byteArrayToHexString(byteArrayOutputStream.toByteArray());
    }

    protected Cookie decodeCookie(String object) {
        object = this.hexStringToByteArray((String)object);
        object = new ByteArrayInputStream((byte[])object);
        Cookie cookie = null;
        try {
            cookie = ((SerializableCookie)new ObjectInputStream((InputStream)object).readObject()).getCookie();
        }
        catch (IOException iOException) {
            AsyncHttpClient.log.d(LOG_TAG, "IOException in decodeCookie", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            AsyncHttpClient.log.d(LOG_TAG, "ClassNotFoundException in decodeCookie", classNotFoundException);
        }
        return cookie;
    }

    protected String byteArrayToHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            if (n3 < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n3));
        }
        return stringBuilder.toString().toUpperCase(Locale.US);
    }

    protected byte[] hexStringToByteArray(String string) {
        int n2 = string.length();
        byte[] byArray = new byte[n2 / 2];
        for (int i2 = 0; i2 < n2; i2 += 2) {
            byArray[i2 / 2] = (byte)((Character.digit(string.charAt(i2), 16) << 4) + Character.digit(string.charAt(i2 + 1), 16));
        }
        return byArray;
    }
}

