package com.shitu.epathmap.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;

import com.shitu.epathmap.R;
import com.shitu.epathmap.base.BasePresenterFragment;
import com.shitu.location.epathmap.model.bean.DataHolder;
import com.shitu.location.epathmap.model.bean.LocationRegionData;
import com.shitu.location.epathmap.model.bean.LocationRegionIconData;
import com.shitu.location.epathmap.model.bean.LocationRegionTagData;
import com.shitu.epathmap.presenter.IView.EpathSearchView;
import com.shitu.epathmap.presenter.EpathSearchPresenter;
import com.shitu.epathmap.ui.activity.EpathMapActivity;
import com.shitu.epathmap.ui.widget.TagContainerLayout;
import com.shitu.epathmap.ui.widget.TagView;
import com.shitu.location.epathmap.utils.KeyboardUtils;
import com.shitu.location.epathmap.utils.MixpanelConstants;
import com.shitu.location.epathmap.utils.MixpanelEvent;
import com.shitu.location.epathmap.utils.SpUtils;
import com.shitu.location.epathmap.utils.T;

import org.json.JSONArray;
import org.json.JSONException;

import java.util.ArrayList;
import java.util.List;

import static com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_ID;
import static com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE;

/**
 * author:lfei
 */
public class EpSearchHistoryFragment extends BasePresenterFragment<EpathSearchPresenter> implements View.OnClickListener,
        EpathSearchView {

    private TagContainerLayout tagContainerLayout, tagHistoryContainerLayout;
    //    private RecyclerView recyclerView;
//    private BaseRecyclerAdapter adapter;
    private List<String> list;
    private ArrayList<LocationRegionData> locationRegionDatas;
    private List<LocationRegionIconData> locationRegionIconDatas;
    private String id, type;
    private ImageView ivClear;

    public static EpSearchHistoryFragment getInstance(String id, String type) {
        EpSearchHistoryFragment fragment = new EpSearchHistoryFragment();
        Bundle bundle = new Bundle();
        bundle.putString(REQUEST_ID, id);
        bundle.putString(REQUEST_TYPE, type);
//        bundle.putParcelableArrayList(REQUEST_REGIONS, locationRegionDatas);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.fragment_search_history;
    }

    @Override
    protected void initView(Bundle saveInstanceState) {
        tagContainerLayout = (TagContainerLayout) view.findViewById(R.id.tagcontainerLayout);
        tagHistoryContainerLayout = (TagContainerLayout) view.findViewById(R.id.tagHistorycontainerLayout);
//        recyclerView = (RecyclerView) view.findViewById(R.id.recyclerView);
        view.findViewById(R.id.iv_clear).setOnClickListener(this);
        ivClear = (ImageView) view.findViewById(R.id.iv_clear);
//        recyclerView.setLayoutManager(new LinearLayoutManager(context));
        id = getArguments().getString(REQUEST_ID);
        type = getArguments().getString(REQUEST_TYPE);
//        locationRegionDatas = getArguments().getParcelableArrayList(REQUEST_REGIONS);
        locationRegionDatas = DataHolder.getInstance().getLocationRegions();
        tagContainerLayout.setOnTagClickListener(new TagView.OnTagClickListener() {
            @Override
            public void onTagClick(int position, String text) {
                if (locationRegionDatas != null && locationRegionDatas.size() > 0) {
                    presenter.queryByGenre(id, locationRegionIconDatas.get(position), locationRegionDatas);
                }
            }

            @Override
            public void onTagLongClick(int position, String text) {

            }

            @Override
            public void onTagCrossClick(int position) {

            }
        });

        tagHistoryContainerLayout.setOnTagClickListener(new TagView.OnTagClickListener() {
            @Override
            public void onTagClick(int position, String text) {
                if (locationRegionDatas != null && locationRegionDatas.size() > 0) {
//                    presenter.queryByGenre(id, locationRegionIconDatas.get(position), locationRegionDatas);
                    presenter.queryByContent(id, list.get(position), MixpanelConstants.SEARCH_FROM_SEARCH_HISTORY, locationRegionDatas);
                }
            }

            @Override
            public void onTagLongClick(int position, String text) {

            }

            @Override
            public void onTagCrossClick(int position) {

            }
        });
    }

    @Override
    protected void initData() {
        locationRegionIconDatas = new ArrayList<>();
        list = new ArrayList<>();
//        adapter = new BaseRecyclerAdapter(list);
//        SearchHistoryDataItem item = new SearchHistoryDataItem(context);
//        item.setOnItemClickListener(position -> {
//            if (list.size() > 0) {
//                presenter.queryByContent(id, list.get(position), MixpanelConstants.SEARCH_FROM_SEARCH_HISTORY, locationRegionDatas);
//            }
//        });
//        item.setOnDeleteClickListener(position -> {
//            if (list.size() > 0) {
//                list.remove(position);
//                adapter.notifyItemRemoved(position);
//                SpUtils.setSearchHistory(context, list.toString());
//            }
//        });
//        adapter.addItemFactory(item);
//        recyclerView.setAdapter(adapter);
        presenter.queryHotGenre(id);
        loadHistory();
    }

    @Override
    protected void lazyLoad() {

    }

    public void loadHistory() {
        list.clear();
        String json = SpUtils.getSearchHistoryJson(context);
        if (!TextUtils.isEmpty(json)) {
            try {
                JSONArray jsonArray = new JSONArray(json);
                for (int i = 0; i < jsonArray.length(); i++) {
                    String content = jsonArray.optString(i);
                    list.add(content);
                }
//                adapter.notifyDataSetChanged();
                ivClear.setVisibility(list.size() == 0 ? View.GONE : View.VISIBLE);
                tagHistoryContainerLayout.setTags(list);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.iv_clear) {
            list.clear();
//            adapter.notifyDataSetChanged();
            tagHistoryContainerLayout.removeAllTags();
            SpUtils.clearSearchHistory(context);
        }
    }

    @Override
    public void queryByContentSuccess(String content, String from, ArrayList<LocationRegionData> searchRegionDatas) {
        MixpanelEvent.search(content, searchRegionDatas.size(), from);
        if (searchRegionDatas.size() == 0) {
            T.showShort(getString(R.string.epath_no_search_result, content));
        } else {
            KeyboardUtils.hideKeyboard(activity);
            Intent intent = new Intent();
            intent.putExtra(EpathMapActivity.RESULT_SEARCH_CONTENT, content);
            intent.putExtra(EpathMapActivity.RESULT_SEARCH_RESULT, searchRegionDatas);
            intent.putExtra(REQUEST_TYPE, type);
            activity.setResult(activity.RESULT_OK, intent);
            new Handler().postDelayed(() -> {
                activity.finish();
            }, 500);
        }
    }

    @Override
    public void queryByGenreSuccess(LocationRegionIconData locationRegionIconData, ArrayList<LocationRegionData> searchRegionDatas) {
        MixpanelEvent.search(locationRegionIconData.getName(), searchRegionDatas.size(), MixpanelConstants.SEARCH_FROM_SEARCH_HOT);
        if (searchRegionDatas.size() == 0) {
            T.showShort(R.string.epath_no_result);
        } else {
            KeyboardUtils.hideKeyboard(activity);
            Intent intent = new Intent();
            intent.putExtra(EpathMapActivity.RESULT_SEARCH_CONTENT, locationRegionIconData.getName());
            intent.putExtra(EpathMapActivity.RESULT_SEARCH_RESULT, searchRegionDatas);
            intent.putExtra(REQUEST_TYPE, type);
            activity.setResult(activity.RESULT_OK, intent);
            new Handler().postDelayed(() -> {
                activity.finish();
            }, 500);
        }
    }

    @Override
    public void queryRegionIconDataSuccess(List<LocationRegionIconData> locationRegionIconDatas) {

    }

    @Override
    public void queryRegionTagDataSuccess(List<LocationRegionTagData> locationRegionTagDatas) {

    }

    @Override
    public void queryHotGenreSuccess(List<String> tags, List<LocationRegionIconData> locationRegionIconDatas) {
        this.locationRegionIconDatas = locationRegionIconDatas;
        tagContainerLayout.setTags(tags);
    }
}
