package com.shitu.epathmap.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.widget.TextView;


import com.shitu.epathmap.R;
import com.shitu.epathmap.ui.adapter.FloorBarAdapter;
import com.shitu.epathmap.ui.utils.GridSpacingItemDecoration;
import com.shitu.epathmap.ui.utils.StatusBarCompat;
import com.shitu.location.epathmap.model.bean.LocationRegionData;
import com.shitu.location.epathmap.utils.MixpanelConstants;
import com.shitu.location.epathmap.utils.MixpanelEvent;

import java.util.List;

import me.imid.swipebacklayout.lib.SwipeBackLayout;
import me.imid.swipebacklayout.lib.app.SwipeBackActivity;

import static com.shitu.epathmap.EpathMapSDK.context;
import static com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE;

public class EpPoiMoreActivity extends SwipeBackActivity {

    public static final String SEARCH_TYPE = "search_type";
    public static final String LIST_STR = "list_str";
    public static final String FLOOR_NAME = "floor_name";
    private RecyclerView recyclerView;
    private FloorBarAdapter floorBarAdapter;
    private List<LocationRegionData> locationRegionDatas;
    private String serachType;
    private TextView tvTitle;

    private SwipeBackLayout mSwipeBackLayout;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        StatusBarCompat.setColor(this, context.getResources().getColor(R.color.colorPrimaryDark));
        setContentView(R.layout.activity_ep_poi_more);

        initSwipeBack();

        initData();
        initAdapter();
    }


    protected void initSwipeBack() {
        // 可以调用该方法，设置是否允许滑动退出
        setSwipeBackEnable(true);
        mSwipeBackLayout = getSwipeBackLayout();
        // 设置滑动方向，可设置EDGE_LEFT, EDGE_RIGHT, EDGE_ALL, EDGE_BOTTOM
        mSwipeBackLayout.setEdgeTrackingEnabled(SwipeBackLayout.EDGE_LEFT);
        // 滑动退出的效果只能从边界滑动才有效果，如果要扩大touch的范围，可以调用这个方法

        mSwipeBackLayout.setEdgeSize(getResources().getDisplayMetrics().widthPixels/4);
    }


    private void initData() {
        Intent intent = getIntent();
        serachType = intent.getStringExtra(SEARCH_TYPE);
        locationRegionDatas = intent.getParcelableArrayListExtra(LIST_STR);
        String name = intent.getStringExtra(FLOOR_NAME);
        recyclerView = (RecyclerView) findViewById(R.id.recyclerView);
        tvTitle = (TextView) findViewById(R.id.tv_title);
        tvTitle.setText(name);
        recyclerView.setLayoutManager(new GridLayoutManager(this, 4,
                GridLayoutManager.VERTICAL,
                false));
        recyclerView.setHasFixedSize(true);
        recyclerView.addItemDecoration(new GridSpacingItemDecoration(4,
                context.getResources().getDimensionPixelOffset(R.dimen.epath_space),
                true));
        findViewById(R.id.iv_back).setOnClickListener(v -> this.finish());
    }

    private void initAdapter() {
        floorBarAdapter = new FloorBarAdapter(R.layout.item_floor_bar_more, locationRegionDatas);
        floorBarAdapter.openLoadAnimation();
        floorBarAdapter.setOnItemClickListener((adapter, view, position) -> {
            LocationRegionData locationRegionData = locationRegionDatas.get(position);
            MixpanelEvent.search(locationRegionData.getName(), 1, MixpanelConstants.SEARCH_FROM_SEARCH_POI);
            Intent intent = new Intent();
            intent.putExtra(EpathMapActivity.RESULT_SELECT_REGION, locationRegionData);
            intent.putExtra(REQUEST_TYPE, serachType);
            setResult(RESULT_OK, intent);
            EpPoiMoreActivity.this.finish();
        });
        recyclerView.setAdapter(floorBarAdapter);
    }
}
