package com.shitu.epathmap.service;

import android.content.res.Resources;
import android.support.annotation.IntRange;
import android.text.TextUtils;
import android.util.SparseArray;

import com.shitu.epathmap.R;

import java.util.ArrayList;

import static com.shitu.location.epathmap.utils.EpConstants.CHANGE_FLOOR_ELEVATOR;
import static com.shitu.location.epathmap.utils.EpConstants.CHANGE_FLOOR_ESCALATOR;
import static com.shitu.location.epathmap.utils.EpConstants.CHANGE_FLOOR_STAIR;
import static com.shitu.location.epathmap.utils.EpConstants.DIRECTION_DOWNSTAIRS;
import static com.shitu.location.epathmap.utils.EpConstants.DIRECTION_REACH;
import static com.shitu.location.epathmap.utils.EpConstants.DIRECTION_BEHIND_LEFT;
import static com.shitu.location.epathmap.utils.EpConstants.DIRECTION_BEHIND_RIGHT;
import static com.shitu.location.epathmap.utils.EpConstants.DIRECTION_LEFT;
import static com.shitu.location.epathmap.utils.EpConstants.DIRECTION_RIGHT;
import static com.shitu.location.epathmap.utils.EpConstants.DIRECTION_STRAIGHT;
import static com.shitu.location.epathmap.utils.EpConstants.DIRECTION_STRAIGHT_LEFT;
import static com.shitu.location.epathmap.utils.EpConstants.DIRECTION_STRAIGHT_RIGHT;
import static com.shitu.location.epathmap.utils.EpConstants.DIRECTION_UPSTAIRS;

import java.util.Locale;

public class NavContentHandler {
    public static final int  NAV_TURN_ROUND = 0;
    public static final int  NAV_REACH_REAL = 1;
    public static final int  NAV_REACH_SIMU = 2;
    public static final int  NAV_GO_ALONG = 3;
    public static final int  NAV_GO_STRAIGHT_CONTINUE = 4;

    private static ArrayList<String> navStringList;
    private static SparseArray<String> directionList;
    private static String[] changeFloorWay;
    private static String nav_early_warning;
    private static String nav_change_floor;
    private static String nav_ahead;
    private static String change_floor_after;
    private static String change_floor_after_voice;
    private static String meter;
    private static String reach;

    private static String locale;
    private static String separator;
    private static String floor;



    public static void init(Resources res){
        navStringList = new ArrayList<>();
        navStringList.add(NAV_TURN_ROUND,res.getString(R.string.epath_nav_turn_round));
        navStringList.add(NAV_REACH_REAL,res.getString(R.string.epath_nav_reach_real));
        navStringList.add(NAV_REACH_SIMU,res.getString(R.string.epath_nav_reach_simu));
        navStringList.add(NAV_GO_ALONG,res.getString(R.string.epath_nav_go_along));
        navStringList.add(NAV_GO_STRAIGHT_CONTINUE,res.getString(R.string.epath_nav_go_straight_continue));

        nav_early_warning = res.getString(R.string.epath_nav_early_warning);
        nav_change_floor = res.getString(R.string.epath_nav_change_floor_hint);

        nav_ahead = res.getString(R.string.epath_nav_ahead);
        change_floor_after = res.getString(R.string.epath_change_floor_after);
        change_floor_after_voice = res.getString(R.string.epath_change_floor_after_voice);

        meter = res.getString(R.string.epath_meter);
        reach = res.getString(R.string.epath_nav_soon_to_reach);
        locale = Locale.getDefault().getLanguage();
        if("en".equals(locale)){
            separator = " ";
        }else{
            separator = "";
        }
        floor = res.getString(R.string.epath_floor);

        directionList = new SparseArray<>();
        directionList.append(DIRECTION_LEFT,res.getString(R.string.epath_nav_turn_left));
        directionList.append(DIRECTION_RIGHT,res.getString(R.string.epath_nav_turn_right));
        directionList.append(DIRECTION_STRAIGHT_LEFT,res.getString(R.string.epath_nav_turn_straight_left));
        directionList.append(DIRECTION_STRAIGHT_RIGHT,res.getString(R.string.epath_nav_turn_straight_right));
        directionList.append(DIRECTION_BEHIND_LEFT,res.getString(R.string.epath_nav_turn_behind_left));
        directionList.append(DIRECTION_BEHIND_RIGHT,res.getString(R.string.epath_nav_turn_behind_right));
        directionList.append(DIRECTION_STRAIGHT,res.getString(R.string.epath_nav_go_straight_please));
        directionList.append(DIRECTION_UPSTAIRS,res.getString(R.string.epath_nav_upstairs));
        directionList.append(DIRECTION_DOWNSTAIRS,res.getString(R.string.epath_nav_downstairs));

        changeFloorWay = new String[3];
        changeFloorWay[CHANGE_FLOOR_STAIR] = res.getString(R.string.epath_take_stair);
        changeFloorWay[CHANGE_FLOOR_ELEVATOR] = res.getString(R.string.epath_take_elevator);
        changeFloorWay[CHANGE_FLOOR_ESCALATOR] = res.getString(R.string.epath_take_escalator);

    }

    public static String getNavString(@IntRange(from=0,to = 4)int type){
        if(navStringList == null){
            return "";
        }
        if(type>=0 && type < navStringList.size()){
            return navStringList.get(type);
        }
        return "";
    }

    public static String getNoticeString(int distance,int direction){
        String result = "";
        if(directionList == null){
            return "";
        }
        if(distance > 0) {
            result += String.format(nav_early_warning, distance + "");
        }

        if(distance == 0){
            result = nav_ahead ;
        }
        if(direction<0 || direction>directionList.size()||TextUtils.isEmpty(directionList.get(direction))){
            if(direction == DIRECTION_REACH){
                result += reach;
            }else {
                return getNavString(NAV_GO_ALONG);
            }
        }else{
            result += directionList.get(direction);
        }

        return result;
    }

    public static String getStraightDistance(int distance){
        return directionList.get(DIRECTION_STRAIGHT)+ separator+ distance + separator +meter;
    }

    public static String getDirectionString(int direction){
        return directionList.get(direction);
    }

    public static String getChangeFloorHint(int type,int direction,String floorName){
        return String.format(nav_change_floor,getChangeFloorWay(type),getDirectionString(direction),floorName);
    }

    private static String getChangeFloorWay(int type){
        if(type >=0 && type < changeFloorWay.length){
            return changeFloorWay[type];
        }else{
            return "";
        }
    }

    public static String getChangeFloorAfterHint(int direction){
        return change_floor_after + getDirectionString(direction);
    }

    public static String getChangeFloorAfterVoice(int direction){
        return change_floor_after_voice + getDirectionString(direction);
    }





    public static String getFloor() {
        return floor;
    }
}
