/*
 * Decompiled with CFR 0.152.
 */
package com.shitu.epathmap.utils;

public class NumUtil {
    public static final String[] enNum = new String[]{"zero", "one", "tow", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen", "twenty", "", "", "", "", "", "", "", "", "", "thirty", "", "", "", "", "", "", "", "", "", "fourty", "", "", "", "", "", "", "", "", "", "fifty", "", "", "", "", "", "", "", "", "", "sixty", "", "", "", "", "", "", "", "", "", "seventy", "", "", "", "", "", "", "", "", "", "eighty", "", "", "", "", "", "", "", "", "", "ninety"};
    public static final String[] enUnit = new String[]{"hundred", "thousand", "million", "billion", "trillion", "quintillion"};

    public static void main(String[] stringArray) {
        System.out.println(NumUtil.analyze(1L));
        System.out.println(NumUtil.analyze(21L));
        System.out.println(NumUtil.analyze(105L));
        System.out.println(NumUtil.analyze(3250L));
        System.out.println(NumUtil.analyze(47826L));
        System.out.println(NumUtil.analyze(56945781L));
    }

    public static String analyze(long l2) {
        return NumUtil.analyze(String.valueOf(l2));
    }

    public static String analyze(String string2) {
        if (!string2.matches("\\d+")) {
            return String.format("%s is not number", string2);
        }
        if ((string2 = string2.replaceAll("^[0]*([1-9]*)", "$1")).length() == 0) {
            return enNum[0];
        }
        if (string2.length() > 9) {
            return "too big";
        }
        int n2 = string2.length() % 3 == 0 ? string2.length() / 3 : string2.length() / 3 + 1;
        if (n2 > enUnit.length) {
            return "too big";
        }
        String[] stringArray = new String[n2];
        int n3 = stringArray.length - 1;
        for (int i2 = string2.length(); i2 > 0; i2 -= 3) {
            stringArray[n3--] = string2.substring(Math.max(i2 - 3, 0), i2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = Integer.valueOf(stringArray[n3]);
            if (n4 >= 100) {
                stringBuilder.append(enNum[n4 / 100]).append(" ").append(enUnit[0]).append(" ");
                if ((n4 %= 100) != 0) {
                    stringBuilder.append("and ");
                }
            }
            if (n4 == 0) continue;
            if (n4 < 20 || n4 % 10 == 0) {
                stringBuilder.append(enNum[n4]).append(" ");
            } else {
                stringBuilder.append(enNum[n4 - n4 % 10]).append(" ");
                stringBuilder.append(enNum[n4 % 10]).append(" ");
            }
            if (n3 == n2 - 1) continue;
            stringBuilder.append(enUnit[n2 - 1 - n3]).append(" ");
        }
        return stringBuilder.toString().trim();
    }
}

