/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import android.os.Looper;
import com.baidu.tts.loopj.AsyncHttpRequest;
import java.lang.ref.WeakReference;

public class RequestHandle {
    private final WeakReference<AsyncHttpRequest> request;

    public RequestHandle(AsyncHttpRequest asyncHttpRequest) {
        this.request = new WeakReference<AsyncHttpRequest>(asyncHttpRequest);
    }

    public boolean cancel(final boolean bl2) {
        final AsyncHttpRequest asyncHttpRequest = (AsyncHttpRequest)this.request.get();
        if (asyncHttpRequest != null) {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                new Thread(new Runnable(){

                    public void run() {
                        asyncHttpRequest.cancel(bl2);
                    }
                }).start();
                return true;
            }
            return asyncHttpRequest.cancel(bl2);
        }
        return false;
    }

    public boolean isFinished() {
        AsyncHttpRequest asyncHttpRequest = (AsyncHttpRequest)this.request.get();
        return asyncHttpRequest == null || asyncHttpRequest.isDone();
    }

    public boolean isCancelled() {
        AsyncHttpRequest asyncHttpRequest = (AsyncHttpRequest)this.request.get();
        return asyncHttpRequest == null || asyncHttpRequest.isCancelled();
    }

    public boolean shouldBeGarbageCollected() {
        boolean bl2 = this.isCancelled() || this.isFinished();
        if (bl2) {
            this.request.clear();
        }
        return bl2;
    }

    public RequestHandle setTag(Object object) {
        AsyncHttpRequest asyncHttpRequest = (AsyncHttpRequest)this.request.get();
        if (asyncHttpRequest != null) {
            asyncHttpRequest.setRequestTag(object);
        }
        return this;
    }

    public Object getTag() {
        AsyncHttpRequest asyncHttpRequest = (AsyncHttpRequest)this.request.get();
        if (asyncHttpRequest == null) {
            return null;
        }
        return asyncHttpRequest.getTag();
    }
}

