package com.shitu.epathmap.ui.widget;

import android.app.Dialog;
import android.content.Context;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;

import com.shitu.epathmap.R;
import com.shitu.location.epathmap.utils.KeyboardUtils;
import com.shitu.location.epathmap.utils.T;

public class LocShareNameDialog {

    private Dialog dialog;
    private View contentView;
    private EditText etName;
    private Context context;

    public LocShareNameDialog(Context context, String userName, OnLocShareNameDialogCallback callback) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.dialog_loc_share_name, null);
        etName = (EditText) contentView.findViewById(R.id.et_name);
        etName.setText(userName);
        if (userName != null) {
            etName.setSelection(userName.length());
        }
        contentView.findViewById(R.id.iv_close).setOnClickListener(v -> {
            dismiss();
            callback.cancel();
        });
        contentView.findViewById(R.id.tv_finish).setOnClickListener(v -> {
            String name = etName.getText().toString();
            if (TextUtils.isEmpty(name.trim())) {
                T.showShort(R.string.epath_empty_content);
                return;
            }
            callback.onFinish(name);
            dismiss();
        });
        dialog = new Dialog(context, R.style.EpathDialogBottom);
        dialog.setContentView(contentView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
        dialog.setCanceledOnTouchOutside(false);
        Window win = dialog.getWindow();
        WindowManager.LayoutParams lp = win.getAttributes();
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
        win.setAttributes(lp);
//        int padding = DensityUtils.dp2px(context, 16);
//        win.getDecorView().setPadding(padding, 0, padding, padding);
        win.setGravity(Gravity.BOTTOM);
        dialog.setCancelable(false);
    }

    public void show() {
        if (dialog.isShowing()) {
            return;
        }
        KeyboardUtils.openKeybord(context, etName);
        dialog.show();
    }

    public void dismiss() {
        if (dialog != null && dialog.isShowing()) {
            etName.setText("");
            KeyboardUtils.closeKeybord(context, etName);
            dialog.dismiss();
        }
    }


    public interface OnLocShareNameDialogCallback {
        void cancel();
        void onFinish(String userName);
    }

}
