/*
 * Decompiled with CFR 0.152.
 */
package com.shitu.epathmap.utils.KeyboardVisibilityEvent;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.shitu.epathmap.utils.KeyboardVisibilityEvent.KeyboardVisibilityEventListener;
import com.shitu.epathmap.utils.KeyboardVisibilityEvent.SimpleUnregister;
import com.shitu.epathmap.utils.KeyboardVisibilityEvent.Unregister;
import com.shitu.location.epathmap.utils.DensityUtils;

public class KeyboardVisibilityEvent {
    private static final int KEYBOARD_VISIBLE_THRESHOLD_DP = 100;

    public static Unregister registerEventListener(final Activity activity, KeyboardVisibilityEventListener object) {
        if (activity == null) {
            throw new NullPointerException("Parameter:activity must not be null");
        }
        int n2 = activity.getWindow().getAttributes().softInputMode;
        if (16 != n2 && n2 != 0) {
            throw new IllegalArgumentException("Parameter:activity window SoftInputMethod is not ADJUST_RESIZE");
        }
        if (object == null) {
            throw new NullPointerException("Parameter:listener must not be null");
        }
        final View view = KeyboardVisibilityEvent.getActivityRoot(activity);
        object = new ViewTreeObserver.OnGlobalLayoutListener((KeyboardVisibilityEventListener)object){
            private final Rect r = new Rect();
            private final int visibleThreshold = Math.round(DensityUtils.dp2px((Context)activity, (float)100.0f));
            private boolean wasOpened = false;
            final /* synthetic */ KeyboardVisibilityEventListener val$listener;
            {
                this.val$listener = keyboardVisibilityEventListener;
            }

            public final void onGlobalLayout() {
                view.getWindowVisibleDisplayFrame(this.r);
                boolean bl2 = view.getRootView().getHeight() - this.r.height() > this.visibleThreshold;
                if (bl2 == this.wasOpened) {
                    return;
                }
                this.wasOpened = bl2;
                this.val$listener.onVisibilityChanged(bl2);
            }
        };
        view.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)object);
        return new SimpleUnregister(activity, (ViewTreeObserver.OnGlobalLayoutListener)object);
    }

    public static boolean isKeyboardVisible(Activity activity) {
        Rect rect = new Rect();
        View view = KeyboardVisibilityEvent.getActivityRoot(activity);
        int n2 = Math.round(DensityUtils.dp2px((Context)activity, (float)100.0f));
        view.getWindowVisibleDisplayFrame(rect);
        return view.getRootView().getHeight() - rect.height() > n2;
    }

    static View getActivityRoot(Activity activity) {
        return ((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
    }
}

