package com.shitu.epathmap.ui.widget;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Paint;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.shitu.epathmap.R;
import com.shitu.epathmap.utils.ShareHandler;
import com.shitu.location.epathmap.utils.Constants;
import com.shitu.location.epathmap.utils.DensityUtils;
import com.shitu.location.epathmap.utils.EpUtils;
import com.shitu.location.epathmap.utils.T;

public class LocShareDialog implements View.OnClickListener {

    private final String packgeName;
    private Pinview pinview;
    private LinearLayout llWechat;
    private LinearLayout llQQ;
    private LinearLayout llMsg;
    private LinearLayout llCopy;
    private TextView tvContent;
    private ImageView ivClose;
    private Dialog dialog;
    private View contentView;
    private Context context;
    private String appName;
    private String shareContent;

    public LocShareDialog(Context context, String mapName, String groupId, String userName, String mapId, View.OnClickListener onClickListener) {
        this.context = context;
        int width = ViewGroup.LayoutParams.MATCH_PARENT;
        int height = ViewGroup.LayoutParams.WRAP_CONTENT;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.dialog_loc_share, null);
        contentView.setLayoutParams(new ViewGroup.LayoutParams(width, height));
        ivClose = (ImageView) contentView.findViewById(R.id.iv_close);
        pinview = (Pinview) contentView.findViewById(R.id.pinview);
        llWechat = (LinearLayout) contentView.findViewById(R.id.ll_wechat);
        llQQ = (LinearLayout) contentView.findViewById(R.id.ll_qq);
        llMsg = (LinearLayout) contentView.findViewById(R.id.ll_msg);
        llCopy = (LinearLayout) contentView.findViewById(R.id.ll_copy);
        tvContent = (TextView) contentView.findViewById(R.id.tv_content);
        pinview.setValue(groupId);
        appName = Constants.getAppName(context);
        packgeName = context.getPackageName();
        shareContent = context.getString(R.string.epath_loc_share_content,
                userName,
                mapName,
                groupId,
                mapId,
                appName,
                packgeName
        );
        tvContent.getViewTreeObserver().addOnGlobalLayoutListener(new OnTvGlobalLayoutListener());
        tvContent.setText(shareContent);
        llWechat.setOnClickListener(this);
        llQQ.setOnClickListener(this);
        llMsg.setOnClickListener(this);
        llCopy.setOnClickListener(this);
        ivClose.setOnClickListener(v -> {
//            MixpanelEvent.locShare(MixpanelConstants.LOC_SHARE_CLICK_CLOSE);
            onClickListener.onClick(v);
            dismiss();
        });
        dialog = new Dialog(context, R.style.EpathDialogDimEnabled);
        dialog.setContentView(contentView);
        dialog.setCanceledOnTouchOutside(false);
        Window win = dialog.getWindow();
        WindowManager.LayoutParams lp = win.getAttributes();
        lp.width = width;
        lp.height = height;
        win.setAttributes(lp);
        int padding = DensityUtils.dp2px(context, 16);
        win.getDecorView().setPadding(padding, 0, padding, padding);
        win.setGravity(Gravity.BOTTOM);
        dialog.setCancelable(false);
    }

    private class OnTvGlobalLayoutListener implements ViewTreeObserver.OnGlobalLayoutListener {
        @Override
        public void onGlobalLayout() {
            tvContent.getViewTreeObserver().removeOnGlobalLayoutListener(this);
            final String newText = autoSplitText(tvContent);
            if (!TextUtils.isEmpty(newText)) {
                tvContent.setText(newText);
            }
        }
    }

    private String autoSplitText(final TextView tv) {
        final String rawText = tv.getText().toString();
        final Paint tvPaint = tv.getPaint();
        final int tvWidth = tv.getWidth() - tv.getPaddingLeft() - tv.getPaddingRight();

        //autoSplitText begin....
        String newText = rawText;
        //autoSplitText end....

        return newText;
    }

    public void show() {
        if (dialog != null && dialog.isShowing()) {
            return;
        }
        dialog.show();
    }

    public void dismiss() {
        if (dialog != null && dialog.isShowing()) {
            pinview.clearEditTextList();
            dialog.dismiss();
        }
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.ll_wechat) {
//            MixpanelEvent.locShare(MixpanelConstants.LOC_SHARE_CLICK_WECHAT);
            ShareHandler.shareToWechat(context, appName, shareContent);
            dismiss();
        } else if (v.getId() == R.id.ll_qq) {
//            MixpanelEvent.locShare(MixpanelConstants.LOC_SHARE_CLICK_QQ);
            ShareHandler.shareToQQ(context, appName, shareContent);
            dismiss();
        } else if (v.getId() == R.id.ll_msg) {
//            MixpanelEvent.locShare(MixpanelConstants.LOC_SHARE_CLICK_SMS);
            ShareHandler.shareToMsg(context, shareContent);
            dismiss();
        } else if (v.getId() == R.id.ll_copy) {
//            MixpanelEvent.locShare(MixpanelConstants.LOC_SHARE_CLICK_COPY);
            EpUtils.copyToClipboard(context, shareContent);
            T.showShort(R.string.epath_copy_success);
            dismiss();
        }

    }

}
