package com.shitu.epathmap.ui.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.CoordinatorLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.shitu.epathmap.R;
import com.shitu.epathmap.ui.adapter.BaseRecyclerAdapter;
import com.shitu.epathmap.ui.item.MapProjectItem;
import com.shitu.epathmap.ui.item.OnItemClickListener;
import com.shitu.epathmap.ui.utils.FixLinearLayoutManager;
import com.shitu.epathmap.ui.utils.TextViewUtilis;
import com.shitu.location.epathmap.model.parse.MapData;
import com.shitu.location.epathmap.utils.DensityUtils;

import java.util.List;

public class MapDistrictDialog extends BottomSheetBehavior.BottomSheetCallback {

    private Context context;
    private BottomSheetBehavior dialog;
    private RecyclerView recyclerView;
    private TextView tvName;
    private ImageView ivIco;
    private View contentView;
    private BaseRecyclerAdapter adapter;
    private int height, currentHeight;

    public MapDistrictDialog(Context context, View contentView, List<MapData> list, OnItemClickListener onItemClickListener) {
        this.context = context;
        this.contentView = contentView;
        recyclerView = (RecyclerView) contentView.findViewById(R.id.recyclerView);
        tvName = (TextView) contentView.findViewById(R.id.tv_name);
        ivIco = (ImageView) contentView.findViewById(R.id.iv_ico);
        String name = list.get(0).getDistrictName() + "地区有 " + list.size() + " 家医院";
        tvName.setText(TextViewUtilis.setPartColorSize(context, name, name.indexOf("有") + 1, name.indexOf("家"), R.color.tvGreen11, 16));
        contentView.findViewById(R.id.ll_line).setOnClickListener(view -> {
            if (getCurrentHeight() != height) {
                show();
            } else {
                collapsed();
            }
        });
        FixLinearLayoutManager layoutManager = new FixLinearLayoutManager(context, LinearLayoutManager.VERTICAL, false);
        layoutManager.setRecycleChildrenOnDetach(true);
        for (int i = 0; i < list.size(); i++) {
            if (list.get(i).isSelected()) {
                layoutManager.scrollToPosition(i);
                break;
            }
        }
        recyclerView.setLayoutManager(layoutManager);
        adapter = new BaseRecyclerAdapter(list);
        MapProjectItem item = new MapProjectItem(context);
        item.setOnItemClickListener(position -> {
            for (MapData mapData : list) {
                mapData.setSelected(false);
            }
            list.get(position).setSelected(true);
            adapter.notifyDataSetChanged();
            onItemClickListener.onClick(position);
        });
        adapter.addItemFactory(item);
        recyclerView.setAdapter(adapter);

        int size = list.size();
        if (size > 3) {
            size = 3;
        }
        height = DensityUtils.dp2px(context, 45 + 80 * size);
        currentHeight = height;
        dialog = BottomSheetBehavior.from(contentView);
        dialog.setBottomSheetCallback(this);
        int margin = DensityUtils.dp2px(context, 16);
        CoordinatorLayout.LayoutParams lp = new CoordinatorLayout.LayoutParams(
                DensityUtils.getScreenWidth(context) - margin * 2,
                height);
        lp.setMargins(margin, 0, margin, 0);
        lp.setBehavior(dialog);
        contentView.setLayoutParams(lp);
    }

    public int getCurrentHeight() {
        return currentHeight;
    }

    public void show() {
        if (dialog != null) {
            contentView.setVisibility(View.VISIBLE);
            dialog.setState(BottomSheetBehavior.STATE_EXPANDED);
        }
    }

    public void dismiss() {
        if (dialog != null) {
            dialog.setState(BottomSheetBehavior.STATE_COLLAPSED);
            contentView.setVisibility(View.GONE);
        }
    }

    public void collapsed() {
        if (dialog != null && dialog.getState() != BottomSheetBehavior.STATE_COLLAPSED) {
            dialog.setState(BottomSheetBehavior.STATE_COLLAPSED);
            contentView.setVisibility(View.VISIBLE);
        }
    }


    @Override
    public void onStateChanged(@NonNull View bottomSheet, int newState) {
        switch (newState) {
            case BottomSheetBehavior.STATE_HIDDEN:
                currentHeight = 0;
                break;
            case BottomSheetBehavior.STATE_COLLAPSED:
                currentHeight = DensityUtils.dp2px(context, 45);
                ivIco.setImageResource(R.drawable.ico_up);
                break;
            case BottomSheetBehavior.STATE_EXPANDED:
                currentHeight = height;
                ivIco.setImageResource(R.drawable.ico_down);
                break;
        }
    }

    @Override
    public void onSlide(@NonNull View bottomSheet, float slideOffset) {

    }


}
