/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import android.os.Message;
import com.baidu.tts.loopj.AsyncHttpClient;
import com.baidu.tts.loopj.AsyncHttpResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.util.ByteArrayBuffer;

public abstract class DataAsyncHttpResponseHandler
extends AsyncHttpResponseHandler {
    private static final String LOG_TAG = "DataAsyncHttpRH";
    protected static final int PROGRESS_DATA_MESSAGE = 7;

    public void onProgressData(byte[] byArray) {
        AsyncHttpClient.log.d(LOG_TAG, "onProgressData(byte[]) was not overriden, but callback was received");
    }

    public final void sendProgressDataMessage(byte[] byArray) {
        this.sendMessage(this.obtainMessage(7, new Object[]{byArray}));
    }

    protected void handleMessage(Message message) {
        super.handleMessage(message);
        switch (message.what) {
            case 7: {
                Object[] objectArray = (Object[])message.obj;
                if (objectArray != null && objectArray.length >= 1) {
                    try {
                        this.onProgressData((byte[])objectArray[0]);
                    }
                    catch (Throwable throwable) {
                        AsyncHttpClient.log.e(LOG_TAG, "custom onProgressData contains an error", throwable);
                    }
                    break;
                }
                AsyncHttpClient.log.e(LOG_TAG, "PROGRESS_DATA_MESSAGE didn't got enough params");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getResponseData(HttpEntity httpEntity) throws IOException {
        InputStream inputStream;
        byte[] byArray = null;
        if (httpEntity != null && (inputStream = httpEntity.getContent()) != null) {
            long l2 = httpEntity.getContentLength();
            if (l2 > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
            }
            if (l2 < 0L) {
                l2 = 4096L;
            }
            try {
                ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer((int)l2);
                try {
                    int n2;
                    byte[] byArray2 = new byte[4096];
                    int n3 = 0;
                    while ((n2 = inputStream.read(byArray2)) != -1 && !Thread.currentThread().isInterrupted()) {
                        byteArrayBuffer.append(byArray2, 0, n2);
                        this.sendProgressDataMessage(DataAsyncHttpResponseHandler.copyOfRange(byArray2, 0, n2));
                        this.sendProgressMessage(n3, l2);
                    }
                }
                finally {
                    AsyncHttpClient.silentCloseInputStream(inputStream);
                }
                byArray = byteArrayBuffer.toByteArray();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.gc();
                throw new IOException("File too large to fit into available memory");
            }
        }
        return byArray;
    }

    public static byte[] copyOfRange(byte[] byArray, int n2, int n3) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, NullPointerException {
        if (n2 > n3) {
            throw new IllegalArgumentException();
        }
        int n4 = byArray.length;
        if (n2 < 0 || n2 > n4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n5 = n3 - n2;
        int n6 = Math.min(n5, n4 - n2);
        byte[] byArray2 = new byte[n5];
        System.arraycopy(byArray, n2, byArray2, 0, n6);
        return byArray2;
    }
}

