package com.shitu.epathmap.ui.widget;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;

import com.shitu.epathmap.R;
import com.shitu.location.epathmap.utils.T;
import com.shitu.location.epathmap.utils.DensityUtils;
import com.shitu.location.epathmap.utils.KeyboardUtils;

public class LocShareJoinDialog {
    private ImageView ivClose;
    private Dialog dialog;
    private View contentView;
    private Context context;
    private Pinview pinview;
    private Button btnCancel;
    private Button btnNext;

    public LocShareJoinDialog(Context context, OnNextClickListener onNextClickListener, DialogInterface.OnDismissListener onDismissListener) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.dialog_loc_share_join, null);
        ivClose = (ImageView) contentView.findViewById(R.id.iv_close);
        pinview = (Pinview) contentView.findViewById(R.id.pinview);
        btnCancel = (Button) contentView.findViewById(R.id.btn_cancel);
        btnNext = (Button) contentView.findViewById(R.id.btn_next);
        ivClose.setOnClickListener(v -> dismiss());
        btnCancel.setOnClickListener(v -> dismiss());
        btnNext.setOnClickListener(v -> {
            String groupId = pinview.getValue();
            if (groupId != null && groupId.length() == 4) {
                onNextClickListener.onClick(groupId);
                dismiss();
            } else {
                T.showShort(R.string.epath_invalid_groupId);
            }
        });
        dialog = new Dialog(context, R.style.EpathDialogCommon);
        dialog.setContentView(contentView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
        dialog.setCanceledOnTouchOutside(false);
        Window win = dialog.getWindow();
        int padding = DensityUtils.dp2px(context, 16);
        win.getDecorView().setPadding(padding, 0, padding, padding);
        WindowManager.LayoutParams lp = win.getAttributes();
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
        win.setAttributes(lp);
        win.setGravity(Gravity.BOTTOM);
        dialog.setCancelable(false);
        dialog.setOnDismissListener(onDismissListener);
    }

    public void show() {
        if (dialog != null && dialog.isShowing()) {
            return;
        }
        KeyboardUtils.openKeybord(context, pinview);
        dialog.show();
    }

    public void dismiss() {
        if (dialog != null && dialog.isShowing()) {
            pinview.clearEditTextList();
            KeyboardUtils.closeKeybord(context, pinview);
            dialog.dismiss();
        }
    }


    public interface OnNextClickListener {
        void onClick(String groupId);
    }

}
