package com.shitu.epathmap.utils;

import com.shitu.location.epathmap.utils.L;

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

import java.util.ArrayList;
import java.util.List;

/**
 * author:lfei
 */

public class JsonParser {

    public static String parseIatResult(String json) {
        try {
            JSONTokener tokener = new JSONTokener(json);
            JSONObject joResult = new JSONObject(tokener);
            List<String> phrases = new ArrayList<>();
            JSONArray words = joResult.optJSONArray("ws");
            for (int i = 0; i < words.length(); i++) {
                // 转写结果词，默认使用第一个结果
                JSONArray items = words.optJSONObject(i).optJSONArray("cw");
                JSONObject obj = items.optJSONObject(0);
                phrases.add(obj.optString("w"));
                L.d("解析中", obj.optString("w"));

            }
            return getKeyword(phrases);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }


    private static String getKeyword(List<String> phrases) {
        String result = "";
        for (int i = 0; i < phrases.size(); i++) {
            String phrase = phrases.get(i);
            if (phrase.equals("我") || phrase.equals("要") || phrase.equals("去") ||
                    phrase.equals("在") || phrase.equals("哪里") || phrase.equals("啊")
                    || phrase.equals("哪儿") || phrase.equals("哪") || phrase.equals("带")
                    || phrase.equals("告诉") || phrase.equals("怎么") || phrase.equals("走")
                    || phrase.equals("请") || phrase.equals("要") || phrase.equals("到")
                    || phrase.equals("想") || phrase.equals("上")) {
                phrases.remove(i);
                i = -1;
            }
        }
        for (int i = 0; i < phrases.size(); i++) {
            String phrase = phrases.get(i);
            result += phrase;
        }
        return result;
    }

    public static String parseGrammarResult(String json) {
        StringBuffer ret = new StringBuffer();
        try {
            JSONTokener tokener = new JSONTokener(json);
            JSONObject joResult = new JSONObject(tokener);

            JSONArray words = joResult.getJSONArray("ws");
            for (int i = 0; i < words.length(); i++) {
                JSONArray items = words.getJSONObject(i).getJSONArray("cw");
                for (int j = 0; j < items.length(); j++) {
                    JSONObject obj = items.getJSONObject(j);
                    if (obj.getString("w").contains("nomatch")) {
                        ret.append("没有匹配结果.");
                        return ret.toString();
                    }
                    ret.append("【结果】" + obj.getString("w"));
                    ret.append("【置信度】 " + obj.getInt("sc"));
                    ret.append("\n ");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            ret.append(" 没有匹配结果 .");
        }
        return ret.toString();
    }


    public static String parseLocalGrammarResult(String json) {
        StringBuffer ret = new StringBuffer();
        try {
            JSONTokener tokener = new JSONTokener(json);
            JSONObject joResult = new JSONObject(tokener);

            JSONArray words = joResult.getJSONArray("ws");
            for (int i = 0; i < words.length(); i++) {
                JSONArray items = words.getJSONObject(i).getJSONArray("cw");
                for (int j = 0; j < items.length(); j++) {
                    JSONObject obj = items.getJSONObject(j);
                    if (obj.getString("w").contains("nomatch")) {
                        ret.append("没有匹配结果.");
                        return ret.toString();
                    }
                    ret.append("【结果】" + obj.getString("w"));
                    ret.append("\n ");
                }
            }
            ret.append("【置信度】 " + joResult.optInt("sc"));

        } catch (Exception e) {
            e.printStackTrace();
            ret.append(" 没有匹配结果 .");
        }
        return ret.toString();
    }

}
