package com.shitu.epathmap.ui.widget;

import android.app.Activity;
import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import android.widget.TextView;

import com.shitu.epathmap.EpathMapSDK;
import com.shitu.epathmap.R;

import com.shitu.epathmap.ui.adapter.BaseRecyclerAdapter;
import com.shitu.epathmap.ui.item.LocationShareItem;
import com.shitu.epathmap.ui.item.OnItemClickListener;
import com.shitu.epathmap.ui.utils.StatusBarCompat;
import com.shitu.location.epathmap.utils.DensityUtils;
import com.shitu.location.epathmap.model.bean.LocationRegionData;

import java.util.List;

public class LocShareDialog2 {

    private Context context;
    private PopupWindow popupWindow;
    private View contentView;
    private RecyclerView recyclerView;
    private BaseRecyclerAdapter adapter;
    private TextView tv_people;
    private List<LocationRegionData> list;
    private String currentObjectId = "";//选中item的objectId

    public LocShareDialog2(Context context, List<LocationRegionData> list0,
                           View.OnClickListener onCloseClickListener, View.OnClickListener onShareClickListener, OnItemClickListener onItemClickListener) {
        this.context = context;
        this.list = list0;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_loc_share2, null);
        tv_people = (TextView) contentView.findViewById(R.id.tv_people);
        recyclerView = (RecyclerView) contentView.findViewById(R.id.recyclerView);
        contentView.findViewById(R.id.iv_close).setOnClickListener(onCloseClickListener);
        contentView.findViewById(R.id.iv_share).setOnClickListener(onShareClickListener);

        if (EpathMapSDK.getShareToWechatListener() == null) {
            contentView.findViewById(R.id.iv_share).setVisibility(View.GONE);
        }
        int count = 0;
        for (LocationRegionData lr : list) {
            if (lr.isActive()) {
                count++;
            }
        }
        tv_people.setText(context.getString(R.string.ipsmap_loc_share_people, count));
        LinearLayoutManager layoutManager = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
        layoutManager.setRecycleChildrenOnDetach(true);
        recyclerView.setLayoutManager(layoutManager);
        if (list.size() > 0 && list.get(0) != null) {
            currentObjectId = list.get(0).getObjectId();
            list.get(0).setSelected(true);
        }
        adapter = new BaseRecyclerAdapter(list);
        LocationShareItem item = new LocationShareItem(context);
        item.setOnItemClickListener(onItemClickListener);
        adapter.addItemFactory(item);
        recyclerView.setAdapter(adapter);

        popupWindow = new PopupWindow(contentView, DensityUtils.getScreenWidth(context),
                DensityUtils.dp2px(context, 115), false);
        popupWindow.setOutsideTouchable(false);
        popupWindow.setAnimationStyle(R.style.IpsmapDialogTop);
    }

    public void notifyDataSetChanged(List<LocationRegionData> list0) {
        if (popupWindow != null) {
            list.clear();
            list.addAll(list0);
            int count = 0;
            for (LocationRegionData lr : list) {
                if (lr != null && lr.isActive()) {
                    count++;
                }
            }
            tv_people.setText(context.getString(R.string.ipsmap_loc_share_people, count));
            boolean checked = false;
            for (int i = 0; i < list.size(); i++) {
                LocationRegionData item = list.get(i);
                if (currentObjectId.equals(item.getObjectId())) {
                    checked = true;
                    item.setSelected(true);
                    break;
                }
            }
            if (!checked && list.size() > 0) {
                currentObjectId = list.get(0).getObjectId();
                list.get(0).setSelected(true);
            }
            adapter.reset(list);
        }
    }


    public void show(View view) {
        if (popupWindow.isShowing()) {
            return;
        }
        popupWindow.showAtLocation(view, Gravity.TOP, 0, 0);
        StatusBarCompat.setColor((Activity) context, context.getResources().getColor(R.color.ipsmap_tvBlack14));
    }


    public void dismiss() {
        if (popupWindow != null && popupWindow.isShowing()) {
            tv_people.setText("");
            popupWindow.dismiss();
            StatusBarCompat.setColor((Activity) context, context.getResources().getColor(R.color.ipsmap_colorPrimaryDark));
        }
    }

}
