package com.shitu.epathmap.ui.item;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.shitu.epathmap.R;
import com.shitu.location.epathmap.model.bean.LocationRegionData;


public class RegionSearchDataItem extends BaseRecyclerItemFactory<RegionSearchDataItem.LocationRegionDataRecyclerItem> {

    Context context;
    String type;
    public static final String START_REGION = "出发", TARGET_REGION = "去这里";
    private OnItemClickListener onItemNavClickListener;

    public RegionSearchDataItem(Context context, String type) {
        this.context = context;
        this.type = type;
    }

    public void setOnItemNavClickListener(OnItemClickListener onItemNavClickListener) {
        this.onItemNavClickListener = onItemNavClickListener;
    }

    @Override
    public boolean isTarget(Object itemObject) {
        return itemObject instanceof LocationRegionData;
    }

    @Override
    public LocationRegionDataRecyclerItem createBaseItem(ViewGroup parent) {
        return new LocationRegionDataRecyclerItem(parent, this);
    }

    public class LocationRegionDataRecyclerItem extends BaseRecyclerItem<LocationRegionData, RegionSearchDataItem> {

        private RelativeLayout rlRoot;
        private TextView tvRegionName, tvFloorName, tvGo, tvDistance;
        private LinearLayout llNav;
        private TextView tvLessDistance;
        private TextView tvIsSameFloor;
        private ImageView ivNav;

        protected LocationRegionDataRecyclerItem(ViewGroup parent, RegionSearchDataItem factory) {
            super(LayoutInflater.from(parent.getContext()).inflate(R.layout.ipsmap_item_region_search, parent, false), factory);
        }

        @Override
        protected void onFindViews(View convertView) {
            rlRoot = (RelativeLayout) convertView.findViewById(R.id.rl_root);
            tvFloorName = (TextView) convertView.findViewById(R.id.tv_floor_name);
            tvRegionName = (TextView) convertView.findViewById(R.id.tv_region_name);
            tvGo = (TextView) convertView.findViewById(R.id.tv_go);
            tvDistance = (TextView) convertView.findViewById(R.id.tv_distance);
            tvLessDistance = (TextView) convertView.findViewById(R.id.tv_less_distance);
            tvIsSameFloor = (TextView) convertView.findViewById(R.id.tv_is_same_floor);
            llNav = (LinearLayout) convertView.findViewById(R.id.ll_nav);
            ivNav = (ImageView) convertView.findViewById(R.id.iv_nav);
        }

        @Override
        protected void onConfigViews(final Context context) {
            if (onItemNavClickListener != null) {
                llNav.setOnClickListener(v -> onItemNavClickListener.onClick(getPosition()));
            }
            if (onItemClickListener != null) {
                rlRoot.setOnClickListener(v -> onItemClickListener.onClick(getPosition()));
            }
        }

        @Override
        protected void onSetData(int position, LocationRegionData item) {
            String buildingName = item.getBuildingName();
            String floorName = "";
            if (!TextUtils.isEmpty(buildingName)) {
                floorName += buildingName;
                floorName += "(" + item.getFloorName() + "F" + ")";
            } else {
                floorName += item.getFloorName() + "F";
            }
            if (item.isFirst()) {
                tvLessDistance.setVisibility(View.VISIBLE);
            } else {
                tvLessDistance.setVisibility(View.GONE);
            }
            if (item.isSameFloor()) {
                tvIsSameFloor.setVisibility(View.VISIBLE);
            } else {
                tvIsSameFloor.setVisibility(View.INVISIBLE);
//                if (item.isFirst()){
//                    tvIsSameFloor.setVisibility(View.VISIBLE);
//                    tvIsSameFloor.setText("不在同层");
//                }
            }

            tvFloorName.setText(floorName);
            tvRegionName.setText(item.getName());
            tvGo.setText(type);
            if (!item.isSelected()) {
                rlRoot.setBackgroundResource(R.color.ipsmap_white);
                tvGo.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey4));
                ivNav.setImageResource(R.drawable.ipsmap_ico_go_small_gray);
            } else {
                rlRoot.setBackgroundResource(R.color.ipsmap_tvGrey6);
                tvGo.setTextColor(context.getResources().getColor(R.color.ipsmap_colorPrimary));
                ivNav.setImageResource(R.drawable.ipsmap_ico_go_small);
            }

            if (item.getDistanceTemp() <= 0) {
                tvDistance.setText("");
            } else {
                tvDistance.setText((int) item.getDistanceTemp() + "m");
            }
        }

    }


}
