package com.shitu.epathmap.base;

import android.os.Bundle;
import android.support.annotation.Nullable;

import com.shitu.epathmap.R;
//import com.daoyixun.location.ipsmap.utils.IpsException;
//import com.daoyixun.location.ipsmap.utils.T;
//import com.daoyixun.location.ipsmap.utils.TUtil;
import com.shitu.location.epathmap.utils.IpsException;
import com.shitu.location.epathmap.utils.T;
import com.shitu.location.epathmap.utils.TUtil;
import com.parse.ParseException;

/**
 * author:lfei
 */
public abstract class BasePresenterActivity<P extends BasePresenter> extends BaseActivity implements IBaseView {

    public P presenter;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        presenter = TUtil.getT(this, 0);
        presenter.attachView(this);
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void onDestroy() {
        presenter.detachView();
        super.onDestroy();
    }

    @Override
    public void handleThrowable(IpsException ex) {
        String message = ex.getMsg();
        if (ex.getCode() == ParseException.OBJECT_NOT_FOUND) {
            T.showShort(R.string.ipsmap_no_result);
        } else if (ex.getCode() != ParseException.CACHE_MISS) {
            T.showShort(message);
        }
    }

}
