/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.speech;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.iflytek.cloud.InitListener;
import com.iflytek.cloud.SpeechUtility;
import com.iflytek.cloud.thirdparty.cb;
import com.iflytek.cloud.thirdparty.ce;
import com.iflytek.speech.ISpeechModule;
import com.iflytek.speech.UtilityConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;

abstract class SpeechModuleAidl<I extends IInterface>
implements ISpeechModule {
    protected Object mSynLock = new Object();
    protected I mService;
    protected Context mContext = null;
    private ServiceConnection mConnection = null;
    private InitListener mInitListener = null;
    private String mBindAction = null;
    private HashMap<String, String> mParams = new HashMap();
    private volatile boolean userDestroy = false;
    private Handler mUiHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message message) {
            if (SpeechModuleAidl.this.mInitListener == null) {
                return;
            }
            SpeechModuleAidl.this.mInitListener.onInit(message.what);
        }
    };

    public SpeechModuleAidl(Context context, InitListener initListener, String string) {
        this.mContext = context;
        this.mInitListener = initListener;
        this.mBindAction = string;
        this.bindService();
    }

    private void bindService() {
        if (!this.isActionInstalled(this.mContext, this.mBindAction)) {
            if (this.mInitListener != null) {
                Message.obtain((Handler)this.mUiHandler, (int)21001, (int)0, (int)0, null).sendToTarget();
            }
            return;
        }
        Intent intent = this.getIntent();
        intent.setAction(this.mBindAction);
        intent.setPackage("com.iflytek.vflynote");
        this.mConnection = new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName object, IBinder iBinder) {
                object = SpeechModuleAidl.this.mSynLock;
                synchronized (object) {
                    Log.d((String)SpeechModuleAidl.this.getTag(), (String)"init success");
                    SpeechModuleAidl.this.mService = SpeechModuleAidl.this.getService(iBinder);
                    Log.d((String)SpeechModuleAidl.this.getTag(), (String)("mService :" + SpeechModuleAidl.this.mService));
                    if (null != SpeechModuleAidl.this.mInitListener) {
                        Message.obtain((Handler)SpeechModuleAidl.this.mUiHandler, (int)0, (int)0, (int)0, null).sendToTarget();
                    }
                    return;
                }
            }

            public void onServiceDisconnected(ComponentName componentName) {
                Log.d((String)SpeechModuleAidl.this.getTag(), (String)"onServiceDisconnected");
                SpeechModuleAidl.this.mService = null;
                if (!SpeechModuleAidl.this.userDestroy) {
                    try {
                        SpeechModuleAidl.this.bindService();
                        return;
                    }
                    catch (Exception exception) {
                        Log.e((String)SpeechModuleAidl.this.getTag(), (String)("rebindService error = " + exception.toString()));
                    }
                }
            }
        };
        try {
            this.mContext.bindService(intent, this.mConnection, 1);
            return;
        }
        catch (SecurityException securityException) {
            cb.a(securityException);
            return;
        }
    }

    private I getService(IBinder iBinder) {
        try {
            String string = ((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]).getName();
            Log.d((String)this.getTag(), (String)("className = " + string));
            return (I)((IInterface)Class.forName(string + "$Stub").getDeclaredMethod("asInterface", IBinder.class).invoke(null, iBinder));
        }
        catch (ClassNotFoundException classNotFoundException) {
            cb.a(classNotFoundException);
        }
        catch (SecurityException securityException) {
            cb.a(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            cb.a(noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            cb.a(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            cb.a(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            cb.a(invocationTargetException);
        }
        catch (Exception exception) {
            cb.a(exception);
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        return this.mService != null;
    }

    @Override
    public int setParameter(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 20012;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.mParams.remove(string);
            return 0;
        }
        this.mParams.put(string, string2);
        return 0;
    }

    @Override
    public String getParameter(String string) {
        return this.mParams.get(string);
    }

    @Override
    public Intent getIntent() {
        HashMap<String, String> hashMap;
        Intent intent = new Intent();
        if (!this.mParams.isEmpty()) {
            for (String object : this.mParams.keySet()) {
                intent.putExtra(object, this.mParams.get(object));
            }
            hashMap = new ce(this.mParams.get("params"), null).c();
            if (hashMap != null && !hashMap.isEmpty()) {
                for (String string : hashMap.keySet()) {
                    intent.putExtra(string, hashMap.get(string));
                }
            }
        }
        hashMap = SpeechUtility.getUtility();
        intent.putExtra("caller.appid", ((SpeechUtility)((Object)hashMap)).getParameter("appid"));
        intent.putExtra("caller.name", UtilityConfig.getCallerInfo(this.mContext, "caller.name"));
        intent.putExtra("caller.pkg", UtilityConfig.getCallerInfo(this.mContext, "caller.pkg"));
        intent.putExtra("caller.ver.name", UtilityConfig.getCallerInfo(this.mContext, "caller.ver.name"));
        intent.putExtra("caller.ver.code", UtilityConfig.getCallerInfo(this.mContext, "caller.ver.code"));
        return intent;
    }

    public boolean isActionInstalled(Context context, String string) {
        if (context == null || TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return (context = context.getPackageManager()).resolveService((Intent)(string = new Intent(string)), 0) != null;
    }

    @Override
    public boolean destory() {
        Log.d((String)this.getTag(), (String)"destory");
        try {
            this.userDestroy = true;
            if (this.mConnection != null) {
                this.mContext.unbindService(this.mConnection);
                this.mConnection = null;
            }
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            cb.a(illegalArgumentException);
            return false;
        }
    }

    protected final String getTag() {
        return this.getClass().toString();
    }
}

