package com.shitu.epathmap.ui.widget;

import android.app.Dialog;
import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;

import com.shitu.epathmap.R;

public class NavFinishCenterDialog {
    private Dialog dialog;
    private View contentView;
    private TextView tvTargetRegion;
    private TextView tvStartRegion;
    private TextView tvDistanceTime;
    private String startRegion;
    private String targetRegion;
    private Context context;


    public NavFinishCenterDialog(Context context) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_nav_finish_center, null);
        tvStartRegion = (TextView) contentView.findViewById(R.id.tv_start_region);
        tvTargetRegion = (TextView) contentView.findViewById(R.id.tv_target_region);
        tvDistanceTime = (TextView) contentView.findViewById(R.id.tv_distance_time);
//        tvClose.setOnClickListener(onClickListener);
        dialog = new Dialog(context, R.style.IpsmapDialogCommon);
        dialog.setContentView(contentView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        dialog.setCanceledOnTouchOutside(false);
        Window win = dialog.getWindow();
        win.getDecorView().setPadding(0, 0, 0, 0);
        WindowManager.LayoutParams lp = win.getAttributes();
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
        win.setAttributes(lp);
        win.setGravity(Gravity.CENTER);
        dialog.setCancelable(false);
    }

    public void setHint(String hint) {
        tvDistanceTime.setText(hint);
    }

    public void setStartRegion(String startRegion) {
        this.startRegion = startRegion;
        tvStartRegion.setText("起点:" + startRegion);
    }

    public String getStartRegion() {
        return startRegion;
    }


    public void setDistanceAndTime(String distanceAndTime) {
        tvDistanceTime.setText(distanceAndTime);
    }

    public void setTargetRegion(String targetRegion) {
        this.targetRegion = targetRegion;
        tvTargetRegion.setText("终点:" + targetRegion);
    }

    public String getTargetRegion() {
        return targetRegion;
    }

    public void show() {
        if (dialog.isShowing()) {
            return;
        }
        dialog.show();
    }

    public void dismiss() {
        if (dialog != null && dialog.isShowing()) {
            tvStartRegion.setText("");
            tvTargetRegion.setText("");
            tvDistanceTime.setText("");
            dialog.dismiss();
        }
    }

}
