package com.shitu.epathmap.ui.adapter;

import android.support.annotation.Nullable;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.shitu.epathmap.R;
import com.shitu.location.epathmap.model.bean.LocationRegionData;

import java.util.List;

/**
 * Created by thinkpad on 2017/12/13.
 */

public class FloorBarAdapter extends BaseQuickAdapter<LocationRegionData, BaseViewHolder> {
    public FloorBarAdapter(int layoutResId, @Nullable List<LocationRegionData> data) {
        super(layoutResId, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, LocationRegionData item) {
//        int space = DensityUtils.dp2px(context, 48);
//        int screenWidth = DensityUtils.getScreenWidth(context);
//        int width = (screenWidth - space) / 4;
//        ImageView imageView = helper.getView(R.id.iv_img);
        helper.setText(R.id.tv_name, item.getName());
        Glide.with(mContext).load(item.getIconUrl()).crossFade().into((ImageView) helper.getView(R.id.iv_img));
//        FrameLayout.LayoutParams layoutParam = (FrameLayout.LayoutParams) imageView.getLayoutParams();
//        layoutParam.height = width;
//        layoutParam.width = width;
//        imageView.setLayoutParams(layoutParam);
    }
}
