package com.shitu.epathmap.ui.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.shitu.epathmap.R;
import com.shitu.epathmap.base.BasePresenterActivity;
import com.shitu.epathmap.presenter.IView.IpsFootprintView;
import com.shitu.epathmap.presenter.IpsFootprintPresenter;
import com.shitu.epathmap.ui.adapter.BaseRecyclerAdapter;
import com.shitu.epathmap.ui.item.LoadMoreRecyclerItemFactory;
import com.shitu.epathmap.ui.item.OnRecyclerLoadMoreListener;
import com.shitu.epathmap.ui.item.footprint.BackGroundDataItem;
import com.shitu.epathmap.ui.item.footprint.BackGroundDataSectorItem;
import com.shitu.epathmap.ui.utils.RecyclerViewDivider;
import com.shitu.epathmap.ui.utils.StatusBarCompat;
import com.shitu.location.epathmap.utils.DensityUtils;
import com.shitu.location.epathmap.utils.IpsUtils;
import com.shitu.location.epathmap.utils.SpUtils;

import java.util.ArrayList;
import java.util.List;

public class IpsFootprintActivity extends BasePresenterActivity<IpsFootprintPresenter> implements
        View.OnClickListener, SwipeRefreshLayout.OnRefreshListener, OnRecyclerLoadMoreListener, IpsFootprintView {

    private static final String REQUEST_MAP_ID = "map_id";
    private RelativeLayout rlTop;
    private SwipeRefreshLayout swipeRefreshLayout;
    private RecyclerView recyclerView;
    private TextView tvId;
    private BaseRecyclerAdapter adapter;
    private List<Object> list;

    public static void start(Context context, String mapId) {
        Intent intent = new Intent(context, IpsFootprintActivity.class);
        intent.putExtra(REQUEST_MAP_ID, mapId);
        context.startActivity(intent);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.ipsmap_activity_footprint;
    }

    @Override
    protected void initView(Bundle saveInstanceState) {
        tvId = (TextView) findViewById(R.id.tv_id);
        rlTop = (RelativeLayout) findViewById(R.id.rl_top);
        swipeRefreshLayout = (SwipeRefreshLayout) findViewById(R.id.swipe_layout);
        recyclerView = (RecyclerView) findViewById(R.id.recyclerView);
        findViewById(R.id.iv_back).setOnClickListener(this);
        String mobile = SpUtils.getUserMobile(context);
        tvId.setText(mobile);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(
                    ViewGroup.LayoutParams.MATCH_PARENT, DensityUtils.dp2px(context, 48));
            lp.setMargins(0, DensityUtils.getStatusBarHeight(context), 0, 0);
            rlTop.setLayoutParams(lp);
        }
        LinearLayoutManager layoutManager = new LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false);
        layoutManager.setRecycleChildrenOnDetach(true);
        recyclerView.setLayoutManager(layoutManager);
        recyclerView.addItemDecoration(new RecyclerViewDivider(context, LinearLayout.VERTICAL));
        swipeRefreshLayout.setColorSchemeResources(R.color.ipsmap_colorAccent);
        swipeRefreshLayout.setProgressViewOffset(false, -20, 150);
        swipeRefreshLayout.setOnRefreshListener(this);
    }


    @Override
    protected void initData() {
        list = new ArrayList<>();
        adapter = new BaseRecyclerAdapter(list);
        adapter.addItemFactory(new BackGroundDataItem(context));
        adapter.addItemFactory(new BackGroundDataSectorItem(context));
        recyclerView.setAdapter(adapter);
        onRefresh();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    public void onRefresh() {
        swipeRefreshLayout.setRefreshing(true);
        String deviceID = IpsUtils.getDeviceID();
        presenter.setPage(1);
        presenter.queryBackgroundData(getIntent().getStringExtra(REQUEST_MAP_ID), deviceID);
    }

    @Override
    public void queryBackgroundDataSuccess(List<Object> list0) {
        swipeRefreshLayout.setRefreshing(false);
        list.clear();
        list.addAll(list0);
        if (presenter.getPage() == 1 && presenter.hasNext()) {
            adapter.enableLoadMore(new LoadMoreRecyclerItemFactory(this));
        }
        if (!presenter.hasNext()) {
            adapter.loadMoreEnd();
        }
        adapter.loadMoreFinished();
        adapter.notifyDataSetChanged();
    }


    @Override
    protected void setStatusBar() {
        StatusBarCompat.setTranslucentForImageView(this, true);
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.iv_back) {
            finish();
        }
    }

    @Override
    public void onLoadMore(BaseRecyclerAdapter adapter) {
        if (swipeRefreshLayout.isRefreshing() && adapter != null) {
            swipeRefreshLayout.setRefreshing(false);
            adapter.loadMoreFinished();
            return;
        }
        String deviceID = IpsUtils.getDeviceID();
        presenter.setPage(presenter.getPage() + 1);
        presenter.queryBackgroundData(getIntent().getStringExtra(REQUEST_MAP_ID), deviceID);
    }
}
