package com.shitu.epathmap.base;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.view.MotionEvent;

import com.baidu.tts.client.SpeechSynthesizer;
import com.bugtags.library.Bugtags;
import com.shitu.epathmap.EpathMapSDK;
import com.shitu.epathmap.R;
import com.shitu.epathmap.ui.utils.StatusBarCompat;
import com.shitu.epathmap.utils.JsonParser;
import com.shitu.location.epathmap.utils.L;
import com.shitu.location.epathmap.utils.T;
import com.shitu.epathmap.utils.VoiceManager;
import com.iflytek.cloud.ErrorCode;
import com.iflytek.cloud.InitListener;
import com.iflytek.cloud.RecognizerResult;
import com.iflytek.cloud.SpeechConstant;
import com.iflytek.cloud.SpeechError;
import com.iflytek.cloud.ui.RecognizerDialog;
import com.iflytek.cloud.ui.RecognizerDialogListener;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.LinkedHashMap;

public abstract class BaseActivity extends AppCompatActivity {

    // 用HashMap存储听写结果
    private HashMap<String, String> mIatResults = new LinkedHashMap<String, String>();
    public Context context;
    private RecognizerDialog recognizerDialog;

    protected static final int MY_PERMISSIONS_REQUEST_ACCESS_FINE_LOCATION = 0x01,
            MY_PERMISSIONS_REQUEST_ACCESS_FINE_WRITE_SD_AND_RECORD_AUDIO = 0x02,
            MY_PERMISSIONS_REQUEST_ACCESS_FINE_WRITE_SD_AND_RECORD_AUDIO_BAIDU = 0x03;
    protected RecognizerResultListener recognizerResultListener;

    private SpeechSynthesizer mSpeechSynthesizer;
    private String mSampleDirPath;
    private static String SAMPLE_DIR_NAME = "baiduTTS";
    private static final String SPEECH_FEMALE_MODEL_NAME = "bd_etts_speech_female.dat";
    private static final String SPEECH_MALE_MODEL_NAME = "bd_etts_speech_male.dat";
    private static final String TEXT_MODEL_NAME = "bd_etts_text.dat";
    //    private static final String LICENSE_FILE_NAME = "temp_license";
    private static final String ENGLISH_SPEECH_FEMALE_MODEL_NAME = "bd_etts_speech_female_en.dat";
    private static final String ENGLISH_SPEECH_MALE_MODEL_NAME = "bd_etts_speech_male_en.dat";
    private static final String ENGLISH_TEXT_MODEL_NAME = "bd_etts_text_en.dat";
    public VoiceManager voiceManager;


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(getLayoutId());
        context = this;
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        setStatusBar();
        initView(savedInstanceState);
        initData();
    }

    @Override
    protected void onResume() {
        super.onResume();
        Bugtags.onResume(this);
    }

    @Override
    protected void onPause() {
        super.onPause();
        Bugtags.onPause(this);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent event) {
        Bugtags.onDispatchTouchEvent(this, event);
        //怀疑和bugtag
        return super.dispatchTouchEvent(event);
    }

    /**
     * 获取应用详情页面intent
     *
     * @return
     */
    private Intent getAppDetailSettingIntent() {
        Intent localIntent = new Intent();
        localIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        if (Build.VERSION.SDK_INT >= 9) {
            localIntent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            localIntent.setData(Uri.fromParts("package", getPackageName(), null));
        } else if (Build.VERSION.SDK_INT <= 8) {
            localIntent.setAction(Intent.ACTION_VIEW);
            localIntent.setClassName("com.android.settings", "com.android.settings.InstalledAppDetails");
            localIntent.putExtra("com.android.settings.ApplicationPkgName", getPackageName());
        }
        return localIntent;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (recognizerDialog != null) {
            recognizerDialog.dismiss();
            recognizerDialog = null;
        }
    }

    protected abstract int getLayoutId();

    protected abstract void initView(Bundle savedInstanceState);

    protected abstract void initData();

    protected void setStatusBar() {
        StatusBarCompat.setColor(this, getResources().getColor(R.color.ipsmap_colorPrimaryDark));
    }

    /**
     * 多权限判断
     *
     * @param permissons
     * @return
     */
    public boolean hasPermission(String... permissons) {
        for (String permisson : permissons) {
            if ((ContextCompat.checkSelfPermission(this,
                    permisson) != PackageManager.PERMISSION_GRANTED)) {
                return false;
            }
        }
        return true;
    }

    // 权限申请
    public void requestPermission(int requestCode, String... permissions) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            requestPermissions(permissions, requestCode);
        }
    }


    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        // super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case MY_PERMISSIONS_REQUEST_ACCESS_FINE_WRITE_SD_AND_RECORD_AUDIO:
                for (int i = 0; i < grantResults.length; i++) {
                    if (grantResults[i] == PackageManager.PERMISSION_DENIED) {
                        T.showShort(R.string.ipsmap_please_grant_permission_write);
                        Intent appDetailSettingIntent = getAppDetailSettingIntent();
                        startActivity(appDetailSettingIntent);
                        finish();
                        return;
                    }
                }
                doSDCardAndRecordAudio();
                break;
            case MY_PERMISSIONS_REQUEST_ACCESS_FINE_WRITE_SD_AND_RECORD_AUDIO_BAIDU:
                for (int i = 0; i < grantResults.length; i++) {
                    if (grantResults[i] == PackageManager.PERMISSION_DENIED) {
                        T.showShort(R.string.ipsmap_please_grant_permission_write);
                        Intent appDetailSettingIntent = getAppDetailSettingIntent();
                        startActivity(appDetailSettingIntent);
                        finish();
                        return;
                    }
                }
                initBaiduVioce();
                break;
            case MY_PERMISSIONS_REQUEST_ACCESS_FINE_LOCATION:
                for (int i = 0; i < grantResults.length; i++) {
                    if (grantResults[i] == PackageManager.PERMISSION_DENIED) {
                        if (i == 0) {
                            T.showShort(R.string.ipsmap_please_grant_location);
                        } else if (i == 1) {
                            T.showShort(R.string.ipsmap_please_grant_permission_write);
                        }

                        Intent appDetailSettingIntent = getAppDetailSettingIntent();
                        startActivity(appDetailSettingIntent);
                        finish();
                        return;
                    }
                }
                permissionGranted();
                break;

        }
    }

    public void initBaiduVioce() {
        voiceManager = VoiceManager.getInstance(EpathMapSDK.context);
    }

    //读写sd业务逻辑
    public void doSDCardAndRecordAudio() {

    }

    //读写sd业务逻辑
    public void permissionGranted() {

    }


    public void stopSpeaking() {
        if (mSpeechSynthesizer != null) {
            mSpeechSynthesizer.stop();
        }
    }


    public void volumeIsTooLow() {
        AudioManager mAudioManager = (AudioManager) getSystemService(Context.AUDIO_SERVICE);
        int max = mAudioManager.getStreamMaxVolume(AudioManager.STREAM_MUSIC);
        int current = mAudioManager.getStreamVolume(AudioManager.STREAM_MUSIC);
        if ((float) current / (float) max < 0.8) {
            T.showShort(R.string.ipsmap_volume_too_low);
            //mAudioManager.setStreamVolume(AudioManager.STREAM_MUSIC, max, AudioManager.STREAM_MUSIC);
        }
    }

    public void startSpeechDialog(RecognizerResultListener recognizerResultListener) {
        this.recognizerResultListener = recognizerResultListener;
        //1. 创建RecognizerDialog对象
        recognizerDialog = new RecognizerDialog(this, new MyInitListener());
        //2. 设置accent、 language等参数
        recognizerDialog.setParameter(SpeechConstant.LANGUAGE, "zh_cn");// 设置中文
        recognizerDialog.setParameter(SpeechConstant.ACCENT, "mandarin");
        // 若要将UI控件用于语义理解，必须添加以下参数设置，设置之后 onResult回调返回将是语义理解
        // 结果
        // recognizerDialog.setParameter("asr_sch", "1");
        // recognizerDialog.setParameter("nlp_version", "2.0");
        //3.设置回调接口
        recognizerDialog.setListener(new MyRecognizerDialogListener());
        //4. 显示dialog，接收语音输入
        recognizerDialog.show();
    }

    class MyInitListener implements InitListener {
        @Override
        public void onInit(int code) {
            if (code != ErrorCode.SUCCESS) {
                //showTip("初始化失败 ");
            }
        }
    }


    class MyRecognizerDialogListener implements RecognizerDialogListener {
        @Override
        public void onResult(RecognizerResult results, boolean isLast) {
            String result = results.getResultString(); //为解析的
            L.d(" 解析前", result);
            String text = JsonParser.parseIatResult(result);//解析过后的
            L.d(" 解析后", text);

            String sn = null;
            // 读取json结果中的 sn字段
            try {
                JSONObject resultJson = new JSONObject(results.getResultString());
                sn = resultJson.optString("sn");
            } catch (JSONException e) {
                e.printStackTrace();
            }

            mIatResults.put(sn, text);//没有得到一句，添加到

            StringBuffer resultBuffer = new StringBuffer();
            for (String key : mIatResults.keySet()) {
                resultBuffer.append(mIatResults.get(key));
            }
            try {
                if (recognizerResultListener != null && isLast) {
                    int size = resultBuffer.lastIndexOf("。");
                    if (resultBuffer.length() > 1 && size >= 1 && size < resultBuffer.length()) {
                        recognizerResultListener.onSuccess(resultBuffer.substring(0, size));
                    } else {
                        recognizerResultListener.onSuccess(resultBuffer.substring(0, resultBuffer.length() - 1));
                    }
                }
            } catch (StringIndexOutOfBoundsException e) {
                T.showShort("索引数组越界!");
            }

        }

        @Override
        public void onError(SpeechError speechError) {
        }
    }

    public interface RecognizerResultListener {
        void onSuccess(String result);
    }

    public void initGPS() {
        LocationManager locationManager = (LocationManager) this.getSystemService(Context.LOCATION_SERVICE);
        // 判断GPS模块是否开启，如果没有则开启
        if (!locationManager.isProviderEnabled(android.location.LocationManager.GPS_PROVIDER)) {
            final AlertDialog.Builder dialog = new AlertDialog.Builder(this);
            dialog.setTitle("请打开GPS连接");
            dialog.setMessage("为了给您提供更好的体验，请先打开GPS");
            dialog.setPositiveButton("设置", new android.content.DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface arg0, int arg1) {
                    // 转到手机设置界面，用户设置GPS
                    Intent intent = new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS);
                    T.showShort("打开后直接点击返回键即可，若不打开返回下次将再次出现");
                    startActivity(intent); // 设置完成后返回到原来的界面
                }
            });
            dialog.setNeutralButton("取消", new android.content.DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface arg0, int arg1) {
                    arg0.dismiss();
                }
            });
            dialog.show();
        } else {

        }
    }
}
