/*
 * Decompiled with CFR 0.152.
 */
package com.shitu.epathmap.ui.widget.wheelview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.Scroller;
import com.shitu.epathmap.R;
import com.shitu.location.epathmap.utils.L;
import java.util.Arrays;
import java.util.List;

public class WheelPicker
extends View
implements Runnable {
    private final String a = "wheelPicker";
    private static final String b = WheelPicker.class.getSimpleName();
    private final Handler c = new Handler();
    private Paint d;
    private Scroller e;
    private VelocityTracker f;
    private a g;
    private b h;
    private Rect i;
    private Rect j;
    private Rect k;
    private Rect l;
    private Camera m;
    private Matrix n;
    private Matrix o;
    private List p;
    private String q;
    private int r;
    private int s;
    private int t;
    private int u;
    private int v;
    private int w;
    private int x;
    private int y;
    private int z;
    private int A;
    private int B;
    private int C;
    private int D;
    private int E;
    private int F;
    private int G;
    private int H;
    private int I;
    private int J;
    private int K;
    private int L = 50;
    private int M = 8000;
    private int N;
    private int O;
    private int P;
    private int Q;
    private int R;
    private int S;
    private int T;
    private int U;
    private int V = 8;
    private boolean W;
    private boolean aa;
    private boolean ab;
    private boolean ac;
    private boolean ad;
    private boolean ae;
    private boolean af;
    private boolean ag;
    private boolean ah;

    public WheelPicker(Context context) {
        this(context, null);
    }

    public WheelPicker(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.IpsmapWheelPicker);
        int n2 = typedArray.getResourceId(R.styleable.IpsmapWheelPicker_wheel_data, 0);
        this.p = Arrays.asList(this.getResources().getStringArray(n2 == 0 ? R.array.IpsmapWheelArrayDefault : n2));
        this.y = typedArray.getDimensionPixelSize(R.styleable.IpsmapWheelPicker_wheel_item_text_size, this.getResources().getDimensionPixelSize(R.dimen.IpsmapWheelItemTextSize));
        this.r = typedArray.getInt(R.styleable.IpsmapWheelPicker_wheel_visible_item_count, 7);
        this.H = typedArray.getInt(R.styleable.IpsmapWheelPicker_wheel_selected_item_position, 0);
        this.W = typedArray.getBoolean(R.styleable.IpsmapWheelPicker_wheel_same_width, false);
        this.S = typedArray.getInt(R.styleable.IpsmapWheelPicker_wheel_maximum_width_text_position, -1);
        this.q = typedArray.getString(R.styleable.IpsmapWheelPicker_wheel_maximum_width_text);
        this.x = typedArray.getColor(R.styleable.IpsmapWheelPicker_wheel_selected_item_text_color, -1);
        this.w = typedArray.getColor(R.styleable.IpsmapWheelPicker_wheel_item_text_color, -7829368);
        this.C = typedArray.getDimensionPixelSize(R.styleable.IpsmapWheelPicker_wheel_item_space, this.getResources().getDimensionPixelSize(R.dimen.IpsmapWheelItemSpace));
        this.ad = typedArray.getBoolean(R.styleable.IpsmapWheelPicker_wheel_cyclic, false);
        this.aa = typedArray.getBoolean(R.styleable.IpsmapWheelPicker_wheel_indicator, false);
        this.A = typedArray.getColor(R.styleable.IpsmapWheelPicker_wheel_indicator_color, -1166541);
        this.z = typedArray.getDimensionPixelSize(R.styleable.IpsmapWheelPicker_wheel_indicator_size, this.getResources().getDimensionPixelSize(R.dimen.IpsmapWheelIndicatorSize));
        this.ab = typedArray.getBoolean(R.styleable.IpsmapWheelPicker_wheel_curtain, false);
        this.B = typedArray.getColor(R.styleable.IpsmapWheelPicker_wheel_curtain_color, -1996488705);
        this.ac = typedArray.getBoolean(R.styleable.IpsmapWheelPicker_wheel_atmospheric, false);
        this.ae = typedArray.getBoolean(R.styleable.IpsmapWheelPicker_wheel_curved, false);
        this.D = typedArray.getInt(R.styleable.IpsmapWheelPicker_wheel_item_align, 0);
        typedArray.recycle();
        this.a();
        this.d = new Paint(69);
        this.d.setTextSize((float)this.y);
        this.c();
        this.b();
        this.e = new Scroller(this.getContext());
        if (Build.VERSION.SDK_INT >= 4) {
            ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
            this.L = viewConfiguration.getScaledMinimumFlingVelocity();
            this.M = viewConfiguration.getScaledMaximumFlingVelocity();
            this.V = viewConfiguration.getScaledTouchSlop();
        }
        this.i = new Rect();
        this.j = new Rect();
        this.k = new Rect();
        this.l = new Rect();
        this.m = new Camera();
        this.n = new Matrix();
        this.o = new Matrix();
    }

    private void a() {
        if (this.r < 2) {
            throw new ArithmeticException("Wheel's visible item count can not be less than 2!");
        }
        if (this.r % 2 == 0) {
            ++this.r;
        }
        this.s = this.r + 2;
        this.t = this.s / 2;
    }

    private void b() {
        this.v = 0;
        this.u = 0;
        if (this.W) {
            this.u = (int)this.d.measureText(String.valueOf(this.p.get(0)));
        } else if (this.a(this.S)) {
            this.u = (int)this.d.measureText(String.valueOf(this.p.get(this.S)));
        } else if (!TextUtils.isEmpty((CharSequence)this.q)) {
            this.u = (int)this.d.measureText(this.q);
        } else {
            for (Object e2 : this.p) {
                String string2 = String.valueOf(e2);
                int n2 = (int)this.d.measureText(string2);
                this.u = Math.max(this.u, n2);
            }
        }
        Paint.FontMetrics fontMetrics = this.d.getFontMetrics();
        this.v = (int)(fontMetrics.bottom - fontMetrics.top);
    }

    private void c() {
        switch (this.D) {
            case 1: {
                this.d.setTextAlign(Paint.Align.LEFT);
                break;
            }
            case 2: {
                this.d.setTextAlign(Paint.Align.RIGHT);
                break;
            }
            default: {
                this.d.setTextAlign(Paint.Align.CENTER);
            }
        }
    }

    protected void onMeasure(int n2, int n3) {
        int n4 = View.MeasureSpec.getMode((int)n2);
        int n5 = View.MeasureSpec.getMode((int)n3);
        int n6 = View.MeasureSpec.getSize((int)n2);
        int n7 = View.MeasureSpec.getSize((int)n3);
        int n8 = this.u;
        int n9 = this.v * this.r + this.C * (this.r - 1);
        if (this.ae) {
            n9 = (int)((double)(2 * n9) / Math.PI);
        }
        if (this.ah) {
            com.shitu.location.epathmap.utils.L.i((String)b, (String)("Wheel's content size is (" + n8 + ":" + n9 + ")"));
        }
        n8 += this.getPaddingLeft() + this.getPaddingRight();
        n9 += this.getPaddingTop() + this.getPaddingBottom();
        if (this.ah) {
            com.shitu.location.epathmap.utils.L.i((String)b, (String)("Wheel's size is (" + n8 + ":" + n9 + ")"));
        }
        n8 = this.a(n4, n6, n8);
        n9 = this.a(n5, n7, n9);
        this.setMeasuredDimension(n8, n9);
    }

    private int a(int n2, int n3, int n4) {
        int n5;
        if (n2 == 0x40000000) {
            n5 = n3;
        } else {
            n5 = n4;
            if (n2 == Integer.MIN_VALUE) {
                n5 = Math.min(n5, n3);
            }
        }
        return n5;
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        this.i.set(this.getPaddingLeft(), this.getPaddingTop(), this.getWidth() - this.getPaddingRight(), this.getHeight() - this.getPaddingBottom());
        if (this.ah) {
            com.shitu.location.epathmap.utils.L.i((String)b, (String)("Wheel's drawn rect size is (" + this.i.width() + ":" + this.i.height() + ") and location is (" + this.i.left + ":" + this.i.top + ")"));
        }
        this.N = this.i.centerX();
        this.O = this.i.centerY();
        this.d();
        this.G = this.i.height() / 2;
        this.E = this.i.height() / this.r;
        this.F = this.E / 2;
        this.e();
        this.f();
        this.g();
    }

    private void d() {
        switch (this.D) {
            case 1: {
                this.P = this.i.left;
                break;
            }
            case 2: {
                this.P = this.i.right;
                break;
            }
            default: {
                this.P = this.N;
            }
        }
        this.Q = (int)((float)this.O - (this.d.ascent() + this.d.descent()) / 2.0f);
    }

    private void e() {
        int n2 = this.H * this.E;
        this.J = this.ad ? Integer.MIN_VALUE : -this.E * (this.p.size() - 1) + n2 + this.getPaddingBottom();
        this.K = this.ad ? Integer.MAX_VALUE : n2 - this.getPaddingTop();
    }

    private void f() {
        if (!this.aa) {
            return;
        }
        int n2 = this.z / 2;
        int n3 = this.O + this.F;
        int n4 = this.O - this.F;
        this.j.set(this.i.left, n3 - n2, this.i.right, n3 + n2);
        this.k.set(this.i.left, n4 - n2, this.i.right, n4 + n2);
    }

    private void g() {
        if (!this.ab && this.x == -1) {
            return;
        }
        this.l.set(this.i.left, this.O - this.F, this.i.right, this.O + this.F);
    }

    protected void onDraw(Canvas canvas) {
        if (null != this.h) {
            this.h.a(this.R);
        }
        int n2 = -this.R / this.E - this.t;
        int n3 = n2 + this.H + this.s;
        int n4 = n2 + this.H;
        int n5 = -this.t;
        while (n4 < n3) {
            int n6;
            String string2 = "";
            if (this.ad) {
                int n7 = n4 % this.p.size();
                n7 = n7 < 0 ? n7 + this.p.size() : n7;
                string2 = String.valueOf(this.p.get(n7));
            } else if (this.a(n4)) {
                string2 = String.valueOf(this.p.get(n4));
            }
            this.d.setColor(this.w);
            Typeface typeface = Typeface.create((Typeface)Typeface.SANS_SERIF, (int)1);
            this.d.setTypeface(typeface);
            this.d.setStyle(Paint.Style.FILL);
            int n8 = this.Q + n5 * this.E + this.R % this.E;
            int n9 = 0;
            if (this.ae) {
                float f2 = (float)(this.Q - Math.abs(this.Q - n8) - this.i.top) * 1.0f / (float)(this.Q - this.i.top);
                n6 = 0;
                if (n8 > this.Q) {
                    n6 = 1;
                } else if (n8 < this.Q) {
                    n6 = -1;
                }
                float f3 = -(1.0f - f2) * 90.0f * (float)n6;
                if (f3 < -90.0f) {
                    f3 = -90.0f;
                }
                if (f3 > 90.0f) {
                    f3 = 90.0f;
                }
                n9 = this.b((int)f3);
                int n10 = this.N;
                switch (this.D) {
                    case 1: {
                        n10 = this.i.left;
                        break;
                    }
                    case 2: {
                        n10 = this.i.right;
                    }
                }
                int n11 = this.O - n9;
                this.m.save();
                this.m.rotateX(f3);
                this.m.getMatrix(this.n);
                this.m.restore();
                this.n.preTranslate((float)(-n10), (float)(-n11));
                this.n.postTranslate((float)n10, (float)n11);
                this.m.save();
                this.m.translate(0.0f, 0.0f, (float)this.c((int)f3));
                this.m.getMatrix(this.o);
                this.m.restore();
                this.o.preTranslate((float)(-n10), (float)(-n11));
                this.o.postTranslate((float)n10, (float)n11);
                this.n.postConcat(this.o);
            }
            if (this.ac) {
                int n12 = (int)((float)(this.Q - Math.abs(this.Q - n8)) * 0.6f / (float)this.Q * 200.0f);
                n12 = n12 < 0 ? 0 : n12;
                this.d.setAlpha(n12);
            }
            int n13 = this.ae ? this.Q - n9 : n8;
            n13 += this.getPaddingTop();
            if (this.x != -1) {
                canvas.save();
                if (this.ae) {
                    canvas.concat(this.n);
                }
                canvas.clipRect(this.l, Region.Op.DIFFERENCE);
                canvas.drawText(string2, (float)this.P, (float)n13, this.d);
                canvas.restore();
                this.d.setColor(this.x);
                canvas.save();
                if (this.ae) {
                    canvas.concat(this.n);
                }
                canvas.clipRect(this.l);
                canvas.drawText(string2, (float)this.P, (float)n13, this.d);
                canvas.restore();
            } else {
                canvas.save();
                canvas.clipRect(this.i);
                if (this.ae) {
                    canvas.concat(this.n);
                }
                canvas.drawText(string2, (float)this.P, (float)n13, this.d);
                canvas.restore();
            }
            if (this.ah) {
                canvas.save();
                canvas.clipRect(this.i);
                this.d.setColor(-1166541);
                n6 = this.O + n5 * this.E;
                canvas.drawLine((float)this.i.left, (float)n6, (float)this.i.right, (float)n6, this.d);
                this.d.setColor(-13421586);
                this.d.setStyle(Paint.Style.STROKE);
                int n14 = n6 - this.F;
                canvas.drawRect((float)this.i.left, (float)n14, (float)this.i.right, (float)(n14 + this.E), this.d);
                canvas.restore();
            }
            ++n4;
            ++n5;
        }
        if (this.ab) {
            this.d.setColor(this.B);
            this.d.setStyle(Paint.Style.FILL);
            canvas.drawRect(this.l, this.d);
        }
        if (this.aa) {
            this.d.setColor(this.A);
            this.d.setStyle(Paint.Style.FILL);
            canvas.drawRect(this.j, this.d);
            canvas.drawRect(this.k, this.d);
        }
        if (this.ah) {
            this.d.setColor(0x4433EE33);
            this.d.setStyle(Paint.Style.FILL);
            canvas.drawRect(0.0f, 0.0f, (float)this.getPaddingLeft(), (float)this.getHeight(), this.d);
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getPaddingTop(), this.d);
            canvas.drawRect((float)(this.getWidth() - this.getPaddingRight()), 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.d);
            canvas.drawRect(0.0f, (float)(this.getHeight() - this.getPaddingBottom()), (float)this.getWidth(), (float)this.getHeight(), this.d);
        }
    }

    private boolean a(int n2) {
        return n2 >= 0 && n2 < this.p.size();
    }

    private int b(int n2) {
        return (int)(Math.sin(Math.toRadians(n2)) * (double)this.G);
    }

    private int c(int n2) {
        return (int)((double)this.G - Math.cos(Math.toRadians(n2)) * (double)this.G);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: {
                this.af = true;
                if (null != this.getParent()) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                if (null == this.f) {
                    this.f = VelocityTracker.obtain();
                } else {
                    this.f.clear();
                }
                this.f.addMovement(motionEvent);
                if (!this.e.isFinished()) {
                    this.e.abortAnimation();
                    this.ag = true;
                }
                this.U = this.T = (int)motionEvent.getY();
                break;
            }
            case 2: {
                float f2;
                if (Math.abs((float)this.U - motionEvent.getY()) < (float)this.V) {
                    this.af = true;
                    break;
                }
                this.af = false;
                this.f.addMovement(motionEvent);
                if (null != this.h) {
                    this.h.c(1);
                }
                if (Math.abs(f2 = motionEvent.getY() - (float)this.T) < 1.0f) break;
                this.R = (int)((float)this.R + f2);
                this.T = (int)motionEvent.getY();
                this.invalidate();
                break;
            }
            case 1: {
                if (null != this.getParent()) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                }
                if (this.af) {
                    int n2 = this.I;
                    int n3 = (int)motionEvent.getY() - this.O;
                    if (Math.abs(n3) > this.F) {
                        if (n3 > 0) {
                            int n4 = (n3 - this.F) / this.E + this.I + 1;
                            n2 = n4 > this.p.size() - 1 ? this.p.size() - 1 : n4;
                        } else {
                            int n5 = (n3 + this.F) / this.E + this.I - 1;
                            int n6 = n2 = n5 < 0 ? 0 : n5;
                        }
                    }
                    if (this.ah) {
                        com.shitu.location.epathmap.utils.L.d((String)b, (String)(n2 + ":" + motionEvent.getY() + ":" + this.O + ":" + this.F));
                    }
                    if (this.g == null) break;
                    this.setSelectedItemPosition(n2);
                    this.g.onItemSelected(this, this.p.get(n2), n2);
                    break;
                }
                this.f.addMovement(motionEvent);
                if (Build.VERSION.SDK_INT >= 4) {
                    this.f.computeCurrentVelocity(1000, (float)this.M);
                } else {
                    this.f.computeCurrentVelocity(1000);
                }
                this.ag = false;
                int n7 = (int)this.f.getYVelocity();
                if (Math.abs(n7) > this.L) {
                    this.e.fling(0, this.R, 0, n7, 0, 0, this.J, this.K);
                    this.e.setFinalY(this.e.getFinalY() + this.d(this.e.getFinalY() % this.E));
                } else {
                    this.e.startScroll(0, this.R, 0, this.d(this.R % this.E));
                }
                if (!this.ad) {
                    if (this.e.getFinalY() > this.K) {
                        this.e.setFinalY(this.K);
                    } else if (this.e.getFinalY() < this.J) {
                        this.e.setFinalY(this.J);
                    }
                }
                this.c.post((Runnable)this);
                if (null == this.f) break;
                this.f.recycle();
                this.f = null;
                break;
            }
            case 3: {
                if (null != this.getParent()) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                }
                if (null == this.f) break;
                this.f.recycle();
                this.f = null;
            }
        }
        return true;
    }

    private int d(int n2) {
        if (Math.abs(n2) > this.F) {
            if (this.R < 0) {
                return -this.E - n2;
            }
            return this.E - n2;
        }
        return -n2;
    }

    @Override
    public void run() {
        if (null == this.p || this.p.size() == 0) {
            return;
        }
        if (this.e.isFinished() && !this.ag) {
            if (this.E == 0) {
                return;
            }
            int n2 = (-this.R / this.E + this.H) % this.p.size();
            int n3 = n2 = n2 < 0 ? n2 + this.p.size() : n2;
            if (this.ah) {
                com.shitu.location.epathmap.utils.L.i((String)b, (String)(n2 + ":" + this.p.get(n2) + ":" + this.R));
            }
            this.I = n2;
            if (null != this.g) {
                this.g.onItemSelected(this, this.p.get(n2), n2);
            }
            if (null != this.h) {
                this.h.b(n2);
                this.h.c(0);
            }
        }
        if (this.e.computeScrollOffset()) {
            if (null != this.h) {
                this.h.c(2);
            }
            this.R = this.e.getCurrY();
            this.postInvalidate();
            this.c.postDelayed((Runnable)this, 16L);
        }
    }

    public void setDebug(boolean bl2) {
        this.ah = bl2;
    }

    public int getVisibleItemCount() {
        return this.r;
    }

    public void setVisibleItemCount(int n2) {
        this.r = n2;
        this.a();
        this.requestLayout();
    }

    public void setCyclic(boolean bl2) {
        this.ad = bl2;
        this.e();
        this.invalidate();
    }

    public void setOnItemSelectedListener(a a2) {
        this.g = a2;
    }

    public int getSelectedItemPosition() {
        return this.H;
    }

    public void setSelectedItemPosition(int n2) {
        int n3 = this.H;
        n2 = Math.min(n2, this.p.size() - 1);
        this.H = n2 = Math.max(n2, 0);
        this.I = n2;
        this.R = 0;
        this.e();
        this.requestLayout();
        this.invalidate();
    }

    public int getCurrentItemPosition() {
        return this.I;
    }

    public List getData() {
        return this.p;
    }

    public void setData(List list) {
        if (null == list) {
            throw new NullPointerException("WheelPicker's data can not be null!");
        }
        this.p = list;
        this.H = this.H > list.size() - 1 || this.I > list.size() - 1 ? (this.I = list.size() - 1) : this.I;
        this.R = 0;
        this.b();
        this.e();
        this.requestLayout();
        this.invalidate();
    }

    public void setSameWidth(boolean bl2) {
        this.W = bl2;
        this.b();
        this.requestLayout();
        this.invalidate();
    }

    public void setOnWheelChangeListener(b b2) {
        this.h = b2;
    }

    public String getMaximumWidthText() {
        return this.q;
    }

    public void setMaximumWidthText(String string2) {
        if (null == string2) {
            throw new NullPointerException("Maximum width text can not be null!");
        }
        this.q = string2;
        this.b();
        this.requestLayout();
        this.invalidate();
    }

    public int getMaximumWidthTextPosition() {
        return this.S;
    }

    public void setMaximumWidthTextPosition(int n2) {
        if (!this.a(n2)) {
            throw new ArrayIndexOutOfBoundsException("Maximum width text Position must in [0, " + this.p.size() + "), but current is " + n2);
        }
        this.S = n2;
        this.b();
        this.requestLayout();
        this.invalidate();
    }

    public int getSelectedItemTextColor() {
        return this.x;
    }

    public void setSelectedItemTextColor(int n2) {
        this.x = n2;
        this.g();
        this.invalidate();
    }

    public int getItemTextColor() {
        return this.w;
    }

    public void setItemTextColor(int n2) {
        this.w = n2;
        this.invalidate();
    }

    public int getItemTextSize() {
        return this.y;
    }

    public void setItemTextSize(int n2) {
        this.y = n2;
        this.d.setTextSize((float)this.y);
        this.b();
        this.requestLayout();
        this.invalidate();
    }

    public int getItemSpace() {
        return this.C;
    }

    public void setItemSpace(int n2) {
        this.C = n2;
        this.requestLayout();
        this.invalidate();
    }

    public void setIndicator(boolean bl2) {
        this.aa = bl2;
        this.f();
        this.invalidate();
    }

    public int getIndicatorSize() {
        return this.z;
    }

    public void setIndicatorSize(int n2) {
        this.z = n2;
        this.f();
        this.invalidate();
    }

    public int getIndicatorColor() {
        return this.A;
    }

    public void setIndicatorColor(int n2) {
        this.A = n2;
        this.invalidate();
    }

    public void setCurtain(boolean bl2) {
        this.ab = bl2;
        this.g();
        this.invalidate();
    }

    public int getCurtainColor() {
        return this.B;
    }

    public void setCurtainColor(int n2) {
        this.B = n2;
        this.invalidate();
    }

    public void setAtmospheric(boolean bl2) {
        this.ac = bl2;
        this.invalidate();
    }

    public void setCurved(boolean bl2) {
        this.ae = bl2;
        this.requestLayout();
        this.invalidate();
    }

    public int getItemAlign() {
        return this.D;
    }

    public void setItemAlign(int n2) {
        this.D = n2;
        this.c();
        this.d();
        this.invalidate();
    }

    public Typeface getTypeface() {
        if (null != this.d) {
            return this.d.getTypeface();
        }
        return null;
    }

    public void setTypeface(Typeface typeface) {
        if (null != this.d) {
            this.d.setTypeface(typeface);
        }
        this.b();
        this.requestLayout();
        this.invalidate();
    }

    public static interface b {
        public void a(int var1);

        public void b(int var1);

        public void c(int var1);
    }

    public static interface a {
        public void onItemSelected(WheelPicker var1, Object var2, int var3);
    }
}

