package com.shitu.epathmap.ui.widget;

import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.PopupWindow;
import android.widget.TextView;

import com.shitu.epathmap.R;
import com.shitu.location.epathmap.utils.DensityUtils;


/**
 * Created by Chen on 2016/4/7.
 */
public class NavBottomNewDialog {

    private PopupWindow popupWindow;
    private View contentView;
    private TextView tvHintDistance;
    private TextView tvHintTime;
    private TextView tvCurrent, tvStart1, tvStart2;
    private TextView tvBourn, tvBourn1, tvBourn2;
    private Button btnFinish, btnContinue;
    private Context context;
    private boolean escalatorMode = false;

    public NavBottomNewDialog(Context context,
                              View.OnClickListener onCloseClickListener,
                              View.OnClickListener onContinueListener) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_nav_bottom_new, null);
        tvBourn = (TextView) contentView.findViewById(R.id.tv_bourn);
        tvBourn1 = (TextView) contentView.findViewById(R.id.tv_bourn_1);
        tvBourn2 = (TextView) contentView.findViewById(R.id.tv_bourn_2);
        tvStart1 = (TextView) contentView.findViewById(R.id.tv_start_1);
        tvStart2 = (TextView) contentView.findViewById(R.id.tv_start_2);
        tvCurrent = (TextView) contentView.findViewById(R.id.tv_current);
        tvHintDistance = (TextView) contentView.findViewById(R.id.tv_hint_distance);
        tvHintTime = (TextView) contentView.findViewById(R.id.tv_hint_time);
        btnFinish = (Button) contentView.findViewById(R.id.btn_finish);
        btnContinue = (Button) contentView.findViewById(R.id.btn_continue);

        btnFinish.setOnClickListener(onCloseClickListener);
        btnContinue.setOnClickListener(onContinueListener);
        popupWindow = new PopupWindow(contentView, DensityUtils.getScreenWidth(context),
                ViewGroup.LayoutParams.WRAP_CONTENT, false);

        popupWindow.setOutsideTouchable(false);
        popupWindow.setAnimationStyle(R.style.IpsmapDialogBottom);
    }

    public void setHintDistance(String hint) {
        tvHintDistance.setText(hint);
    }

    public void setHintTime(String hint) {
        tvHintTime.setText(hint);
    }

    public void pause() {
        btnContinue.setVisibility(View.VISIBLE);
        btnFinish.setVisibility(View.GONE);
    }

    public void continueNav() {
        btnContinue.setVisibility(View.GONE);
        btnFinish.setVisibility(View.VISIBLE);
        btnContinue.setText("继续导航");
    }

    public void pause(String text) {
        btnContinue.setVisibility(View.VISIBLE);
        btnContinue.setText("继续导航 " + text + "s");
        btnFinish.setVisibility(View.GONE);
    }

    public void show(View view) {
        if (popupWindow.isShowing()) {
            return;
        }
        popupWindow.showAtLocation(view, Gravity.BOTTOM, 0, 0);
    }

    public boolean isShowing() {
        return popupWindow.isShowing();
    }

    public void dismiss() {
        if (popupWindow != null && popupWindow.isShowing()) {
            tvHintDistance.setText("");
            tvHintTime.setText("");
            escalatorMode = false;
            popupWindow.dismiss();
        }
    }

    public void gone() {
        if (popupWindow != null && popupWindow.isShowing()) {
            popupWindow.dismiss();
        }
    }

    public void setBourn(String hintFloor, String addressName) {
        tvBourn.setText(hintFloor);
        StringBuilder builder = new StringBuilder();
        builder.append("(")
                .append("目的地：")
                .append(hintFloor)
                .append(")");
        tvBourn1.setText(builder.toString());
        tvBourn2.setText(addressName);
    }

    /**
     * 显示当前位置
     *
     * @param hintFloor
     */
    public void setCurrentLocation(String hintFloor,String addressName) {
        tvCurrent.setText(hintFloor);
        StringBuilder builder = new StringBuilder();
        builder.append("(")
                .append("当前位置：")
                .append(hintFloor)
                .append(")");
        tvStart1.setText(builder.toString());
        tvStart2.setText(addressName);
    }

}
