package com.shitu.epathmap.ui.widget;

import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CheckBox;
import android.widget.PopupWindow;
import android.widget.TextView;

import com.shitu.epathmap.R;
import com.shitu.location.epathmap.utils.DensityUtils;


public class NavBottomDialog {

    private final TextView tvTarget;
    private final TextView tvMyLocationFloor;
    private PopupWindow popupWindow;
    private View contentView;
    private CheckBox cbVolume;
    private TextView tvHint, tvContinue;
    private Context context;

    public NavBottomDialog(Context context, OnVolumeChangeListener onVolumeChangeListener,
                           View.OnClickListener onCloseClickListener,
                           View.OnClickListener onContinueListener) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_nav_bottom, null);
        tvHint = (TextView) contentView.findViewById(R.id.tv_hint);
        tvMyLocationFloor = (TextView) contentView.findViewById(R.id.tv_my_location_floor);
        tvTarget = (TextView) contentView.findViewById(R.id.tv_target);
        tvContinue = (TextView) contentView.findViewById(R.id.tv_continue);
        cbVolume = (CheckBox) contentView.findViewById(R.id.cb_volume);
        popupWindow = new PopupWindow(contentView, DensityUtils.getScreenWidth(context),
                DensityUtils.dp2px(context, 120), false);
        contentView.findViewById(R.id.ll_close).setOnClickListener(onCloseClickListener);
        contentView.findViewById(R.id.ll_nav_info).setOnClickListener(onContinueListener);
        cbVolume.setOnCheckedChangeListener((buttonView, isChecked) -> onVolumeChangeListener.onChange(isChecked));
        popupWindow.setOutsideTouchable(false);
        popupWindow.setAnimationStyle(R.style.IpsmapDialogBottom);
    }


    public void setMyLocationFloor(String myLocationFloor) {
        tvMyLocationFloor.setText(myLocationFloor);
    }

    public void setTarget(String target) {
        tvTarget.setText(target);
    }

    public void setHint(String hint) {
        if (!hint.isEmpty()) {
            tvHint.setText(hint);
        } else {
            tvHint.setText("");
        }
        tvContinue.setVisibility(View.GONE);
        tvHint.setVisibility(View.VISIBLE);

    }

    public void pause() {
        tvContinue.setVisibility(View.VISIBLE);
        tvHint.setVisibility(View.GONE);
        tvContinue.setText("导航被暂停-点击继续导航");
    }

    public void pause(String text) {
        tvContinue.setVisibility(View.VISIBLE);
        tvHint.setVisibility(View.GONE);
        tvContinue.setText("导航被暂停-点击继续导航(" + text + "s)");
//        JumpingBeans.with(tvContinue).makeTextJump(0,tvContinue.getText().toString().length())
//                .setIsWave(false)
//                .setLoopDuration(2000)
//                .build();
    }

    public void show(View view) {
        if (popupWindow.isShowing()) {
            return;
        }
        popupWindow.showAtLocation(view, Gravity.BOTTOM, 0, 0);
    }

    public void dismiss() {
        if (popupWindow != null && popupWindow.isShowing()) {
            tvHint.setText("");
            tvHint.setVisibility(View.VISIBLE);
            tvContinue.setVisibility(View.GONE);
            cbVolume.setChecked(true);
            popupWindow.dismiss();
        }
    }

    public interface OnVolumeChangeListener {
        void onChange(boolean checked);
    }

}
