package com.shitu.epathmap.ui.item.footprint;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.shitu.epathmap.R;
import com.shitu.location.epathmap.model.bean.BackgroundData;
import com.shitu.epathmap.ui.item.BaseRecyclerItem;
import com.shitu.epathmap.ui.item.BaseRecyclerItemFactory;
import com.shitu.location.epathmap.utils.DateUtils;


public class BackGroundDataItem extends BaseRecyclerItemFactory<BackGroundDataItem.BackGroundDataRecyclerItem> {

    Context context;

    public BackGroundDataItem(Context context) {
        this.context = context;
    }

    @Override
    public boolean isTarget(Object itemObject) {
        return itemObject instanceof BackgroundData;
    }

    @Override
    public BackGroundDataRecyclerItem createBaseItem(ViewGroup parent) {
        return new BackGroundDataRecyclerItem(parent, this);
    }


    public class BackGroundDataRecyclerItem extends BaseRecyclerItem<BackgroundData, BackGroundDataItem> {
        private View vLine;
        private TextView tvTime;
        private TextView tvRegionName;

        protected BackGroundDataRecyclerItem(ViewGroup parent, BackGroundDataItem factory) {
            super(LayoutInflater.from(parent.getContext()).inflate(R.layout.ipsmap_item_footprint, parent, false), factory);
        }

        @Override
        protected void onFindViews(View convertView) {
            vLine = convertView.findViewById(R.id.v_line);
            tvTime = (TextView) convertView.findViewById(R.id.tv_time);
            tvRegionName = (TextView) convertView.findViewById(R.id.tv_region_name);
        }

        @Override
        protected void onConfigViews(final Context context) {
        }

        @Override
        protected void onSetData(int position, BackgroundData item) {
            BackgroundData backgroundDataitem = item;
            tvTime.setText(DateUtils.getSimpleDate(item.getEnterAt()));
            tvRegionName.setText(backgroundDataitem.getLocationRegion());
            vLine.setVisibility(View.VISIBLE);
            if (item.isLastOne()) {
                vLine.setVisibility(View.GONE);
            }
        }

    }

}
