package com.shitu.epathmap.ui.activity;

import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.widget.TextView;


import com.shitu.epathmap.R;
import com.shitu.epathmap.ui.adapter.FloorBarAdapter;
import com.shitu.epathmap.ui.utils.GridSpacingItemDecoration;
import com.shitu.epathmap.ui.utils.StatusBarCompat;
import com.shitu.location.epathmap.model.bean.LocationRegionData;
import com.shitu.location.epathmap.utils.MixpanelConstants;
import com.shitu.location.epathmap.utils.MixpanelEvent;

import java.util.List;

import static com.shitu.epathmap.EpathMapSDK.context;
import static com.shitu.epathmap.ui.activity.IpsSearchActivity.REQUEST_TYPE;

public class IpsPoiMoreActivity extends AppCompatActivity {

    public static final String SEARCH_TYPE = "search_type";
    public static final String LIST_STR = "list_str";
    public static final String FLOOR_NAME = "floor_name";
    private RecyclerView recyclerView;
    private FloorBarAdapter floorBarAdapter;
    private List<LocationRegionData> locationRegionDatas;
    private String serachType;
    private TextView tvTitle;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        StatusBarCompat.setColor(this, context.getResources().getColor(R.color.ipsmap_colorPrimaryDark));
        setContentView(R.layout.activity_ips_poi_more);
        initData();
        initAdapter();
    }

    private void initData() {
        Intent intent = getIntent();
        serachType = intent.getStringExtra(SEARCH_TYPE);
        locationRegionDatas = intent.getParcelableArrayListExtra(LIST_STR);
        String name = intent.getStringExtra(FLOOR_NAME);
        recyclerView = (RecyclerView) findViewById(R.id.recyclerView);
        tvTitle = (TextView) findViewById(R.id.tv_title);
        tvTitle.setText(name);
        recyclerView.setLayoutManager(new GridLayoutManager(this, 4,
                GridLayoutManager.VERTICAL,
                false));
        recyclerView.setHasFixedSize(true);
        recyclerView.addItemDecoration(new GridSpacingItemDecoration(4,
                context.getResources().getDimensionPixelOffset(R.dimen.ipsmap_space),
                true));
        findViewById(R.id.iv_back).setOnClickListener(v -> this.finish());
    }

    private void initAdapter() {
        floorBarAdapter = new FloorBarAdapter(R.layout.ipsmap_item_floor_bar_more, locationRegionDatas);
        floorBarAdapter.openLoadAnimation();
        floorBarAdapter.setOnItemClickListener((adapter, view, position) -> {
            LocationRegionData locationRegionData = locationRegionDatas.get(position);
            MixpanelEvent.search(locationRegionData.getName(), 1, MixpanelConstants.SEARCH_FROM_SEARCH_POI);
            Intent intent = new Intent();
            intent.putExtra(EpathMapActivity.RESULT_SELECT_REGION, locationRegionData);
            intent.putExtra(REQUEST_TYPE, serachType);
            setResult(RESULT_OK, intent);
            IpsPoiMoreActivity.this.finish();
        });
        recyclerView.setAdapter(floorBarAdapter);
    }
}
