package com.shitu.epathmap.ui.widget;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.shitu.epathmap.R;
import com.shitu.epathmap.service.NavigationData;
import com.shitu.epathmap.ui.utils.StatusBarCompat;
import com.shitu.location.epathmap.utils.DensityUtils;
import com.shitu.location.epathmap.utils.IpsConstants;
import com.sails.engine.SAILS;

public class NavTopDialog {

    private final LinearLayout llSignalNoPic;
//    private final LinearLayout llSignalHasPic;
    private Context context;
    private PopupWindow popupWindow;
    private View contentView;
    private NavigationData navigationData;
    private RelativeLayout rlNoPic;
    private TextView tvHint;
    private ImageView ivHint;
    private TextView tvSignalContain;
    private ImageView ivBlueth;
//    private LinearLayout llHasPic;
//    private TextView tvHintPic;
//    private TextView tvSignalContainPic;
//    private ImageView ivBluethPic;
    private ImageView ivElevator;
//    private TextView tvElevatorPic;
    private TextView tvBourn;
    private int placeHolderResourceId = 0;

    public NavTopDialog(Context context) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_nav_top, null);

        rlNoPic = (RelativeLayout) contentView.findViewById(R.id.rl_no_pic);
        tvHint = (TextView) contentView.findViewById(R.id.tv_hint);
        ivHint = (ImageView) contentView.findViewById(R.id.iv_hint);
        tvSignalContain = (TextView) contentView.findViewById(R.id.tv_signal_contain);
        ivBlueth = (ImageView) contentView.findViewById(R.id.iv_blueth);
//        llHasPic = (LinearLayout) contentView.findViewById(R.id.ll_has_pic);
//        tvHintPic = (TextView) contentView.findViewById(R.id.tv_hint_pic);
        tvBourn = (TextView) contentView.findViewById(R.id.tv_hint_bourn);
//        tvSignalContainPic = (TextView) contentView.findViewById(R.id.tv_signal_contain_pic);
//        ivBluethPic = (ImageView) contentView.findViewById(R.id.iv_blueth_pic);
        ivElevator = (ImageView) contentView.findViewById(R.id.iv_elevator);
//        tvElevatorPic = (TextView) contentView.findViewById(R.id.tv_elevator_pic);
        llSignalNoPic = (LinearLayout) contentView.findViewById(R.id.ll_signal_no_pic);
//        llSignalHasPic = (LinearLayout) contentView.findViewById(R.id.ll_signal_has_pic);
        ivHint = (ImageView) contentView.findViewById(R.id.iv_hint);
        popupWindow = new PopupWindow(contentView, DensityUtils.getScreenWidth(context), ViewGroup.LayoutParams.WRAP_CONTENT, false);
        popupWindow.setOutsideTouchable(false);
        popupWindow.setAnimationStyle(R.style.IpsmapDialogTop);
    }


    public void setSignal(SAILS.SignalStatus signalStatus) {

        if (signalStatus == SAILS.SignalStatus.STRONG_BEACON_SIGNAL) {
            llSignalNoPic.setVisibility(View.GONE);
//            llSignalHasPic.setVisibility(View.GONE);
        } else if (signalStatus == SAILS.SignalStatus.WEAK_BEACON_SIGNAL) {

            llSignalNoPic.setVisibility(View.VISIBLE);
//            llSignalHasPic.setVisibility(View.VISIBLE);
            tvSignalContain.setText("弱");
//            tvSignalContainPic.setText("弱");

        } else if (signalStatus == SAILS.SignalStatus.NO_BEACON_GPS_IN_MAP) {
            llSignalNoPic.setVisibility(View.VISIBLE);
//            llSignalHasPic.setVisibility(View.VISIBLE);
            tvSignalContain.setText("弱");
//            tvSignalContainPic.setText("弱");

        } else if (signalStatus == SAILS.SignalStatus.NO_BEACON_GPS_OUT_MAP) {
            llSignalNoPic.setVisibility(View.VISIBLE);
//            llSignalHasPic.setVisibility(View.VISIBLE);
            tvSignalContain.setText("无信号");
//            tvSignalContainPic.setText("无信号");

        } else if (signalStatus == SAILS.SignalStatus.STATUS_UNAVAILABLE) {
            llSignalNoPic.setVisibility(View.VISIBLE);
//            llSignalHasPic.setVisibility(View.VISIBLE);
            tvSignalContain.setText("无信号");
//            tvSignalContainPic.setText("无信号");

        }


    }

    public void setElevatorVisible(boolean isVisible) {
        if (isVisible) {
//            StatusBarCompat.setColor((Activity) context, context.getResources().getColor(R.color.ipsmap_tvGreen5));
            ivElevator.setVisibility(View.VISIBLE);
//            llHasPic.setVisibility(View.VISIBLE);
            rlNoPic.setVisibility(View.VISIBLE);
        } else {
//            StatusBarCompat.setColor((Activity) context, context.getResources().getColor(R.color.ipsmap_colorPrimaryDark));
            ivElevator.setVisibility(View.GONE);
//            llHasPic.setVisibility(View.GONE);
            rlNoPic.setVisibility(View.VISIBLE);
        }
    }

    public void setIvElevator(String url) {
        if (!TextUtils.isEmpty(url)) {
            Glide.with(context)
                    .load(url)
                    .centerCrop()
                    .crossFade()
                    .diskCacheStrategy(DiskCacheStrategy.SOURCE)
                    .into(new SimpleTarget<GlideDrawable>() {
                        @Override
                        public void onResourceReady(GlideDrawable resource, GlideAnimation<? super GlideDrawable> glideAnimation) {
                            ivElevator.setImageDrawable(resource);
                            setElevatorVisible(true);
                        }
                    });
        } else if (placeHolderResourceId != 0) {
            ivElevator.setImageResource(placeHolderResourceId);
            setElevatorVisible(true);
        }
    }

    public void setHint(NavigationData data) {
        String navText = data.getNavigationText();
        if (TextUtils.isEmpty(navText)) {//null显示上一次
            navText = tvHint.getText().toString();
        }
        tvHint.setText(navText);
//        tvHintPic.setText(navText);
        String subtype = data.getSubtype();
        if (TextUtils.isEmpty(subtype) && navigationData != null && !TextUtils.isEmpty(navigationData.getSubtype())) {
            subtype = navigationData.getSubtype();
        }
        ivHint.setVisibility(View.VISIBLE);
        if ((navText.contains("请上") || navText.contains("请下"))) {
            ivHint.setVisibility(View.GONE);
//            tvElevatorPic.setText(data.getToFloor() + "\n楼");
            if (subtype != null && subtype.equals(IpsConstants.ELEVATOR)) {
//                if (navText.contains("请上")) {
//                    tvElevatorPic.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_pt_arrows_up));
//                } else {
//                    tvElevatorPic.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_pt_arrows_down));
//                }
                placeHolderResourceId = R.drawable.ipsmap_updown_elevator;

            } else if (subtype != null && subtype.equals(IpsConstants.ESCALATOR)) {
                if (navText.contains("请上")) {
//                    tvElevatorPic.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_pt_ft_arrows_up));
                    placeHolderResourceId = R.drawable.ipsmap_updown_escalator_up;
                } else {
//                    tvElevatorPic.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_pt_ft_arrows_down));
                    placeHolderResourceId = R.drawable.ipsmap_updown_escalator_down;
                }

            } else if (subtype != null && subtype.equals(IpsConstants.STAIR)) {
                if (navText.contains("请上")) {
//                    tvElevatorPic.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_pt_ft_arrows_up));
                    placeHolderResourceId = R.drawable.ipsmap_updown_stairs_up;
                } else {
//                    tvElevatorPic.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_pt_ft_arrows_down));
                    placeHolderResourceId = R.drawable.ipsmap_updown_stairs_down;
                }

            }
        } else if (navText.contains(IpsConstants.NAV_TURN_LEFT)) {
            ivHint.setImageResource(R.drawable.ipsmap_ico_direction_left);

        } else if (navText.contains(IpsConstants.NAV_TURN_STRAIGHT_LEFT)) {
            ivHint.setImageResource(R.drawable.ipsmap_ico_direction_straight_left);

        } else if (navText.contains(IpsConstants.NAV_TURN_BEHIND_LEFT)) {
            ivHint.setImageResource(R.drawable.ipsmap_ico_direction_left_behind);

        } else if (navText.contains(IpsConstants.NAV_TURN_RIGHT)) {
            ivHint.setImageResource(R.drawable.ipsmap_ico_direction_right);

        } else if (navText.contains(IpsConstants.NAV_TURN_BEHIND_RIGHT)) {
            ivHint.setImageResource(R.drawable.ipsmap_ico_direction_right_behind);

        } else if (navText.contains(IpsConstants.NAV_TURN_STRAIGHT_RIGHT)) {
            ivHint.setImageResource(R.drawable.ipsmap_ico_direction_straight_right);

        } else if (navText.contains(IpsConstants.NAV_GO_STRAIGHT)) {
            ivHint.setImageResource(R.drawable.ipsmap_ico_direction_straight);

        } else {
            ivHint.setVisibility(View.GONE);
        }
        this.navigationData = data;
    }

    public void show(View view) {
        if (popupWindow.isShowing()) {
            return;
        }
        popupWindow.showAtLocation(view, Gravity.TOP, 0, 0);
        StatusBarCompat.setColor((Activity) context, context.getResources().getColor(R.color.ipsmap_tvBlack9));
    }

    public void setBourn(String bourn) {
        tvBourn.setText(bourn);
    }

    public void dismiss() {
        if (popupWindow != null && popupWindow.isShowing()) {
            placeHolderResourceId = 0;
            tvHint.setText(IpsConstants.NAV_GO_ALONG);
//            tvHintPic.setText(IpsConstants.NAV_GO_ALONG);
//            tvElevatorPic.setText("");
            llSignalNoPic.setVisibility(View.GONE);
//            llSignalHasPic.setVisibility(View.GONE);
            popupWindow.dismiss();
            StatusBarCompat.setColor((Activity) context, context.getResources().getColor(R.color.ipsmap_colorPrimaryDark));
        }
    }

}
