package com.shitu.epathmap.ui.widget;

import android.app.Dialog;
import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import com.shitu.epathmap.R;
import com.shitu.location.epathmap.utils.L;

import java.util.ArrayList;

public class NavFinishBottomDialog implements View.OnClickListener, CompoundButton.OnCheckedChangeListener {

    private final TextView tvUpload;
    private final ImageView ivClose;
    private Dialog dialog;
    private View contentView;
    private Context context;
    private IpsmapRatingBar rcRate;
    private CheckBox checkBox1;
    private CheckBox checkBox2;
    private CheckBox checkBox3;
    private CheckBox checkBox4;
    private TextView tvTargetRegion;
    private TextView tvStartRegion;
    private TextView tvDistance;
    private TextView tvRateValue;
    private TextView tvMinute;
    private EditText tvContent;
    private ArrayList comments;
    private int score;
    private String startRegion;
    private String targetRegion;

    public NavFinishBottomDialog(Context context,
                                 View.OnClickListener close, View.OnClickListener save) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_nav_finish_bottom, null);
        checkBox1 = (CheckBox) contentView.findViewById(R.id.cv_checkBox1);
        checkBox1.setOnCheckedChangeListener(this);
        checkBox2 = (CheckBox) contentView.findViewById(R.id.cv_checkBox2);
        checkBox2.setOnCheckedChangeListener(this);
        checkBox3 = (CheckBox) contentView.findViewById(R.id.cv_checkBox3);
        checkBox3.setOnCheckedChangeListener(this);
        checkBox4 = (CheckBox) contentView.findViewById(R.id.cv_checkBox4);
        checkBox4.setOnCheckedChangeListener(this);
        tvContent = (EditText) contentView.findViewById(R.id.tv_content);
        tvUpload = (TextView) contentView.findViewById(R.id.tv_upload);
        tvUpload.setOnClickListener(save);
        ivClose = (ImageView) contentView.findViewById(R.id.iv_close);
        tvStartRegion = (TextView) contentView.findViewById(R.id.tv_start);
        tvTargetRegion = (TextView) contentView.findViewById(R.id.tv_end);
        tvRateValue = (TextView) contentView.findViewById(R.id.tv_rate_value);
        tvDistance = (TextView) contentView.findViewById(R.id.tv_result_distance);
        tvMinute = (TextView) contentView.findViewById(R.id.tv_result_minutes);

        ivClose.setOnClickListener(close);
        rcRate = (IpsmapRatingBar) contentView.findViewById(R.id.rc_rate);
        rcRate.setCountSelected(5);
        rcRate.setOnRatingChangeListener(countSelected -> {
            score = (int) Math.ceil(countSelected);
            L.e("ddd", "score+" + score);
            String rateValue="极力推荐";
            switch (score){
                case 1:
                    rateValue="真不能忍";
                    break;
                case 2:
                    rateValue="差强人意";
                    break;
                case 3:
                    rateValue="再接再厉";
                    break;
                case 4:
                    rateValue="心满意足";
                    break;
            }
            tvRateValue.setText(rateValue);
            rcRate.setCountSelected(score);
        });
        comments = new ArrayList<String>();
        dialog = new Dialog(context, R.style.IpsmapDialogCommon);
        dialog.setContentView(contentView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        dialog.setCanceledOnTouchOutside(false);
        Window win = dialog.getWindow();
        win.getDecorView().setPadding(0, 0, 0, 0);
        WindowManager.LayoutParams lp = win.getAttributes();
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
        win.setAttributes(lp);
        win.setGravity(Gravity.BOTTOM);
        dialog.setCancelable(false);

    }

    public void show() {
        if (dialog.isShowing()) {
            return;
        }
        dialog.show();
    }

    public void setStartRegion(String startRegion) {
        this.startRegion = startRegion;
        tvStartRegion.setText(startRegion);
    }

    public String getStartRegion() {
        return startRegion;
    }

    public void setTargetRegion(String targetRegion) {
        this.targetRegion = targetRegion;
        tvTargetRegion.setText(targetRegion);
    }

    public String getTargetRegion() {
        return targetRegion;
    }

    public void setDistanceAndTime(String distanceStr,String minuteStr) {
        tvDistance.setText(distanceStr);
        tvMinute.setText(minuteStr);
    }

    public void dismiss() {
        if (dialog != null && dialog.isShowing()) {
            rcRate.setCountSelected(0);
            checkBox1.setChecked(false);
            checkBox2.setChecked(false);
            checkBox3.setChecked(false);
            checkBox4.setChecked(false);
            tvContent.setText("");
            dialog.dismiss();
        }
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.cv_checkBox1) {

            if (checkBox1.isSelected()) {
                checkBox1.setTextColor(context.getResources().getColor(R.color.ipsmap_blue_a1));
                if (!comments.contains(context.getString(R.string.ipsmap_comment1))) {
                    comments.add(context.getString(R.string.ipsmap_comment1));
                }
            } else {
                checkBox1.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                comments.remove(context.getString(R.string.ipsmap_comment1));
            }

        } else if (v.getId() == R.id.cv_checkBox2) {

            if (checkBox2.isSelected()) {
                checkBox2.setTextColor(context.getResources().getColor(R.color.ipsmap_blue_a1));
                if (!comments.contains(context.getString(R.string.ipsmap_comment2))) {
                    comments.add(context.getString(R.string.ipsmap_comment2));
                }


            } else {
                checkBox2.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                comments.remove(context.getString(R.string.ipsmap_comment2));

            }
        } else if (v.getId() == R.id.cv_checkBox3) {

            if (checkBox3.isSelected()) {
                checkBox3.setTextColor(context.getResources().getColor(R.color.ipsmap_blue_a1));
                if (!comments.contains(context.getString(R.string.ipsmap_comment3))) {
                    comments.add(context.getString(R.string.ipsmap_comment3));
                }


            } else {
                checkBox3.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                comments.remove(context.getString(R.string.ipsmap_comment3));

            }

        } else if (v.getId() == R.id.cv_checkBox4) {

            if (checkBox4.isSelected()) {
                checkBox4.setTextColor(context.getResources().getColor(R.color.ipsmap_blue_a1));
                if (!comments.contains(context.getString(R.string.ipsmap_comment4))) {
                    comments.add(context.getString(R.string.ipsmap_comment4));
                }
            } else {
                checkBox4.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                comments.remove(context.getString(R.string.ipsmap_comment4));
            }
        }

    }

    @Override
    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (buttonView.getId() == R.id.cv_checkBox1) {

            if (isChecked) {
                checkBox1.setTextColor(context.getResources().getColor(R.color.ipsmap_blue_a1));
                comments.add(context.getString(R.string.ipsmap_comment1));
            } else {
                checkBox1.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                comments.remove(context.getString(R.string.ipsmap_comment1));
            }

        } else if (buttonView.getId() == R.id.cv_checkBox2) {

            if (isChecked) {
                checkBox2.setTextColor(context.getResources().getColor(R.color.ipsmap_blue_a1));
                comments.add(context.getString(R.string.ipsmap_comment2));
            } else {
                comments.remove(context.getString(R.string.ipsmap_comment2));
                checkBox2.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
            }
        } else if (buttonView.getId() == R.id.cv_checkBox3) {

            if (isChecked) {
                checkBox3.setTextColor(context.getResources().getColor(R.color.ipsmap_blue_a1));
                comments.add(context.getString(R.string.ipsmap_comment3));
            } else {
                checkBox3.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                comments.remove(context.getString(R.string.ipsmap_comment3));
            }

        } else if (buttonView.getId() == R.id.cv_checkBox4) {

            if (isChecked) {
                comments.add(context.getString(R.string.ipsmap_comment4));
                checkBox4.setTextColor(context.getResources().getColor(R.color.ipsmap_blue_a1));
            } else {
                checkBox4.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey));
                comments.remove(context.getString(R.string.ipsmap_comment4));
            }

        }
    }

    public ArrayList getComments() {
        return comments;
    }

    public String getContent() {
        return tvContent.getText().toString();
    }

    public int getScore() {
        return score;
    }
}
