package com.shitu.epathmap.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

import com.shitu.epathmap.R;
import com.shitu.location.epathmap.utils.DensityUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * author:lfei
 */
public class CompassView extends View {
    private final ArrayList<Double> doubles;
    private final Paint mPaintText;
    private Paint mPaint;
    private Paint mPaintCircle;

    private double mRadius;
    private double mDash_short;
    private double mDash_long;
    //private double mTextSize;
    private double mSeta = -Math.PI / 2;
    private double slope;
    private int temp;
    private double inStart = 0;
    private double inEnd = 0;
    private double outStart = 0;
    private double outEnd = 0;
    private double start = 0;
    private double end = 0;
    private double start2 = 0;
    private double end2 = 0;
    private ArrayList<Integer> inArrayLsit;
    private final ArrayList<Double> outArrayList;

    public CompassView(Context context, AttributeSet attrs) {
        super(context, attrs);
        mPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mPaintText = new Paint(Paint.ANTI_ALIAS_FLAG);
        mPaintCircle = new Paint(Paint.ANTI_ALIAS_FLAG);
        inArrayLsit = new ArrayList<>();
        outArrayList = new ArrayList<>();
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.IpsmapCompassViewStyle);
        mRadius = typedArray.getDimension(R.styleable.IpsmapCompassViewStyle_radius, 0);
        mDash_short = typedArray.getDimension(R.styleable.IpsmapCompassViewStyle_short_dash, 20);
        mDash_long = typedArray.getDimension(R.styleable.IpsmapCompassViewStyle_long_dash, 30);
//        mRadius =  DensityUtils.sp2px(getContext(), (float) mRadius);
//        mDash_short =  DensityUtils.sp2px(getContext(), (float) mDash_short);
//        mDash_long =  DensityUtils.sp2px(getContext(), (float) mDash_long);

        //   mTextSize = typedArray.getDimension(R.styleable.CompassViewStyle_text_size, 10);
        typedArray.recycle();
        this.doubles = new ArrayList<>();


    }

    @Override
    protected void onDraw(Canvas canvas) {
        double width = getWidth();
        double height = getHeight();
        // choose the shortest in width, height, radius as actual radius
        double radius = (mRadius < width && mRadius < height) ? mRadius : Math.min(width, height);
        mPaint.setColor(getResources().getColor(R.color.ipsmap_tvBlack3));
        mPaintText.setColor(getResources().getColor(R.color.ipsmap_whiteTranslucent3));
        Paint.FontMetrics fontMetrics = mPaint.getFontMetrics();

        mPaint.setTextSize(DensityUtils.sp2px(getContext(), 20));
        mPaintText.setTextSize(DensityUtils.sp2px(getContext(), 20));
        canvas.drawText("校准", (float) (width / 2) - mPaintText.getTextSize(),
                (float) (height / 2),
                mPaintText);
        // draw the outer circle
        for (int seta = -180; seta < 180; ) {
            float x = (float) (width / 2 + radius * Math.cos(seta * Math.PI / 180));
            float y = (float) (height / 2 + radius * Math.sin(seta * Math.PI / 180));
            //   mPaint.setColor(getResources().getColor(R.color.text_bg_green_stroke));
            float x2 = (float) (width / 2 + (radius + mDash_short) * Math.cos(seta * Math.PI / 180));
            float y2 = (float) (height / 2 + (radius + mDash_short) * Math.sin(seta * Math.PI / 180));
            canvas.drawLine(x, y, x2, y2, mPaint);
            seta = seta + 2;
        }
        //画颜色
        //0-30 度显示 第一圈 30 -60 显示第二圈
        //    if(slope > 0 && slope < 30){
        float xCenter = (float) (width / 2 + (radius - 50) * Math.cos(mSeta * Math.PI / 180));
        float yCenter = (float) (height / 2 + (radius - 50) * Math.sin(mSeta * Math.PI / 180));
        mPaint.setColor(getResources().getColor(R.color.ipsmap_bg_green_stroke_selector));
        mPaintCircle.setColor(getResources().getColor(R.color.ipsmap_red_a11));
//        canvas.drawCircle(xCenter, yCenter, 50, mPaintCircle);
        canvas.drawCircle(xCenter, yCenter,DensityUtils.sp2px(getContext(), 18), mPaintCircle);

        if (inArrayLsit == null)
            return;
        for (int i = 0; i < inArrayLsit.size(); ) {
            int seta = i - 180;
            if (inArrayLsit.get(i) == 1) {
                float x = (float) (width / 2.0 + radius * Math.cos(seta * Math.PI / 180));
                float y = (float) (height / 2.0 + radius * Math.sin(seta * Math.PI / 180));
                mPaint.setColor(getResources().getColor(R.color.ipsmap_bg_green_stroke_selector));
                //   mPaint.setColor(getResources().getColor(R.color.text_bg_green_stroke));
                float x2 = (float) (width / 2.0 + (radius + mDash_short / 2.0) * Math.cos(seta * Math.PI / 180));
                float y2 = (float) (height / 2.0 + (radius + mDash_short / 2.0) * Math.sin(seta * Math.PI / 180));
                canvas.drawLine(x, y, x2, y2, mPaint);
            } else if (inArrayLsit.get(i) == 2) {
                float x = (float) (width / 2.0 + ((radius) + mDash_short / 2.0) * Math.cos(seta * Math.PI / 180));
                float y = (float) (height / 2.0 + ((radius) + mDash_short / 2.0) * Math.sin(seta * Math.PI / 180));
                mPaint.setColor(getResources().getColor(R.color.ipsmap_text_bg_green_stroke));
                //   mPaint.setColor(getResources().getColor(R.color.text_bg_green_stroke));
                float x2 = (float) (width / 2.0 + (radius + mDash_short) * Math.cos(seta * Math.PI / 180));
                float y2 = (float) (height / 2.0 + (radius + mDash_short) * Math.sin(seta * Math.PI / 180));
                canvas.drawLine(x, y, x2, y2, mPaint);

                float x3 = (float) (width / 2.0 + radius * Math.cos(seta * Math.PI / 180));
                float y3 = (float) (height / 2.0 + radius * Math.sin(seta * Math.PI / 180));
                mPaint.setColor(getResources().getColor(R.color.ipsmap_bg_green_stroke_selector));
                //   mPaint.setColor(getResources().getColor(R.color.text_bg_green_stroke));
                float x4 = (float) (width / 2.0 + (radius + mDash_short / 2.0) * Math.cos(seta * Math.PI / 180));
                float y4 = (float) (height / 2.0 + (radius + mDash_short / 2.0) * Math.sin(seta * Math.PI / 180));
                canvas.drawLine(x3, y3, x4, y4, mPaint);
            }

            i = i + 2;
        }


//        //0-360 度范围内进行判断
//        if (inStart > inEnd){
//            //转换成需要的开始节点
//            start = inEnd - 180;
//            end = inStart -180;
//        }else{
//            //转换成需要的开始节点
//            start = inStart - 180;
//            end = inEnd -180;
//        }
//        if (((int)start) %2 != 0){
//            start =  ((int)start) -1;
//        }
//        for (int seta = (int) start; seta < end;) {
//            float x = (float) (width / 2.0 + radius * Math.cos(seta * Math.PI / 180));
//            float y = (float) (height / 2.0 + radius * Math.sin(seta * Math.PI / 180));
//            mPaint.setColor(getResources().getColor(R.color.bg_green_stroke_selector));
//            //   mPaint.setColor(getResources().getColor(R.color.text_bg_green_stroke));
//            float x2 = (float) (width / 2.0 + (radius + mDash_short / 2.0) * Math.cos(seta * Math.PI / 180));
//            float y2 = (float) (height / 2.0 + (radius + mDash_short / 2.0) * Math.sin(seta * Math.PI / 180));
//            canvas.drawLine(x, y, x2, y2, mPaint);
//            seta = seta + 2;
//        }
//
//        //0-360 度范围内进行判断
//        if (outStart > outEnd){
//            //转换成需要的开始节点
//            start2 = outEnd - 180;
//            end2 = outStart -180;
//        }else{
//            //转换成需要的开始节点
//            start2 = outStart - 180;
//            end2 = outEnd -180;
//        }
//
//        if (((int)start2) %2 != 0){
//            start2 =  ((int)start2) -1;
//        }
//        for (int seta = (int) start2; seta < end2; ) {
//            float x = (float) (width / 2.0 + ((radius ) + mDash_short / 2.0 ) * Math.cos(seta * Math.PI / 180));
//            float y = (float) (height / 2.0 + ((radius)+ mDash_short / 2.0) * Math.sin(seta * Math.PI / 180));
//            mPaint.setColor(getResources().getColor(R.color.text_bg_green_stroke));
//            //   mPaint.setColor(getResources().getColor(R.color.text_bg_green_stroke));
//            float x2 = (float) (width / 2.0 + (radius + mDash_short ) * Math.cos(seta * Math.PI / 180));
//            float y2 = (float) (height / 2.0 + (radius + mDash_short) * Math.sin(seta * Math.PI / 180));
//            canvas.drawLine(x, y, x2, y2, mPaint);
//            seta = seta + 2;
//        }
    }




    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = getDefaultSize(getSuggestedMinimumHeight(),
                heightMeasureSpec);
        int width = getDefaultSize(getSuggestedMinimumWidth(), widthMeasureSpec);
        setMeasuredDimension(width, height);

    }



    // 设置南向指针和x轴的夹角，弧度表示
    public void setSouth(double seta, double slope, List<Integer> inArrayLsit) {
        this.inArrayLsit = new ArrayList<>(inArrayLsit);
        //全部转换成0 - 360 内的好比较大小角度

//        if (slope > 30) {
//            inArrayLsit.add(seta);
//        } else if (slope > 60) {
//            outArrayList.add(seta);
//        }

        if (slope > 30) {
            if (outStart != 0) {
                outEnd = seta + 180;
            } else {
                outStart = seta + 180;
            }
        } else {
            outStart = 0;
            outEnd = 0;
        }
        if (inStart != 0) {
            this.slope = slope;
            inEnd = seta + 180;
            mSeta = seta;
            invalidate();
        } else {
            inStart = seta + 180;
        }
    }
}
