/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import android.os.SystemClock;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashSet;
import javax.net.ssl.SSLException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RetryHandler
implements HttpRequestRetryHandler {
    private static final HashSet<Class<?>> exceptionWhitelist = new HashSet();
    private static final HashSet<Class<?>> exceptionBlacklist = new HashSet();
    private final int maxRetries;
    private final int retrySleepTimeMS;

    public RetryHandler(int n2, int n3) {
        this.maxRetries = n2;
        this.retrySleepTimeMS = n3;
    }

    public boolean retryRequest(IOException iOException, int n2, HttpContext object) {
        boolean bl2;
        boolean bl3 = true;
        boolean bl4 = bl2 = (object = (Boolean)object.getAttribute("http.request_sent")) != null && ((Boolean)object).booleanValue();
        if (n2 > this.maxRetries) {
            bl3 = false;
        } else if (this.isInList(exceptionWhitelist, iOException)) {
            bl3 = true;
        } else if (this.isInList(exceptionBlacklist, iOException)) {
            bl3 = false;
        } else if (!bl2) {
            bl3 = true;
        }
        if (bl3) {
            SystemClock.sleep((long)this.retrySleepTimeMS);
        } else {
            iOException.printStackTrace();
        }
        return bl3;
    }

    static void addClassToWhitelist(Class<?> clazz) {
        exceptionWhitelist.add(clazz);
    }

    static void addClassToBlacklist(Class<?> clazz) {
        exceptionBlacklist.add(clazz);
    }

    protected boolean isInList(HashSet<Class<?>> object, Throwable throwable) {
        object = ((HashSet)object).iterator();
        while (object.hasNext()) {
            if (!((Class)object.next()).isInstance(throwable)) continue;
            return true;
        }
        return false;
    }

    static {
        exceptionWhitelist.add(NoHttpResponseException.class);
        exceptionWhitelist.add(UnknownHostException.class);
        exceptionWhitelist.add(SocketException.class);
        exceptionWhitelist.add(ConnectTimeoutException.class);
        exceptionWhitelist.add(SocketTimeoutException.class);
        exceptionBlacklist.add(InterruptedIOException.class);
        exceptionBlacklist.add(SSLException.class);
    }
}

