/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import android.os.Looper;
import com.baidu.tts.loopj.AsyncHttpClient;
import com.baidu.tts.loopj.AsyncHttpResponseHandler;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;

public abstract class BinaryHttpResponseHandler
extends AsyncHttpResponseHandler {
    private static final String LOG_TAG = "BinaryHttpRH";
    private String[] mAllowedContentTypes = new String[]{"application/octet-stream", "image/jpeg", "image/png", "image/gif"};

    public String[] getAllowedContentTypes() {
        return this.mAllowedContentTypes;
    }

    public BinaryHttpResponseHandler() {
    }

    public BinaryHttpResponseHandler(String[] stringArray) {
        if (stringArray != null) {
            this.mAllowedContentTypes = stringArray;
            return;
        }
        AsyncHttpClient.log.e(LOG_TAG, "Constructor passed allowedContentTypes was null !");
    }

    public BinaryHttpResponseHandler(String[] stringArray, Looper looper) {
        super(looper);
        if (stringArray != null) {
            this.mAllowedContentTypes = stringArray;
            return;
        }
        AsyncHttpClient.log.e(LOG_TAG, "Constructor passed allowedContentTypes was null !");
    }

    public abstract void onSuccess(int var1, Header[] var2, byte[] var3);

    public abstract void onFailure(int var1, Header[] var2, byte[] var3, Throwable var4);

    public final void sendResponseMessage(HttpResponse httpResponse) {
        StatusLine statusLine = httpResponse.getStatusLine();
        Header header = httpResponse.getHeaders("Content-Type");
        if (((Header[])header).length != 1) {
            this.sendFailureMessage(statusLine.getStatusCode(), httpResponse.getAllHeaders(), null, (Throwable)new HttpResponseException(statusLine.getStatusCode(), "None, or more than one, Content-Type Header found!"));
            return;
        }
        header = header[0];
        boolean bl2 = false;
        for (String string : this.getAllowedContentTypes()) {
            try {
                if (!Pattern.matches(string, header.getValue())) continue;
                bl2 = true;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                AsyncHttpClient.log.e(LOG_TAG, "Given pattern is not valid: " + string, patternSyntaxException);
            }
        }
        if (!bl2) {
            this.sendFailureMessage(statusLine.getStatusCode(), httpResponse.getAllHeaders(), null, (Throwable)new HttpResponseException(statusLine.getStatusCode(), "Content-Type (" + header.getValue() + ") not allowed!"));
            return;
        }
        super.sendResponseMessage(httpResponse);
    }
}

