package com.shitu.epathmap.ui.item;

import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.shitu.epathmap.R;
import com.shitu.epathmap.ui.ItemDecoration.DividerItemGridDecoration;
import com.shitu.epathmap.ui.adapter.FloorBarAdapter;
import com.shitu.location.epathmap.model.bean.LocationRegionData;
import com.shitu.location.epathmap.model.bean.LocationRegionTagData;
import com.shitu.location.epathmap.utils.DensityUtils;

import java.util.ArrayList;
import java.util.List;


public class RegionTagDataItem extends BaseRecyclerItemFactory<RegionTagDataItem.LocationRegionTypeDataRecyclerItem> {

    Context context;
    OnItemClickListener onItemClickListener;


    public RegionTagDataItem(Context context, OnItemClickListener onItemClickListener) {
        this.context = context;
        this.onItemClickListener = onItemClickListener;
    }

    @Override
    public boolean isTarget(Object itemObject) {
        return itemObject instanceof LocationRegionTagData;
    }

    @Override
    public LocationRegionTypeDataRecyclerItem createBaseItem(ViewGroup parent) {
        return new LocationRegionTypeDataRecyclerItem(parent, this);
    }


    public class LocationRegionTypeDataRecyclerItem extends BaseRecyclerItem<LocationRegionTagData, RegionTagDataItem> {

        private TextView tvType;
        private ImageView ivType;
        //        private TagContainerLayout tagContainerLayout;
        private RecyclerView recyclerViewBar;
        private FloorBarAdapter floorBarAdapter;
        private List<LocationRegionData> locationRegionData;

        protected LocationRegionTypeDataRecyclerItem(ViewGroup parent, RegionTagDataItem factory) {
            super(LayoutInflater.from(parent.getContext()).inflate(R.layout.ipsmap_item_region_tag, parent, false), factory);
        }

        @Override
        protected void onFindViews(View convertView) {
            tvType = (TextView) convertView.findViewById(R.id.tv_type);
            ivType = (ImageView) convertView.findViewById(R.id.iv_type);
            recyclerViewBar = (RecyclerView) convertView.findViewById(R.id.recyclerViewBar);
            recyclerViewBar.setLayoutManager(new GridLayoutManager(context, 3));
            int width= DensityUtils.dp2px(context,10);
            recyclerViewBar.addItemDecoration(new DividerItemGridDecoration(width, 3));
//            tagContainerLayout = (TagContainerLayout) convertView.findViewById(R.id.tagcontainerLayout);
        }

        @Override
        protected void onConfigViews(final Context context) {
            if (onItemClickListener != null) {
                if (floorBarAdapter == null) floorBarAdapter = new FloorBarAdapter(R.layout.ipsmap_item_floor_bar, locationRegionData);
                floorBarAdapter.setOnItemClickListener((adapter1, view, position) -> {
                    onItemClickListener.onClick(locationRegionData.get(position));
                });
                floorBarAdapter.setOnItemLongClickListener(new BaseQuickAdapter.OnItemLongClickListener() {
                    @Override
                    public boolean onItemLongClick(BaseQuickAdapter adapter, View view, int position) {
                        onItemClickListener.onClick(locationRegionData.get(position));
                        return false;
                    }
                });

//                tagContainerLayout.setOnTagClickListener(new TagView.OnTagClickListener() {
//                    @Override
//                    public void onTagClick(int position, String text) {
//                        onItemClickListener.onClick(getData().getLocationRegionDatas().get(position));
//                    }
//
//                    @Override
//                    public void onTagLongClick(int position, String text) {
//                        onItemClickListener.onClick(getData().getLocationRegionDatas().get(position));
//                    }
//
//                    @Override
//                    public void onTagCrossClick(int position) {
//
//                    }
//                });
            }
        }

        @Override
        protected void onSetData(int position, LocationRegionTagData item) {
            locationRegionData = new ArrayList<>();
            floorBarAdapter = new FloorBarAdapter(R.layout.ipsmap_item_floor_bar, locationRegionData);
            floorBarAdapter.openLoadAnimation();
            recyclerViewBar.setAdapter(floorBarAdapter);
            tvType.setText(item.getName());
            Glide.with(context)
                    .load(item.getIconUrl())
                    .crossFade()
                    // .diskCacheStrategy(DiskCacheStrategy.SOURCE)
                    .into(ivType);
//            List<String> tags = new ArrayList<>();
            locationRegionData.addAll(item.getLocationRegionDatas());
//            for (LocationRegionData regionData : item.getLocationRegionDatas()) {
//                tags.add(regionData.getName());
//            }
            floorBarAdapter.notifyDataSetChanged();
//            tagContainerLayout.setTags(tags);
        }

    }

    public interface OnItemClickListener {
        void onClick(LocationRegionData item);
    }

}
