/*
 * Decompiled with CFR 0.152.
 */
package com.sgerges.epgview.core;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v4.util.SimpleArrayMap;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.EdgeEffect;
import android.widget.OverScroller;
import android.widget.TextView;
import com.sgerges.epgview.R;
import com.sgerges.epgview.animations.DefaultLayoutAnimator;
import com.sgerges.epgview.animations.FreeFlowLayoutAnimator;
import com.sgerges.epgview.core.AbsLayoutContainer;
import com.sgerges.epgview.core.EPGAdapter;
import com.sgerges.epgview.core.EPGLayout;
import com.sgerges.epgview.core.FreeFlowItem;
import com.sgerges.epgview.core.FreeFlowLayout;
import com.sgerges.epgview.core.IndexPath;
import com.sgerges.epgview.core.LayoutChangeSet;
import com.sgerges.epgview.core.Section;
import com.sgerges.epgview.core.ViewPool;
import com.sgerges.epgview.utils.ViewUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class EPGView
extends AbsLayoutContainer {
    private static final String TAG = "FreeFlowContainer";
    protected ViewPool viewpool;
    protected FreeFlowItem.ZIndexComparator zIndexComparator = new FreeFlowItem.ZIndexComparator();
    protected Timer nowLineTimer;
    protected boolean isRTL;
    private boolean preventLayout = false;
    protected EPGAdapter mAdapter;
    protected EPGLayout mLayout;
    protected int viewPortX = 0;
    protected int viewPortY = 0;
    protected int mScrollableWidth;
    protected int mScrollableHeight;
    private VelocityTracker mVelocityTracker = null;
    private float lastTouchX = -1.0f;
    private float lastTouchY = -1.0f;
    private int maxFlingVelocity;
    private int minFlingVelocity;
    private int overFlingDistance;
    private int touchSlop;
    private Runnable mTouchModeReset;
    private Runnable mPerformClick;
    private Runnable mPendingCheckForTap;
    private Runnable mPendingCheckForLongPress;
    private OverScroller scroller;
    protected EdgeEffect mLeftEdge;
    protected EdgeEffect mRightEdge;
    protected EdgeEffect mTopEdge;
    protected EdgeEffect mBottomEdge;
    private ArrayList<OnScrollListener> scrollListeners = new ArrayList();
    protected ContextMenu.ContextMenuInfo mContextMenuInfo = null;
    protected SimpleArrayMap<IndexPath, Boolean> mCheckStates = null;
    ActionMode mChoiceActionMode;
    MultiChoiceModeWrapper mMultiChoiceModeCallback;
    public static final int CHOICE_MODE_NONE = 0;
    public static final int CHOICE_MODE_SINGLE = 1;
    public static final int CHOICE_MODE_MULTIPLE = 2;
    public static final int CHOICE_MODE_MULTIPLE_MODAL = 3;
    int mChoiceMode = 0;
    private FreeFlowLayoutAnimator layoutAnimator = new DefaultLayoutAnimator();
    private FreeFlowItem beginTouchAt;
    private boolean markLayoutDirty = false;
    private boolean markAdapterDirty = false;
    private boolean shouldRecalculateScrollWhenComputingLayout = true;
    private OnTouchModeChangedListener mOnTouchModeChangedListener;
    protected boolean dataSetChanged = false;
    protected boolean isAnimatingChanges = false;
    public static final int TOUCH_MODE_REST = -1;
    public static final int TOUCH_MODE_DOWN = 0;
    public static final int TOUCH_MODE_TAP = 1;
    public static final int TOUCH_MODE_DONE_WAITING = 2;
    public static final int TOUCH_MODE_SCROLL = 3;
    public static final int TOUCH_MODE_FLING = 4;
    public static final int TOUCH_MODE_OVERSCROLL = 5;
    public static final int TOUCH_MODE_OVERFLING = 6;
    int mTouchMode = -1;
    protected final int FLYWHEEL_TIMEOUT = 40;
    private Runnable flingRunnable = new Runnable(){

        @Override
        public void run() {
            if (EPGView.this.scroller.isFinished()) {
                EPGView.this.mTouchMode = -1;
                if (EPGView.this.mOnTouchModeChangedListener != null) {
                    EPGView.this.mOnTouchModeChangedListener.onTouchModeChanged(EPGView.this.mTouchMode);
                }
                EPGView.this.invokeOnItemScrollListeners();
                return;
            }
            boolean more = EPGView.this.scroller.computeScrollOffset();
            if (EPGView.this.mEdgeEffectsEnabled) {
                EPGView.this.checkEdgeEffectDuringScroll();
            }
            if (EPGView.this.mLayout.horizontalScrollEnabled()) {
                EPGView.this.viewPortX = EPGView.this.scroller.getCurrX();
            }
            if (EPGView.this.mLayout.verticalScrollEnabled()) {
                EPGView.this.viewPortY = EPGView.this.scroller.getCurrY();
            }
            EPGView.this.moveViewport(true);
            if (more) {
                EPGView.this.post(EPGView.this.flingRunnable);
            }
        }
    };
    protected boolean mEdgeEffectsEnabled = true;
    boolean isLongClickable = false;
    public boolean logDebugEvents = false;
    private OnEPGItemSelectedListener mOnEPGItemSelectedListener;

    public void setOnTouchModeChangedListener(OnTouchModeChangedListener onTouchModeChangedListener) {
        this.mOnTouchModeChangedListener = onTouchModeChangedListener;
    }

    public EPGView(Context context) {
        super(context);
    }

    public EPGView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public EPGView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init(Context context, AttributeSet attrs, int defStyle) {
        this.viewpool = new ViewPool();
        this.frames = new HashMap();
        this.isRTL = this.getResources().getConfiguration().getLayoutDirection() == 1;
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.maxFlingVelocity = configuration.getScaledMaximumFlingVelocity();
        this.minFlingVelocity = configuration.getScaledMinimumFlingVelocity();
        this.overFlingDistance = configuration.getScaledOverflingDistance();
        this.touchSlop = 1;
        this.scroller = new OverScroller(context);
        this.setEdgeEffectsEnabled(true);
        this.setOnItemSelectedListener(new AbsLayoutContainer.OnItemSelectedListener(){

            @Override
            public void onItemSelected(AbsLayoutContainer parent, FreeFlowItem proxy) {
                if (EPGView.this.mOnEPGItemSelectedListener == null) {
                    return;
                }
                if (proxy.type == 1) {
                    EPGView.this.mOnEPGItemSelectedListener.onProgramItemSelected(EPGView.this, proxy.itemSection, proxy.itemIndex);
                } else if (proxy.type == 0) {
                    EPGView.this.mOnEPGItemSelectedListener.onChannelItemSelected(EPGView.this, proxy.itemSection);
                }
            }

            @Override
            public void onNothingSelected(AbsLayoutContainer parent) {
            }
        });
        EPGLayout.EPGLayoutParams layoutParams = new EPGLayout.EPGLayoutParams();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.EPGView, defStyle, 0);
        layoutParams.channelCellWidth = a.getDimensionPixelSize(R.styleable.EPGView_epg_channelCellWidth, layoutParams.channelCellWidth);
        layoutParams.channelRowHeight = a.getDimensionPixelSize(R.styleable.EPGView_epg_channelRowHeight, layoutParams.channelRowHeight);
        layoutParams.minuteWidth = a.getDimensionPixelSize(R.styleable.EPGView_epg_minuteWidth, layoutParams.minuteWidth);
        layoutParams.nowLineWidth = a.getDimensionPixelSize(R.styleable.EPGView_epg_nowLineThickness, layoutParams.nowLineWidth);
        layoutParams.nowLineColor = a.getColor(R.styleable.EPGView_epg_nowLineColor, layoutParams.nowLineColor);
        layoutParams.timeLineHeight = a.getDimensionPixelSize(R.styleable.EPGView_epg_timeLineHeight, layoutParams.timeLineHeight);
        layoutParams.showPrevProgramsOverlay = a.getBoolean(R.styleable.EPGView_epg_showPrevProgramsOverlay, layoutParams.showPrevProgramsOverlay);
        layoutParams.prevProgramsOverlayColor = a.getInt(R.styleable.EPGView_epg_prevProgramsOverlayColor, layoutParams.prevProgramsOverlayColor);
        a.recycle();
        EPGLayout epgLayout = new EPGLayout();
        epgLayout.setLayoutParams(layoutParams);
        this.setLayout(epgLayout);
        this.nowLineTimer = new Timer();
        this.nowLineTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                EPGView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        EPGView.this.requestLayout();
                    }
                });
            }
        }, 60000L, 60000L);
        this.setScaleX(this.isRTL ? -1.0f : 1.0f);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean sizeChanged;
        this.logLifecycleEvent(" onMeasure ");
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int afterWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int afterHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int beforeWidth = this.getWidth();
        int beforeHeight = this.getHeight();
        boolean bl = sizeChanged = beforeWidth != afterWidth || beforeHeight != afterHeight;
        if (this.mLayout != null) {
            this.mLayout.setDimensions(afterWidth, afterHeight);
        }
        if (this.mLayout == null || this.mAdapter == null) {
            this.logLifecycleEvent("Nothing to do: returning");
            return;
        }
        if (widthMode != 0 && heightMode != 0) {
            this.markAdapterDirty = false;
            this.markLayoutDirty = false;
            this.computeLayout(afterWidth, afterHeight, sizeChanged);
        }
        if (this.dataSetChanged) {
            this.dataSetChanged = false;
            for (FreeFlowItem item : this.frames.values()) {
                if (item.itemIndex < 0 || item.itemSection < 0) continue;
                this.mAdapter.getItemView(item.itemSection, item.itemIndex, item.view, this);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void notifyDataSetChanged() {
        this.dataSetChanged = true;
        this.requestLayout();
    }

    public void dataInvalidated() {
        this.dataInvalidated(false);
    }

    public void dataInvalidated(boolean shouldRecalculateScrollPositions) {
        this.logLifecycleEvent("Data Invalidated");
        if (this.mLayout == null || this.mAdapter == null) {
            return;
        }
        this.shouldRecalculateScrollWhenComputingLayout = shouldRecalculateScrollPositions;
        this.markAdapterDirty = true;
        this.requestLayout();
    }

    protected void computeLayout(int w, int h, boolean sizeChanged) {
        if (sizeChanged) {
            this.mLayout.prepareLayout();
        }
        if (this.shouldRecalculateScrollWhenComputingLayout) {
            this.computeViewPort(this.mLayout);
        }
        Map oldFrames = this.frames;
        this.frames = new HashMap();
        this.copyFrames(this.mLayout.getItemProxies(this.viewPortX, this.viewPortY), this.frames);
        this.dispatchLayoutComputed();
        this.animateChanges(this.getViewChanges(oldFrames, this.frames));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.nowLineTimer != null) {
            this.nowLineTimer.cancel();
            this.nowLineTimer = null;
        }
    }

    protected void copyFrames(Map<Object, FreeFlowItem> srcFrames, Map<Object, FreeFlowItem> destFrames) {
        for (Map.Entry<Object, FreeFlowItem> pairs : srcFrames.entrySet()) {
            FreeFlowItem pr = pairs.getValue();
            pr = FreeFlowItem.clone(pr);
            destFrames.put(pairs.getKey(), pr);
        }
    }

    protected void addAndMeasureViewIfNeeded(FreeFlowItem freeflowItem) {
        View view;
        if (freeflowItem.view == null) {
            View convertView = this.viewpool.getViewFromPool(freeflowItem.type);
            if (freeflowItem.type == 0) {
                view = this.mAdapter.getHeaderViewForSection(freeflowItem.itemSection, convertView, this);
            } else if (freeflowItem.type == 1) {
                view = this.mAdapter.getItemView(freeflowItem.itemSection, freeflowItem.itemIndex, convertView, this);
            } else if (freeflowItem.type == 3) {
                view = this.mAdapter.getViewForTimeCell((Long)freeflowItem.data, convertView, this);
            } else if (freeflowItem.type == 5) {
                view = this.mAdapter.getOverlayViewForPrevPrograms(this.mLayout.getLayoutParams().prevProgramsOverlayColor, convertView, this);
            } else if (freeflowItem.type == 4) {
                view = this.mAdapter.getViewForNowLineHead(convertView, this);
                if (view.getLayoutParams().width != 0 && view.getLayoutParams().height != 0) {
                    freeflowItem.frame.right = freeflowItem.frame.left + view.getLayoutParams().width;
                    freeflowItem.frame.bottom = freeflowItem.frame.top + view.getLayoutParams().height;
                    this.mLayout.forceUpdateFrame(freeflowItem.data, freeflowItem.frame);
                }
            } else if (freeflowItem.type == 2) {
                view = new View(this.getContext());
                view.setBackgroundColor(this.mLayout.getLayoutParams().nowLineColor);
            } else {
                view = new View(this.getContext());
            }
            if (view instanceof EPGView) {
                throw new IllegalStateException("A container cannot be a direct child view to a container");
            }
            freeflowItem.view = view;
            this.prepareViewForAddition(view, freeflowItem);
            this.addView(view);
        }
        view = freeflowItem.view;
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)freeflowItem.frame.width(), (int)0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)freeflowItem.frame.height(), (int)0x40000000);
        view.measure(widthSpec, heightSpec);
        if (this.isRTL) {
            this.mirrorArabicBackIfTextView(view);
        }
    }

    private void mirrorArabicBackIfTextView(View parentView) {
        if (parentView == null) {
            return;
        }
        if (parentView instanceof TextView) {
            parentView.setScaleX(-1.0f);
            return;
        }
        if (parentView instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)parentView;
            int childCount = viewGroup.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View view = viewGroup.getChildAt(i);
                this.mirrorArabicBackIfTextView(view);
            }
        }
    }

    protected void prepareViewForAddition(View view, FreeFlowItem freeflowItem) {
        if (view instanceof Checkable) {
            ((Checkable)view).setChecked(this.isChecked(freeflowItem.itemSection, freeflowItem.itemIndex));
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.logLifecycleEvent("onLayout");
        this.dispatchLayoutComplete(this.isAnimatingChanges);
    }

    protected void doLayout(FreeFlowItem freeflowItem) {
        int viewBottom;
        int viewTop;
        int viewRight;
        int viewLeft;
        View view = freeflowItem.view;
        Rect frame = freeflowItem.frame;
        int cellWidth = frame.width();
        int cellHeight = frame.height();
        if (freeflowItem.type == 2) {
            viewLeft = frame.left - this.viewPortX;
            viewRight = frame.right - this.viewPortX;
            viewTop = frame.top - this.viewPortY;
            viewBottom = Math.min(frame.bottom - this.viewPortY, this.getHeight());
        } else if (freeflowItem.type == 5) {
            viewLeft = 0;
            viewRight = Math.min(frame.right - this.viewPortX, this.getWidth());
            viewTop = 0;
            viewBottom = Math.min(frame.bottom - this.viewPortY, this.getHeight());
        } else if (freeflowItem.type == 0) {
            viewLeft = 0;
            viewRight = cellWidth;
            viewTop = frame.top - this.viewPortY;
            viewBottom = frame.bottom - this.viewPortY;
        } else if (freeflowItem.type == 4) {
            viewLeft = frame.left - this.viewPortX;
            viewRight = frame.right - this.viewPortX;
            viewTop = 0;
            viewBottom = cellHeight;
        } else if (freeflowItem.type == 3) {
            viewLeft = frame.left - this.viewPortX;
            viewRight = frame.right - this.viewPortX;
            viewTop = 0;
            viewBottom = cellHeight;
        } else {
            viewLeft = frame.left - this.viewPortX;
            viewRight = frame.right - this.viewPortX;
            viewTop = frame.top - this.viewPortY;
            viewBottom = frame.bottom - this.viewPortY;
        }
        view.layout(viewLeft, viewTop, viewRight, viewBottom);
    }

    private void setLayout(EPGLayout newLayout) {
        if (newLayout == this.mLayout || newLayout == null) {
            return;
        }
        this.stopScrolling();
        this.mLayout = newLayout;
        this.shouldRecalculateScrollWhenComputingLayout = true;
        if (this.mAdapter != null) {
            this.mLayout.setAdapter(this.mAdapter);
        }
        this.markLayoutDirty = true;
        this.viewPortX = 0;
        this.viewPortY = 0;
        this.logLifecycleEvent("Setting layout");
        this.requestLayout();
    }

    public void stopScrolling() {
        if (!this.scroller.isFinished()) {
            this.scroller.forceFinished(true);
        }
        this.removeCallbacks(this.flingRunnable);
        this.resetAllCallbacks();
        this.mTouchMode = -1;
        if (this.mOnTouchModeChangedListener != null) {
            this.mOnTouchModeChangedListener.onTouchModeChanged(this.mTouchMode);
        }
    }

    protected void resetAllCallbacks() {
        if (this.mPendingCheckForTap != null) {
            this.removeCallbacks(this.mPendingCheckForTap);
            this.mPendingCheckForTap = null;
        }
        if (this.mPendingCheckForLongPress != null) {
            this.removeCallbacks(this.mPendingCheckForLongPress);
            this.mPendingCheckForLongPress = null;
        }
        if (this.mTouchModeReset != null) {
            this.removeCallbacks(this.mTouchModeReset);
            this.mTouchModeReset = null;
        }
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
            this.mPerformClick = null;
        }
    }

    protected void computeViewPort(FreeFlowLayout newLayout) {
        if (this.mLayout == null || this.frames == null || this.frames.size() == 0) {
            this.viewPortX = 0;
            this.viewPortY = 0;
            return;
        }
        this.mScrollableWidth = this.mLayout.getContentWidth() - this.getWidth();
        this.mScrollableHeight = this.mLayout.getContentHeight() - this.getHeight();
        if (this.mScrollableWidth < 0) {
            this.mScrollableWidth = 0;
        }
        if (this.mScrollableHeight < 0) {
            this.mScrollableHeight = 0;
        }
        if (this.viewPortX > this.mScrollableWidth) {
            this.viewPortX = this.mScrollableWidth;
        }
        if (this.viewPortY > this.mScrollableHeight) {
            this.viewPortY = this.mScrollableHeight;
        }
    }

    public Rect getActualFrame(FreeFlowItem freeflowItem) {
        View v = freeflowItem.view;
        if (v == null) {
            return null;
        }
        Rect of = new Rect();
        of.left = (int)((float)v.getLeft() + v.getTranslationX());
        of.top = (int)((float)v.getTop() + v.getTranslationY());
        of.right = (int)((float)v.getRight() + v.getTranslationX());
        of.bottom = (int)((float)v.getBottom() + v.getTranslationY());
        return of;
    }

    public FreeFlowItem getFreeFlowItem(Object dataItem) {
        for (FreeFlowItem item : this.frames.values()) {
            if (!item.data.equals(dataItem)) continue;
            return item;
        }
        return null;
    }

    public void layoutChanged() {
        this.logLifecycleEvent("layoutChanged");
        this.markLayoutDirty = true;
        this.dispatchDataChanged();
        this.requestLayout();
    }

    private void animateChanges(LayoutChangeSet changeSet) {
        this.logLifecycleEvent("animating changes: " + changeSet.toString());
        if (changeSet.added.size() == 0 && changeSet.removed.size() == 0 && changeSet.moved.size() == 0) {
            return;
        }
        ArrayList<FreeFlowItem> allVisible = new ArrayList<FreeFlowItem>();
        for (FreeFlowItem freeflowItem : changeSet.getAdded()) {
            this.addAndMeasureViewIfNeeded(freeflowItem);
            this.doLayout(freeflowItem);
            if (freeflowItem.zIndex <= 0) continue;
            allVisible.add(freeflowItem);
        }
        Collections.sort(allVisible, this.zIndexComparator);
        for (FreeFlowItem freeFlowItem : allVisible) {
            freeFlowItem.view.bringToFront();
        }
        if (this.isAnimatingChanges) {
            this.layoutAnimator.cancel();
        }
        this.isAnimatingChanges = true;
        this.dispatchAnimationsStarting();
        this.layoutAnimator.animateChanges(changeSet, this);
    }

    public void onLayoutChangeAnimationsCompleted(FreeFlowLayoutAnimator anim) {
        this.isAnimatingChanges = false;
        this.logLifecycleEvent("layout change animations complete");
        for (FreeFlowItem freeflowItem : anim.getChangeSet().getRemoved()) {
            View v = freeflowItem.view;
            this.removeView(v);
            this.returnItemToPoolIfNeeded(freeflowItem);
        }
        this.dispatchLayoutChangeAnimationsComplete();
    }

    public LayoutChangeSet getViewChanges(Map<Object, FreeFlowItem> oldFrames, Map<Object, FreeFlowItem> newFrames) {
        return this.getViewChanges(oldFrames, newFrames, false);
    }

    public LayoutChangeSet getViewChanges(Map<Object, FreeFlowItem> oldFrames, Map<Object, FreeFlowItem> newFrames, boolean moveEvenIfSame) {
        LayoutChangeSet change = new LayoutChangeSet();
        if (oldFrames == null) {
            this.markAdapterDirty = false;
            for (FreeFlowItem freeflowItem : newFrames.values()) {
                change.addToAdded(freeflowItem);
            }
            return change;
        }
        if (this.markAdapterDirty) {
            this.markAdapterDirty = false;
            for (FreeFlowItem freeflowItem : newFrames.values()) {
                change.addToAdded(freeflowItem);
            }
            for (FreeFlowItem freeflowItem : oldFrames.values()) {
                change.addToDeleted(freeflowItem);
            }
            return change;
        }
        for (Map.Entry<Object, FreeFlowItem> m : newFrames.entrySet()) {
            FreeFlowItem freeflowItem = m.getValue();
            if (oldFrames.get(m.getKey()) != null) {
                FreeFlowItem old = oldFrames.remove(m.getKey());
                freeflowItem.view = old.view;
                if (!moveEvenIfSame && old.frame.equals((Object)m.getValue().frame)) continue;
                change.addToMoved(freeflowItem, this.getActualFrame(freeflowItem));
                continue;
            }
            change.addToAdded(freeflowItem);
        }
        for (FreeFlowItem freeflowItem : oldFrames.values()) {
            change.addToDeleted(freeflowItem);
        }
        this.frames = newFrames;
        return change;
    }

    public void requestLayout() {
        if (!this.preventLayout) {
            super.requestLayout();
        }
    }

    public void setAdapter(EPGAdapter adapter) {
        if (adapter == this.mAdapter) {
            return;
        }
        this.stopScrolling();
        this.logLifecycleEvent("setting adapter");
        this.markAdapterDirty = true;
        this.viewPortX = 0;
        this.viewPortY = 0;
        this.shouldRecalculateScrollWhenComputingLayout = true;
        this.mAdapter = adapter;
        if (this.mLayout != null) {
            this.mLayout.setAdapter(this.mAdapter);
        }
        this.requestLayout();
    }

    public int getViewportLeft() {
        return this.viewPortX;
    }

    public int getViewportTop() {
        return this.viewPortY;
    }

    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        if (this.mLayout == null) {
            return false;
        }
        boolean canScroll = false;
        if (this.mLayout.horizontalScrollEnabled() && this.mLayout.getContentWidth() > this.getWidth()) {
            canScroll = true;
        }
        if (this.mLayout.verticalScrollEnabled() && this.mLayout.getContentHeight() > this.getHeight()) {
            canScroll = true;
        }
        switch (event.getAction()) {
            case 0: {
                this.touchDown(event);
                break;
            }
            case 2: {
                if (!canScroll) break;
                this.touchMove(event);
                break;
            }
            case 1: {
                this.touchUp(event);
                break;
            }
            case 3: {
                this.touchCancel(event);
            }
        }
        if (!canScroll) {
            return true;
        }
        if (this.mVelocityTracker == null && canScroll) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(event);
        }
        return true;
    }

    protected void touchDown(MotionEvent event) {
        if (this.isAnimatingChanges) {
            this.layoutAnimator.onContainerTouchDown(event);
        }
        this.mScrollableHeight = this.mLayout.getContentHeight() - this.getHeight();
        this.mScrollableWidth = this.mLayout.getContentWidth() - this.getWidth();
        if (this.mTouchMode == 4) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (EPGView.this.mTouchMode == 0 && EPGView.this.mTouchMode == 0) {
                        EPGView.this.scroller.forceFinished(true);
                    }
                }
            }, 40L);
        }
        this.beginTouchAt = ViewUtils.getItemAt(this.frames, (int)((float)this.viewPortX + event.getX()), (int)((float)this.viewPortY + event.getY()));
        FreeFlowItem screenEndTouchAt = ViewUtils.getItemAt(this.frames, (int)event.getX(), (int)((float)this.viewPortY + event.getY()));
        if (screenEndTouchAt != null && screenEndTouchAt.zIndex > this.beginTouchAt.zIndex) {
            this.beginTouchAt = screenEndTouchAt;
        }
        this.lastTouchX = event.getX();
        this.lastTouchY = event.getY();
        this.mTouchMode = 0;
        if (this.mOnTouchModeChangedListener != null) {
            this.mOnTouchModeChangedListener.onTouchModeChanged(this.mTouchMode);
        }
        if (this.mPendingCheckForTap != null) {
            this.removeCallbacks(this.mPendingCheckForTap);
            this.mPendingCheckForLongPress = null;
        }
        if (this.beginTouchAt != null) {
            this.mPendingCheckForTap = new CheckForTap();
        }
        this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
    }

    protected void touchMove(MotionEvent event) {
        float str;
        float xDiff = event.getX() - this.lastTouchX;
        float yDiff = event.getY() - this.lastTouchY;
        double distance = Math.sqrt(xDiff * xDiff + yDiff * yDiff);
        if (this.mLayout.verticalScrollEnabled()) {
            if (yDiff > 0.0f && this.viewPortY == 0) {
                if (this.mEdgeEffectsEnabled) {
                    str = (float)distance / (float)this.getHeight();
                    this.mTopEdge.onPull(str);
                    this.invalidate();
                }
                if (!this.mLayout.horizontalScrollEnabled()) {
                    return;
                }
            }
            if (yDiff < 0.0f && this.viewPortY == this.mScrollableHeight) {
                if (this.mEdgeEffectsEnabled) {
                    str = (float)distance / (float)this.getHeight();
                    this.mBottomEdge.onPull(str);
                    this.invalidate();
                }
                if (!this.mLayout.horizontalScrollEnabled()) {
                    return;
                }
            }
        }
        if (this.mLayout.horizontalScrollEnabled()) {
            if (xDiff > 0.0f && this.viewPortX == 0 && this.mEdgeEffectsEnabled) {
                str = (float)distance / (float)this.getWidth();
                this.mLeftEdge.onPull(str);
                this.invalidate();
                if (!this.mLayout.verticalScrollEnabled()) {
                    return;
                }
            }
            if (xDiff < 0.0f && this.viewPortY == this.mScrollableWidth && this.mEdgeEffectsEnabled) {
                str = (float)distance / (float)this.getWidth();
                this.mRightEdge.onPull(str);
                this.invalidate();
                if (!this.mLayout.verticalScrollEnabled()) {
                    return;
                }
            }
        }
        if ((this.mTouchMode == 0 || this.mTouchMode == -1) && distance > (double)this.touchSlop) {
            this.mTouchMode = 3;
            if (this.mOnTouchModeChangedListener != null) {
                this.mOnTouchModeChangedListener.onTouchModeChanged(this.mTouchMode);
            }
            if (this.mPendingCheckForTap != null) {
                this.removeCallbacks(this.mPendingCheckForTap);
                this.mPendingCheckForTap = null;
            }
        }
        if (this.mTouchMode == 3) {
            this.moveViewportBy(xDiff, yDiff, false);
            this.lastTouchX = event.getX();
            this.lastTouchY = event.getY();
        }
    }

    protected void touchCancel(MotionEvent event) {
        this.mTouchMode = -1;
        if (this.mOnTouchModeChangedListener != null) {
            this.mOnTouchModeChangedListener.onTouchModeChanged(this.mTouchMode);
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    protected void touchUp(MotionEvent event) {
        if ((this.mTouchMode == 3 || this.mTouchMode == 6) && this.mVelocityTracker != null) {
            this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.maxFlingVelocity);
            if (Math.abs(this.mVelocityTracker.getXVelocity()) > (float)this.minFlingVelocity || Math.abs(this.mVelocityTracker.getYVelocity()) > (float)this.minFlingVelocity) {
                int maxX = this.mLayout.getContentWidth() - this.getWidth();
                int maxY = this.mLayout.getContentHeight() - this.getHeight();
                int allowedScrollOffset = this.mTouchMode == 3 ? 0 : this.overFlingDistance;
                this.scroller.fling(this.viewPortX, this.viewPortY, -((int)this.mVelocityTracker.getXVelocity()), -((int)this.mVelocityTracker.getYVelocity()), 0, maxX, 0, maxY, allowedScrollOffset, allowedScrollOffset);
                this.mTouchMode = 4;
                if (this.mOnTouchModeChangedListener != null) {
                    this.mOnTouchModeChangedListener.onTouchModeChanged(this.mTouchMode);
                }
                this.post(this.flingRunnable);
            } else {
                this.mTouchMode = -1;
                if (this.mOnTouchModeChangedListener != null) {
                    this.mOnTouchModeChangedListener.onTouchModeChanged(this.mTouchMode);
                }
            }
        } else if (this.mTouchMode == 0 || this.mTouchMode == 2) {
            if (this.mTouchModeReset != null) {
                this.removeCallbacks(this.mTouchModeReset);
            }
            FreeFlowItem endTouchAt = ViewUtils.getItemAt(this.frames, (int)((float)this.viewPortX + event.getX()), (int)((float)this.viewPortY + event.getY()));
            FreeFlowItem screenEndTouchAt = ViewUtils.getItemAt(this.frames, (int)event.getX(), (int)((float)this.viewPortY + event.getY()));
            if (screenEndTouchAt != null && screenEndTouchAt.zIndex > endTouchAt.zIndex) {
                endTouchAt = screenEndTouchAt;
            }
            if (this.beginTouchAt != null && this.beginTouchAt.view != null && this.beginTouchAt == endTouchAt) {
                this.beginTouchAt.view.setPressed(true);
                this.mTouchModeReset = new Runnable(){

                    @Override
                    public void run() {
                        EPGView.this.mTouchModeReset = null;
                        EPGView.this.mTouchMode = -1;
                        if (EPGView.this.mOnTouchModeChangedListener != null) {
                            EPGView.this.mOnTouchModeChangedListener.onTouchModeChanged(EPGView.this.mTouchMode);
                        }
                        if (EPGView.this.beginTouchAt != null && ((EPGView)EPGView.this).beginTouchAt.view != null) {
                            ((EPGView)EPGView.this).beginTouchAt.view.setPressed(false);
                        }
                        if (EPGView.this.mChoiceActionMode == null && EPGView.this.mOnItemSelectedListener != null) {
                            EPGView.this.mOnItemSelectedListener.onItemSelected(EPGView.this, EPGView.this.selectedFreeFlowItem);
                        }
                    }
                };
                this.selectedFreeFlowItem = this.beginTouchAt;
                this.postDelayed(this.mTouchModeReset, ViewConfiguration.getPressedStateDuration());
                this.mTouchMode = 1;
                this.mPerformClick = new PerformClick();
                this.mPerformClick.run();
                if (this.mOnTouchModeChangedListener != null) {
                    this.mOnTouchModeChangedListener.onTouchModeChanged(this.mTouchMode);
                }
            } else {
                this.mTouchMode = -1;
                if (this.mOnTouchModeChangedListener != null) {
                    this.mOnTouchModeChangedListener.onTouchModeChanged(this.mTouchMode);
                }
            }
        }
    }

    public FreeFlowItem getSelectedFreeFlowItem() {
        return this.selectedFreeFlowItem;
    }

    protected void checkEdgeEffectDuringScroll() {
        if (this.mLeftEdge.isFinished() && this.viewPortX < 0 && this.mLayout.horizontalScrollEnabled()) {
            this.mLeftEdge.onAbsorb((int)this.scroller.getCurrVelocity());
        }
        if (this.mRightEdge.isFinished() && this.viewPortX > this.mLayout.getContentWidth() - this.getMeasuredWidth() && this.mLayout.horizontalScrollEnabled()) {
            this.mRightEdge.onAbsorb((int)this.scroller.getCurrVelocity());
        }
        if (this.mTopEdge.isFinished() && this.viewPortY < 0 && this.mLayout.verticalScrollEnabled()) {
            this.mTopEdge.onAbsorb((int)this.scroller.getCurrVelocity());
        }
        if (this.mBottomEdge.isFinished() && this.viewPortY > this.mLayout.getContentHeight() - this.getMeasuredHeight() && this.mLayout.verticalScrollEnabled()) {
            this.mBottomEdge.onAbsorb((int)this.scroller.getCurrVelocity());
        }
    }

    protected void moveViewportBy(float movementX, float movementY, boolean fling) {
        if (this.mLayout.horizontalScrollEnabled()) {
            this.viewPortX = (int)((float)this.viewPortX - movementX);
        }
        if (this.mLayout.verticalScrollEnabled()) {
            this.viewPortY = (int)((float)this.viewPortY - movementY);
        }
        this.moveViewport(fling);
    }

    protected void moveViewPort(int left, int top, boolean isInFlingMode) {
        this.viewPortX = left;
        this.viewPortY = top;
        this.moveViewport(isInFlingMode);
    }

    protected void moveViewport(boolean isInFlingMode) {
        this.mScrollableWidth = this.mLayout.getContentWidth() - this.getWidth();
        if (this.mScrollableWidth < 0) {
            this.mScrollableWidth = 0;
        }
        this.mScrollableHeight = this.mLayout.getContentHeight() - this.getHeight();
        if (this.mScrollableHeight < 0) {
            this.mScrollableHeight = 0;
        }
        if (isInFlingMode) {
            if (this.viewPortX < 0 || this.viewPortX > this.mScrollableWidth || this.viewPortY < 0 || this.viewPortY > this.mScrollableHeight) {
                this.mTouchMode = 6;
            }
        } else {
            if (this.viewPortX < -this.overFlingDistance) {
                this.viewPortX = -this.overFlingDistance;
            } else if (this.viewPortX > this.mScrollableWidth + this.overFlingDistance) {
                this.viewPortX = this.mScrollableWidth + this.overFlingDistance;
            }
            if (this.viewPortY < -this.overFlingDistance) {
                this.viewPortY = -this.overFlingDistance;
            } else if (this.viewPortY > this.mScrollableHeight + this.overFlingDistance) {
                this.viewPortY = this.mScrollableHeight + this.overFlingDistance;
            }
            if (this.mEdgeEffectsEnabled && this.overFlingDistance > 0) {
                if (this.viewPortX <= 0) {
                    this.mLeftEdge.onPull((float)(this.viewPortX / -this.overFlingDistance));
                } else if (this.viewPortX >= this.mScrollableWidth) {
                    this.mRightEdge.onPull((float)((this.viewPortX - this.mScrollableWidth) / -this.overFlingDistance));
                }
                if (this.viewPortY <= 0) {
                    this.mTopEdge.onPull((float)(this.viewPortY / -this.overFlingDistance));
                } else if (this.viewPortY >= this.mScrollableHeight) {
                    this.mBottomEdge.onPull((float)((this.viewPortY - this.mScrollableHeight) / -this.overFlingDistance));
                }
            }
        }
        Map oldFrames = this.frames;
        this.frames = new HashMap();
        this.copyFrames(this.mLayout.getItemProxies(this.viewPortX, this.viewPortY), this.frames);
        LayoutChangeSet changeSet = this.getViewChanges(oldFrames, this.frames, true);
        ArrayList<FreeFlowItem> allVisible = new ArrayList<FreeFlowItem>();
        for (FreeFlowItem freeFlowItem : changeSet.added) {
            this.addAndMeasureViewIfNeeded(freeFlowItem);
            this.doLayout(freeFlowItem);
            if (freeFlowItem.zIndex <= 0) continue;
            allVisible.add(freeFlowItem);
        }
        for (Pair pair : changeSet.moved) {
            FreeFlowItem freeflowItem = (FreeFlowItem)pair.first;
            this.doLayout(freeflowItem);
            if (freeflowItem.zIndex <= 0) continue;
            allVisible.add(freeflowItem);
        }
        Collections.sort(allVisible, this.zIndexComparator);
        for (FreeFlowItem freeFlowItem : allVisible) {
            freeFlowItem.view.bringToFront();
        }
        for (FreeFlowItem freeFlowItem : changeSet.removed) {
            this.removeViewInLayout(freeFlowItem.view);
            this.returnItemToPoolIfNeeded(freeFlowItem);
        }
        this.invalidate();
        this.invokeOnItemScrollListeners();
    }

    public void setEdgeEffectsEnabled(boolean val) {
        this.mEdgeEffectsEnabled = val;
        if (val) {
            Context context = this.getContext();
            this.setWillNotDraw(false);
            this.mLeftEdge = new EdgeEffect(context);
            this.mRightEdge = new EdgeEffect(context);
            this.mTopEdge = new EdgeEffect(context);
            this.mBottomEdge = new EdgeEffect(context);
        } else {
            this.setWillNotDraw(true);
            this.mBottomEdge = null;
            this.mTopEdge = null;
            this.mRightEdge = null;
            this.mLeftEdge = null;
        }
    }

    public void draw(Canvas canvas) {
        int restoreCount;
        super.draw(canvas);
        boolean needsInvalidate = false;
        int height = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int width = this.getMeasuredWidth();
        if (!this.mLeftEdge.isFinished()) {
            restoreCount = canvas.save();
            canvas.rotate(270.0f);
            canvas.translate((float)(-height + this.getPaddingTop()), 0.0f);
            this.mLeftEdge.setSize(height, width);
            needsInvalidate = this.mLeftEdge.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mTopEdge.isFinished()) {
            restoreCount = canvas.save();
            this.mTopEdge.setSize(width, height);
            needsInvalidate = this.mTopEdge.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mRightEdge.isFinished()) {
            restoreCount = canvas.save();
            canvas.rotate(90.0f);
            canvas.translate(0.0f, (float)(-width));
            this.mRightEdge.setSize(height, width);
            needsInvalidate = this.mRightEdge.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mBottomEdge.isFinished()) {
            restoreCount = canvas.save();
            canvas.rotate(180.0f);
            canvas.translate((float)(-width + this.getPaddingTop()), (float)(-height));
            this.mBottomEdge.setSize(width, height);
            needsInvalidate = this.mBottomEdge.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        if (needsInvalidate) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected void returnItemToPoolIfNeeded(FreeFlowItem freeflowItem) {
        View v = freeflowItem.view;
        v.setTranslationX(0.0f);
        v.setTranslationY(0.0f);
        v.setRotation(0.0f);
        v.setAlpha(1.0f);
        this.viewpool.returnViewToPool(v, freeflowItem.type);
    }

    public EPGAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setLayoutAnimator(FreeFlowLayoutAnimator anim) {
        this.layoutAnimator = anim;
    }

    public FreeFlowLayoutAnimator getLayoutAnimator() {
        return this.layoutAnimator;
    }

    public Map<Object, FreeFlowItem> getFrames() {
        return this.frames;
    }

    public void clearFrames() {
        this.removeAllViews();
        this.frames = null;
    }

    public boolean shouldDelayChildPressedState() {
        return true;
    }

    public int getCheckedItemCount() {
        return this.mCheckStates.size();
    }

    public ArrayList<IndexPath> getCheckedItemPositions() {
        ArrayList<IndexPath> checked = new ArrayList<IndexPath>();
        for (int i = 0; i < this.mCheckStates.size(); ++i) {
            checked.add((IndexPath)this.mCheckStates.keyAt(i));
        }
        return checked;
    }

    public void clearChoices() {
        this.mCheckStates.clear();
    }

    public void setChoiceMode(int choiceMode) {
        this.mChoiceMode = choiceMode;
        if (this.mChoiceActionMode != null) {
            this.mChoiceActionMode.finish();
            this.mChoiceActionMode = null;
        }
        if (this.mChoiceMode != 0) {
            if (this.mCheckStates == null) {
                this.mCheckStates = new SimpleArrayMap();
            }
            if (this.mChoiceMode == 3) {
                this.clearChoices();
                this.setLongClickable(true);
            }
        }
    }

    public void setLongClickable(boolean b) {
        this.isLongClickable = b;
    }

    public boolean isLongClickable() {
        return this.isLongClickable;
    }

    public void setMultiChoiceModeListener(MultiChoiceModeListener listener) {
        if (this.mMultiChoiceModeCallback == null) {
            this.mMultiChoiceModeCallback = new MultiChoiceModeWrapper();
        }
        this.mMultiChoiceModeCallback.setWrapped(listener);
    }

    boolean performLongPress() {
        if (this.mChoiceMode == 3) {
            if (this.mChoiceActionMode == null && (this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback)) != null) {
                this.setItemChecked(this.beginTouchAt.itemSection, this.beginTouchAt.itemIndex, true);
                this.updateOnScreenCheckedViews();
                this.performHapticFeedback(0);
            }
            return true;
        }
        boolean handled = false;
        long longPressId = this.mAdapter.getItemId(this.beginTouchAt.itemSection, this.beginTouchAt.itemSection);
        if (this.mOnItemLongClickListener != null) {
            handled = this.mOnItemLongClickListener.onItemLongClick(this, this.beginTouchAt.view, this.beginTouchAt.itemSection, this.beginTouchAt.itemIndex, longPressId);
        }
        if (!handled) {
            this.mContextMenuInfo = this.createContextMenuInfo(this.beginTouchAt.view, this.beginTouchAt.itemSection, this.beginTouchAt.itemIndex, longPressId);
            handled = super.showContextMenuForChild((View)this);
        }
        if (handled) {
            this.updateOnScreenCheckedViews();
            this.performHapticFeedback(0);
        }
        return handled;
    }

    ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int sectionIndex, int positionInSection, long id) {
        return new AbsLayoutContainer.AbsLayoutContainerContextMenuInfo(view, sectionIndex, positionInSection, id);
    }

    @Override
    public void setOnItemLongClickListener(AbsLayoutContainer.OnItemLongClickListener listener) {
        super.setOnItemLongClickListener(listener);
        if (this.mCheckStates == null) {
            this.mCheckStates = new SimpleArrayMap();
        }
    }

    public void setItemChecked(int sectionIndex, int positionInSection, boolean value) {
        if (this.mChoiceMode == 0) {
            return;
        }
        if (value && this.mChoiceMode == 3 && this.mChoiceActionMode == null) {
            if (this.mMultiChoiceModeCallback == null || !this.mMultiChoiceModeCallback.hasWrappedCallback()) {
                throw new IllegalStateException("Container: attempted to start selection mode for CHOICE_MODE_MULTIPLE_MODAL but no choice mode callback was supplied. Call setMultiChoiceModeListener to set a callback.");
            }
            this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback);
        }
        if (this.mChoiceMode == 2 || this.mChoiceMode == 3) {
            this.setCheckedValue(sectionIndex, positionInSection, value);
            if (this.mChoiceActionMode != null) {
                long id = this.mAdapter.getItemId(sectionIndex, positionInSection);
                this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, sectionIndex, positionInSection, id, value);
            }
        } else {
            this.setCheckedValue(sectionIndex, positionInSection, value);
        }
        this.requestLayout();
    }

    @Override
    public boolean performItemClick(View view, int section, int position, long id) {
        boolean handled = false;
        boolean dispatchItemClick = true;
        if (this.mChoiceMode != 0) {
            handled = true;
            boolean checkedStateChanged = false;
            if (this.mChoiceMode == 2 || this.mChoiceMode == 3 && this.mChoiceActionMode != null) {
                boolean checked = this.isChecked(section, position);
                checked = !checked;
                this.setCheckedValue(section, position, checked);
                if (this.mChoiceActionMode != null) {
                    this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, section, position, id, checked);
                    dispatchItemClick = false;
                }
                checkedStateChanged = true;
            } else if (this.mChoiceMode == 1) {
                boolean checked;
                boolean bl = checked = !this.isChecked(section, position);
                if (checked) {
                    this.setCheckedValue(section, position, checked);
                }
                checkedStateChanged = true;
            }
            if (checkedStateChanged) {
                this.updateOnScreenCheckedViews();
            }
        }
        if (dispatchItemClick) {
            handled |= super.performItemClick(view, section, position, id);
        }
        return handled;
    }

    private void updateOnScreenCheckedViews() {
        Iterator it = this.frames.entrySet().iterator();
        View child = null;
        while (it.hasNext()) {
            Map.Entry pairs = it.next();
            child = ((FreeFlowItem)pairs.getValue()).view;
            boolean isChecked = this.isChecked(((FreeFlowItem)pairs.getValue()).itemSection, ((FreeFlowItem)pairs.getValue()).itemIndex);
            if (child instanceof Checkable) {
                ((Checkable)child).setChecked(isChecked);
                continue;
            }
            child.setActivated(isChecked);
        }
    }

    public boolean isChecked(int sectionIndex, int positionInSection) {
        for (int i = 0; i < this.mCheckStates.size(); ++i) {
            IndexPath p = (IndexPath)this.mCheckStates.keyAt(i);
            if (p.section != sectionIndex || p.positionInSection != positionInSection) continue;
            return true;
        }
        return false;
    }

    protected void setCheckedValue(int sectionIndex, int positionInSection, boolean val) {
        int foundAtIndex = -1;
        for (int i = 0; i < this.mCheckStates.size(); ++i) {
            IndexPath p = (IndexPath)this.mCheckStates.keyAt(i);
            if (p.section != sectionIndex || p.positionInSection != positionInSection) continue;
            foundAtIndex = i;
            break;
        }
        if (foundAtIndex > -1 && !val) {
            this.mCheckStates.removeAt(foundAtIndex);
        } else if (foundAtIndex == -1 && val) {
            IndexPath pos = new IndexPath(sectionIndex, positionInSection);
            this.mCheckStates.put((Object)pos, (Object)true);
        }
    }

    public void addScrollListener(OnScrollListener listener) {
        if (!this.scrollListeners.contains(listener)) {
            this.scrollListeners.add(listener);
        }
    }

    public void removeScrollListener(OnScrollListener listener) {
        this.scrollListeners.remove(listener);
    }

    public void scrollToNow(boolean animate) {
        FreeFlowItem nowLineFreeFlowItem = this.mLayout.getNowLineFreeFlowItem();
        this.scrollToFreeFlowItem(nowLineFreeFlowItem, animate);
    }

    public void scrollToItem(int sectionIndex, int itemIndex, boolean animate) {
        Section section;
        if (sectionIndex > this.mAdapter.getNumberOfChannels() || sectionIndex < 0 || (section = this.mAdapter.getSection(sectionIndex)) == null) {
            return;
        }
        if (itemIndex < 0 || itemIndex > section.getDataCount()) {
            return;
        }
        FreeFlowItem freeflowItem = this.mLayout.getFreeFlowItemForItem(section.getDataAtIndex(itemIndex));
        freeflowItem = FreeFlowItem.clone(freeflowItem);
        this.scrollToFreeFlowItem(freeflowItem, animate);
    }

    private void scrollToFreeFlowItem(FreeFlowItem freeflowItem, boolean animate) {
        if (freeflowItem == null) {
            return;
        }
        int newVPX = freeflowItem.frame.left - this.getWidth() / 2;
        int newVPY = freeflowItem.frame.top;
        if (newVPX > this.mLayout.getContentWidth() - this.getMeasuredWidth()) {
            newVPX = this.mLayout.getContentWidth() - this.getMeasuredWidth();
        }
        if (newVPY > this.mLayout.getContentHeight() - this.getMeasuredHeight()) {
            newVPY = this.mLayout.getContentHeight() - this.getMeasuredHeight();
        }
        if (animate) {
            this.scroller.startScroll(this.viewPortX, this.viewPortY, newVPX - this.viewPortX, newVPY - this.viewPortY, 1500);
            this.post(this.flingRunnable);
        } else {
            this.moveViewportBy(this.viewPortX - newVPX, this.viewPortY - newVPY, false);
        }
    }

    public float getScrollPercentX() {
        if (this.mLayout == null || this.mAdapter == null) {
            return 0.0f;
        }
        float w = this.mLayout.getContentWidth();
        float scrollableWidth = w - (float)this.getWidth();
        if (scrollableWidth == 0.0f) {
            return 0.0f;
        }
        return (float)this.viewPortX / scrollableWidth;
    }

    public float getScrollPercentY() {
        if (this.mLayout == null || this.mAdapter == null) {
            return 0.0f;
        }
        float ht = this.mLayout.getContentHeight();
        float scrollableHeight = ht - (float)this.getHeight();
        if (scrollableHeight == 0.0f) {
            return 0.0f;
        }
        return (float)this.viewPortY / scrollableHeight;
    }

    protected void invokeOnItemScrollListeners() {
        for (OnScrollListener l : this.scrollListeners) {
            l.onScroll(this);
        }
    }

    protected void reportScrollStateChange(int state) {
    }

    private void logLifecycleEvent(String msg) {
    }

    public void setmOnEPGItemSelectedListener(OnEPGItemSelectedListener listener) {
        this.mOnEPGItemSelectedListener = listener;
    }

    public static interface OnEPGItemSelectedListener {
        public void onProgramItemSelected(AbsLayoutContainer var1, int var2, int var3);

        public void onChannelItemSelected(AbsLayoutContainer var1, int var2);
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScroll(EPGView var1);
    }

    private class PerformClick
    implements Runnable {
        private PerformClick() {
        }

        @Override
        public void run() {
            View view = ((EPGView)EPGView.this).beginTouchAt.view;
            if (view != null) {
                EPGView.this.performItemClick(view, ((EPGView)EPGView.this).beginTouchAt.itemSection, ((EPGView)EPGView.this).beginTouchAt.itemIndex, EPGView.this.mAdapter.getItemId(((EPGView)EPGView.this).beginTouchAt.itemSection, ((EPGView)EPGView.this).beginTouchAt.itemIndex));
            }
        }
    }

    public static interface MultiChoiceModeListener
    extends ActionMode.Callback {
        public void onItemCheckedStateChanged(ActionMode var1, int var2, int var3, long var4, boolean var6);
    }

    public static interface OnTouchModeChangedListener {
        public void onTouchModeChanged(int var1);
    }

    class MultiChoiceModeWrapper
    implements MultiChoiceModeListener {
        private MultiChoiceModeListener mWrapped;

        MultiChoiceModeWrapper() {
        }

        public void setWrapped(MultiChoiceModeListener wrapped) {
            this.mWrapped = wrapped;
        }

        public boolean hasWrappedCallback() {
            return this.mWrapped != null;
        }

        public boolean onCreateActionMode(ActionMode mode, Menu menu) {
            if (this.mWrapped.onCreateActionMode(mode, menu)) {
                EPGView.this.setLongClickable(false);
                return true;
            }
            return false;
        }

        public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
            return this.mWrapped.onPrepareActionMode(mode, menu);
        }

        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mWrapped.onActionItemClicked(mode, item);
        }

        public void onDestroyActionMode(ActionMode mode) {
            this.mWrapped.onDestroyActionMode(mode);
            EPGView.this.mChoiceActionMode = null;
            EPGView.this.clearChoices();
            EPGView.this.updateOnScreenCheckedViews();
            EPGView.this.requestLayout();
            EPGView.this.setLongClickable(true);
        }

        @Override
        public void onItemCheckedStateChanged(ActionMode mode, int section, int position, long id, boolean checked) {
            this.mWrapped.onItemCheckedStateChanged(mode, section, position, id, checked);
            if (EPGView.this.getCheckedItemCount() == 0) {
                mode.finish();
            }
        }
    }

    private class CheckForLongPress
    implements Runnable {
        private CheckForLongPress() {
        }

        @Override
        public void run() {
            if (EPGView.this.beginTouchAt == null) {
                return;
            }
            EPGView.this.mCheckStates.clear();
            View child = ((EPGView)EPGView.this).beginTouchAt.view;
            if (child != null) {
                boolean handled = false;
                handled = EPGView.this.performLongPress();
                if (handled) {
                    EPGView.this.mTouchMode = -1;
                    if (EPGView.this.mOnTouchModeChangedListener != null) {
                        EPGView.this.mOnTouchModeChangedListener.onTouchModeChanged(EPGView.this.mTouchMode);
                    }
                    child.setPressed(false);
                } else {
                    EPGView.this.mTouchMode = 2;
                    if (EPGView.this.mOnTouchModeChangedListener != null) {
                        EPGView.this.mOnTouchModeChangedListener.onTouchModeChanged(EPGView.this.mTouchMode);
                    }
                }
            }
        }
    }

    final class CheckForTap
    implements Runnable {
        CheckForTap() {
        }

        @Override
        public void run() {
            if (EPGView.this.mTouchMode == 0) {
                EPGView.this.mTouchMode = 1;
                if (EPGView.this.mOnTouchModeChangedListener != null) {
                    EPGView.this.mOnTouchModeChangedListener.onTouchModeChanged(EPGView.this.mTouchMode);
                }
                if (EPGView.this.beginTouchAt != null && ((EPGView)EPGView.this).beginTouchAt.view != null) {
                    ((EPGView)EPGView.this).beginTouchAt.view.setPressed(true);
                }
                EPGView.this.refreshDrawableState();
                int longPressTimeout = ViewConfiguration.getLongPressTimeout();
                boolean longClickable = EPGView.this.isLongClickable();
                if (longClickable) {
                    if (EPGView.this.mPendingCheckForLongPress == null) {
                        EPGView.this.mPendingCheckForLongPress = new CheckForLongPress();
                    }
                    EPGView.this.postDelayed(EPGView.this.mPendingCheckForLongPress, longPressTimeout);
                } else {
                    EPGView.this.mTouchMode = 2;
                    if (EPGView.this.mOnTouchModeChangedListener != null) {
                        EPGView.this.mOnTouchModeChangedListener.onTouchModeChanged(EPGView.this.mTouchMode);
                    }
                }
            }
        }
    }
}

