/*
 * Decompiled with CFR 0.152.
 */
package com.sgerges.epgview.core;

import android.view.View;
import android.view.ViewGroup;
import com.sgerges.epgview.core.Section;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class EPGAdapter<C, P> {
    private List<Section<C, P>> sections;

    public EPGAdapter(LinkedHashMap<C, List<P>> channelToProgramsMap) {
        this.sections = new ArrayList<Section<C, P>>(channelToProgramsMap.size());
        for (Map.Entry<C, List<P>> channelEntry : channelToProgramsMap.entrySet()) {
            Section<C, P> section = new Section<C, P>();
            section.setHeaderData(channelEntry.getKey());
            section.setData(channelEntry.getValue());
            this.sections.add(section);
        }
    }

    View getItemView(int section, int position, View convertView, ViewGroup parent) {
        P program = this.sections.get(section).getDataAtIndex(position);
        return this.getViewForProgram(program, convertView, parent);
    }

    View getHeaderViewForSection(int section, View convertView, ViewGroup parent) {
        C channel = this.sections.get(section).getHeaderData();
        return this.getViewForChannel(channel, convertView, parent);
    }

    long getItemId(int channelIndex, int programIndex) {
        return channelIndex * 1000 + programIndex;
    }

    int getNumberOfChannels() {
        return this.sections.size();
    }

    Section getSection(int index) {
        if (index < this.sections.size() && index >= 0) {
            return this.sections.get(index);
        }
        return null;
    }

    View getOverlayViewForPrevPrograms(int color, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = new View(parent.getContext());
            convertView.setBackgroundColor(color);
        }
        return convertView;
    }

    protected P getProgramAt(int section, int position) {
        return this.sections.get(section).getDataAtIndex(position);
    }

    protected boolean shouldDisplaySectionHeaders() {
        return true;
    }

    protected boolean shouldDisplayTimeLine() {
        return true;
    }

    protected abstract View getViewForChannel(C var1, View var2, ViewGroup var3);

    protected abstract View getViewForProgram(P var1, View var2, ViewGroup var3);

    protected abstract View getViewForTimeCell(Long var1, View var2, ViewGroup var3);

    protected abstract View getViewForNowLineHead(View var1, ViewGroup var2);

    public abstract long getStartTimeForProgramAt(int var1, int var2);

    public abstract long getEndTimeForProgramAt(int var1, int var2);

    public abstract long getViewStartTime();

    public abstract long getViewEndTime();
}

