/*
 * Decompiled with CFR 0.152.
 */
package com.sgerges.epgview.core;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.View;
import android.view.ViewGroup;
import com.sgerges.epgview.core.FreeFlowEventListener;
import com.sgerges.epgview.core.FreeFlowItem;
import com.sgerges.epgview.core.FreeFlowLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public abstract class AbsLayoutContainer
extends ViewGroup {
    protected Map<Object, FreeFlowItem> frames = null;
    protected ArrayList<FreeFlowEventListener> listeners = new ArrayList();
    protected FreeFlowItem selectedFreeFlowItem;
    protected OnItemClickListener mOnItemClickListener;
    OnItemSelectedListener mOnItemSelectedListener;
    OnItemLongClickListener mOnItemLongClickListener;

    public AbsLayoutContainer(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public AbsLayoutContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public AbsLayoutContainer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    protected abstract void init(Context var1, AttributeSet var2, int var3);

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public final OnItemClickListener getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    public boolean performItemClick(View view, int sectionIndex, int positionInSection, long id) {
        if (this.mOnItemClickListener != null) {
            if (view != null) {
                view.sendAccessibilityEvent(1);
            }
            this.mOnItemClickListener.onItemClick(this, this.getFreeFlowItemForVisibleItemAt(sectionIndex, positionInSection));
            return true;
        }
        return false;
    }

    protected void setOnItemSelectedListener(OnItemSelectedListener listener) {
        this.mOnItemSelectedListener = listener;
    }

    public void addFreeFlowEventListener(FreeFlowEventListener listener) {
        if (this.listeners.indexOf(listener) != -1) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeFreeFlowEventListener(FreeFlowEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void dispatchAnimationsStarting() {
        for (FreeFlowEventListener listener : this.listeners) {
            listener.layoutChangeAnimationsStarting();
        }
    }

    protected void dispatchLayoutChangeAnimationsComplete() {
        for (FreeFlowEventListener listener : this.listeners) {
            listener.layoutChangeAnimationsComplete();
        }
    }

    protected void dispatchLayoutComplete(boolean areTransitionAnimationsPlaying) {
        for (FreeFlowEventListener listener : this.listeners) {
            listener.layoutComplete(areTransitionAnimationsPlaying);
        }
    }

    protected void dispatchLayoutComputed() {
        for (FreeFlowEventListener listener : this.listeners) {
            listener.layoutComputed();
        }
    }

    protected void dispatchDataChanged() {
        for (FreeFlowEventListener listener : this.listeners) {
            listener.dataChanged();
        }
    }

    protected void dispatchLayoutChanging(FreeFlowLayout oldLayout, FreeFlowLayout newLayout) {
        for (FreeFlowEventListener listener : this.listeners) {
            listener.onLayoutChanging(oldLayout, newLayout);
        }
    }

    public void setOnItemLongClickListener(OnItemLongClickListener listener) {
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.mOnItemLongClickListener = listener;
    }

    public final OnItemLongClickListener getOnItemLongClickListener() {
        return this.mOnItemLongClickListener;
    }

    public FreeFlowItem getFreeFlowItemForVisibleItemAt(int section, int position) {
        Iterator<Map.Entry<Object, FreeFlowItem>> it = this.frames.entrySet().iterator();
        FreeFlowItem proxy = null;
        while (it.hasNext()) {
            Map.Entry<Object, FreeFlowItem> pairs = it.next();
            proxy = pairs.getValue();
            if (proxy.itemSection != section || proxy.itemIndex != position) continue;
            return proxy;
        }
        return null;
    }

    public static class AbsLayoutContainerContextMenuInfo
    implements ContextMenu.ContextMenuInfo {
        public View targetView;
        public int sectionIndex;
        public int positionInSection;
        public long id;

        public AbsLayoutContainerContextMenuInfo(View targetView, int sectionIndex, int positionInSection, long id) {
            this.targetView = targetView;
            this.sectionIndex = sectionIndex;
            this.positionInSection = positionInSection;
            this.id = id;
        }
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClick(AbsLayoutContainer var1, View var2, int var3, int var4, long var5);
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(AbsLayoutContainer var1, FreeFlowItem var2);

        public void onNothingSelected(AbsLayoutContainer var1);
    }

    public static interface OnItemClickListener {
        public void onItemClick(AbsLayoutContainer var1, FreeFlowItem var2);
    }
}

