/*
 * Decompiled with CFR 0.152.
 */
package com.sgerges.epgview.core;

import android.graphics.Rect;
import com.sgerges.epgview.core.EPGAdapter;
import com.sgerges.epgview.core.FreeFlowItem;
import com.sgerges.epgview.core.FreeFlowLayout;
import com.sgerges.epgview.core.FreeFlowLayoutBase;
import com.sgerges.epgview.core.Section;
import com.sgerges.epgview.utils.ViewUtils;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class EPGLayout
extends FreeFlowLayoutBase
implements FreeFlowLayout {
    public static final int TYPE_CHANNEL = 0;
    public static final int TYPE_CELL = 1;
    public static final int TYPE_NOW_LINE = 2;
    public static final int TYPE_TIME_BAR = 3;
    public static final int TYPE_TIME_BAR_NOW_HEAD = 4;
    public static final int TYPE_PREV_PROGRAMS_OVERLAY = 5;
    private static final String TAG = "EPGLayout";
    private Map<Object, FreeFlowItem> proxies = new HashMap<Object, FreeFlowItem>();
    private EPGAdapter itemsAdapter;
    private EPGLayoutParams layoutParams = new EPGLayoutParams();
    private int maxEnd;
    private int gridTop = 0;

    @Override
    public void setAdapter(EPGAdapter adapter) {
        this.itemsAdapter = adapter;
    }

    @Override
    public void setLayoutParams(FreeFlowLayout.FreeFlowLayoutParams params) {
        if (!(params instanceof EPGLayoutParams)) {
            throw new IllegalArgumentException("EPGLayout can only use EPGLayoutParams");
        }
        this.layoutParams = (EPGLayoutParams)params;
    }

    public EPGLayoutParams getLayoutParams() {
        return this.layoutParams;
    }

    @Override
    public void prepareLayout() {
        this.proxies.clear();
        if (this.itemsAdapter == null) {
            return;
        }
        this.gridTop = this.itemsAdapter.shouldDisplayTimeLine() ? this.layoutParams.timeLineHeight : 0;
        int programsStart = this.itemsAdapter.shouldDisplaySectionHeaders() ? this.layoutParams.channelCellWidth : 0;
        long viewStartTime = this.itemsAdapter.getViewStartTime();
        if (viewStartTime < System.currentTimeMillis() && System.currentTimeMillis() < this.itemsAdapter.getViewEndTime()) {
            FreeFlowItem nowLineItem = new FreeFlowItem();
            nowLineItem.frame = this.prepareNowLineFrame();
            nowLineItem.type = 2;
            nowLineItem.zIndex = 1;
            nowLineItem.data = "NOW_LINE";
            this.proxies.put("NOW_LINE", nowLineItem);
            FreeFlowItem nowHeadItem = new FreeFlowItem();
            nowHeadItem.frame = this.prepareNowHeadFrame();
            nowHeadItem.type = 4;
            nowHeadItem.zIndex = 4;
            nowHeadItem.data = "NOW_HEAD";
            this.proxies.put("NOW_HEAD", nowHeadItem);
            if (this.layoutParams.showPrevProgramsOverlay) {
                FreeFlowItem prevOverlayItem = new FreeFlowItem();
                prevOverlayItem.frame = this.preparePrevOverlayFrame();
                prevOverlayItem.type = 5;
                prevOverlayItem.zIndex = 1;
                prevOverlayItem.data = "PREV_OVERLAY";
                this.proxies.put("PREV_OVERLAY", prevOverlayItem);
            }
        }
        Calendar currentTime = Calendar.getInstance();
        currentTime.setTimeInMillis(viewStartTime);
        currentTime.add(11, -1);
        currentTime.set(12, 0);
        currentTime.set(13, 0);
        currentTime.set(14, 0);
        while (currentTime.getTimeInMillis() - 1800000L < this.itemsAdapter.getViewEndTime()) {
            FreeFlowItem timeCell = new FreeFlowItem();
            timeCell.type = 3;
            timeCell.zIndex = 3;
            int timeDiffMin = (int)((currentTime.getTimeInMillis() - viewStartTime) / 60000L) - 15;
            Rect timeCellFrame = new Rect();
            timeCellFrame.left = programsStart + timeDiffMin * this.layoutParams.minuteWidth;
            timeCellFrame.right = timeCellFrame.left + 30 * this.layoutParams.minuteWidth;
            timeCellFrame.top = 0;
            timeCellFrame.bottom = timeCellFrame.top + this.layoutParams.timeLineHeight;
            timeCell.frame = timeCellFrame;
            timeCell.clickable = true;
            timeCell.data = currentTime.getTimeInMillis();
            this.proxies.put(currentTime.getTimeInMillis(), timeCell);
            currentTime.add(12, 30);
        }
        for (int sectionIndex = 0; sectionIndex < this.itemsAdapter.getNumberOfChannels(); ++sectionIndex) {
            Section section = this.itemsAdapter.getSection(sectionIndex);
            if (this.itemsAdapter.shouldDisplaySectionHeaders()) {
                FreeFlowItem header = new FreeFlowItem();
                header.itemSection = sectionIndex;
                header.itemIndex = -1;
                header.zIndex = 2;
                Rect hframe = new Rect();
                hframe.left = 0;
                hframe.right = this.layoutParams.channelCellWidth;
                hframe.top = this.gridTop + sectionIndex * this.layoutParams.channelRowHeight;
                hframe.bottom = hframe.top + this.layoutParams.channelRowHeight;
                header.frame = hframe;
                header.data = section.getHeaderData();
                header.type = 0;
                header.clickable = true;
                this.proxies.put(header.data, header);
            }
            for (int programIndex = 0; programIndex < section.getDataCount(); ++programIndex) {
                FreeFlowItem descriptor = new FreeFlowItem();
                descriptor.itemSection = sectionIndex;
                descriptor.itemIndex = programIndex;
                Rect frame = new Rect();
                frame.left = programsStart + this.detectProgramLeft(sectionIndex, programIndex);
                frame.right = programsStart + this.detectProgramRight(sectionIndex, programIndex);
                frame.top = this.gridTop + sectionIndex * this.layoutParams.channelRowHeight;
                frame.bottom = frame.top + this.layoutParams.channelRowHeight;
                int programEnd = frame.right;
                descriptor.frame = frame;
                descriptor.data = section.getDataAtIndex(programIndex);
                descriptor.zIndex = 0;
                descriptor.clickable = true;
                this.proxies.put(descriptor.data, descriptor);
                descriptor.type = 1;
                if (this.maxEnd >= programEnd) continue;
                this.maxEnd = programEnd;
            }
        }
    }

    public Rect preparePrevOverlayFrame() {
        int programsStart = this.itemsAdapter.shouldDisplaySectionHeaders() ? this.layoutParams.channelCellWidth : 0;
        Rect nowLineFrame = new Rect();
        nowLineFrame.top = 0;
        nowLineFrame.left = 0;
        nowLineFrame.right = programsStart + this.detectNowLeft();
        nowLineFrame.bottom = this.gridTop + this.itemsAdapter.getNumberOfChannels() * this.layoutParams.channelRowHeight;
        return nowLineFrame;
    }

    public Rect prepareNowLineFrame() {
        int programsStart = this.itemsAdapter.shouldDisplaySectionHeaders() ? this.layoutParams.channelCellWidth : 0;
        Rect nowLineFrame = new Rect();
        nowLineFrame.top = 0;
        nowLineFrame.left = programsStart + this.detectNowLeft();
        nowLineFrame.right = nowLineFrame.left + this.layoutParams.nowLineWidth;
        nowLineFrame.bottom = this.gridTop + this.itemsAdapter.getNumberOfChannels() * this.layoutParams.channelRowHeight;
        return nowLineFrame;
    }

    public Rect prepareNowHeadFrame() {
        int programsStart = this.itemsAdapter.shouldDisplaySectionHeaders() ? this.layoutParams.channelCellWidth : 0;
        Rect nowLineFrame = new Rect();
        nowLineFrame.top = 0;
        nowLineFrame.left = programsStart + this.detectNowLeft();
        nowLineFrame.right = nowLineFrame.left + this.layoutParams.timeLineHeight;
        nowLineFrame.bottom = nowLineFrame.top + this.layoutParams.timeLineHeight;
        return nowLineFrame;
    }

    private int detectNowLeft() {
        long viewStartTime = this.itemsAdapter.getViewStartTime();
        return (int)((System.currentTimeMillis() - viewStartTime) / 60000L * (long)this.layoutParams.minuteWidth);
    }

    private int detectProgramLeft(int section, int index) {
        long viewStartTime;
        long programStartTime = this.itemsAdapter.getStartTimeForProgramAt(section, index);
        if (programStartTime < (viewStartTime = this.itemsAdapter.getViewStartTime())) {
            return 0;
        }
        return (int)((programStartTime - viewStartTime) / 60000L * (long)this.layoutParams.minuteWidth);
    }

    private int detectProgramRight(int section, int index) {
        long programEnd = this.itemsAdapter.getEndTimeForProgramAt(section, index);
        long viewStartTime = this.itemsAdapter.getViewStartTime();
        long viewEndTime = this.itemsAdapter.getViewEndTime();
        if (programEnd > viewEndTime && this.layoutParams.cutProgramsToEdges) {
            programEnd = viewEndTime;
        }
        return (int)((programEnd - viewStartTime) / 60000L * (long)this.layoutParams.minuteWidth);
    }

    @Override
    public Map<Object, FreeFlowItem> getItemProxies(int viewPortLeft, int viewPortTop) {
        HashMap<Object, FreeFlowItem> desc = new HashMap<Object, FreeFlowItem>();
        for (FreeFlowItem fd : this.proxies.values()) {
            if (fd.type == 0) {
                if (fd.frame.bottom <= viewPortTop || fd.frame.top >= viewPortTop + this.height) continue;
                desc.put(fd.data, fd);
                continue;
            }
            if (fd.type == 4) {
                if (fd.frame.right <= viewPortLeft || fd.frame.left >= viewPortLeft + this.width) continue;
                desc.put(fd.data, fd);
                continue;
            }
            if (fd.type == 3) {
                if (fd.frame.right <= viewPortLeft || fd.frame.left >= viewPortLeft + this.width) continue;
                desc.put(fd.data, fd);
                continue;
            }
            if (fd.frame.bottom <= viewPortTop || fd.frame.top >= viewPortTop + this.height || fd.frame.right <= viewPortLeft || fd.frame.left >= viewPortLeft + this.width) continue;
            desc.put(fd.data, fd);
        }
        return desc;
    }

    @Override
    public FreeFlowItem getItemAt(float x, float y) {
        return ViewUtils.getItemAt(this.proxies, (int)x, (int)y);
    }

    @Override
    public boolean horizontalScrollEnabled() {
        return true;
    }

    @Override
    public boolean verticalScrollEnabled() {
        return true;
    }

    @Override
    public int getContentWidth() {
        return this.maxEnd;
    }

    @Override
    public int getContentHeight() {
        if (this.itemsAdapter == null || this.itemsAdapter.getNumberOfChannels() <= 0) {
            return 0;
        }
        int sectionIndex = this.itemsAdapter.getNumberOfChannels() - 1;
        Section s = this.itemsAdapter.getSection(sectionIndex);
        if (s.getDataCount() == 0) {
            return 0;
        }
        Object lastFrameData = s.getDataAtIndex(s.getDataCount() - 1);
        FreeFlowItem fd = this.proxies.get(lastFrameData);
        if (fd == null) {
            return 0;
        }
        return fd.frame.top + fd.frame.height();
    }

    @Override
    public FreeFlowItem getFreeFlowItemForItem(Object data) {
        return this.proxies.get(data);
    }

    public FreeFlowItem getNowLineFreeFlowItem() {
        return this.proxies.get("NOW_LINE");
    }

    public void forceUpdateFrame(Object data, Rect frame) {
        this.proxies.get((Object)data).frame = frame;
    }

    public static class EPGLayoutParams
    extends FreeFlowLayout.FreeFlowLayoutParams {
        public boolean showPrevProgramsOverlay = true;
        public int prevProgramsOverlayColor = -1946157056;
        public int channelCellWidth = 250;
        public int channelRowHeight = 250;
        public int minuteWidth = 20;
        public int nowLineWidth = 1;
        public int nowLineColor = -65536;
        public int timeLineHeight = 150;
        public boolean cutProgramsToEdges = true;
    }
}

