/*
 * Decompiled with CFR 0.152.
 */
package com.sgerges.epgview.animations;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Rect;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.sgerges.epgview.animations.FreeFlowLayoutAnimator;
import com.sgerges.epgview.core.EPGView;
import com.sgerges.epgview.core.FreeFlowItem;
import com.sgerges.epgview.core.LayoutChangeSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DefaultLayoutAnimator
implements FreeFlowLayoutAnimator {
    protected LayoutChangeSet changeSet;
    public static final String TAG = "DefaultLayoutAnimator";
    public int newCellsAdditionAnimationDurationPerCell = 200;
    public int newCellsAdditionAnimationStartDelay = 0;
    public int oldCellsRemovalAnimationDuration = 200;
    public int oldCellsRemovalAnimationStartDelay = 0;
    public int cellPositionTransitionAnimationDuration = 250;
    public boolean animateAllSetsSequentially = false;
    public boolean animateIndividualCellsSequentially = false;
    protected EPGView callback;
    protected AnimatorSet disappearingSet = null;
    protected AnimatorSet appearingSet = null;
    protected AnimatorSet movingSet = null;
    protected boolean mIsRunning = false;

    @Override
    public void cancel() {
        if (this.disappearingSet != null) {
            this.disappearingSet.cancel();
        }
        if (this.appearingSet != null) {
            this.appearingSet.cancel();
        }
        if (this.movingSet != null) {
            this.movingSet.cancel();
        }
        for (FreeFlowItem item : this.changeSet.getAdded()) {
            item.view.setAlpha(1.0f);
        }
        for (FreeFlowItem item : this.changeSet.getRemoved()) {
            item.view.setAlpha(1.0f);
        }
        this.mIsRunning = false;
    }

    @Override
    public void animateChanges(LayoutChangeSet changeSet, final EPGView callback) {
        AnimatorSet all;
        List<FreeFlowItem> added;
        this.changeSet = changeSet;
        this.callback = callback;
        this.cancel();
        this.mIsRunning = true;
        this.disappearingSet = null;
        this.appearingSet = null;
        this.movingSet = null;
        Comparator<FreeFlowItem> cmp = new Comparator<FreeFlowItem>(){

            @Override
            public int compare(FreeFlowItem lhs, FreeFlowItem rhs) {
                return lhs.itemSection * 1000 + lhs.itemIndex - (rhs.itemSection * 1000 + rhs.itemIndex);
            }
        };
        List<FreeFlowItem> removed = changeSet.getRemoved();
        if (removed.size() > 0) {
            Collections.sort(removed, cmp);
            this.disappearingSet = this.getItemsRemovedAnimation(changeSet.getRemoved());
        }
        if ((added = changeSet.getAdded()).size() > 0) {
            Collections.sort(added, cmp);
            this.appearingSet = this.getItemsAddedAnimation(added);
        }
        if (changeSet.getMoved().size() > 0) {
            this.movingSet = this.getItemsMovedAnimation(changeSet.getMoved());
        }
        if ((all = this.getAnimationSequence()) == null) {
            this.mIsRunning = false;
            callback.onLayoutChangeAnimationsCompleted(this);
        } else {
            all.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    DefaultLayoutAnimator.this.mIsRunning = false;
                    callback.onLayoutChangeAnimationsCompleted(DefaultLayoutAnimator.this);
                }

                public void onAnimationCancel(Animator animation) {
                }
            });
            all.start();
        }
    }

    protected AnimatorSet getItemsRemovedAnimation(List<FreeFlowItem> removed) {
        AnimatorSet disappearingSet = new AnimatorSet();
        ArrayList<ObjectAnimator> fades = new ArrayList<ObjectAnimator>();
        for (FreeFlowItem proxy : removed) {
            fades.add(ObjectAnimator.ofFloat((Object)proxy.view, (String)"alpha", (float[])new float[]{0.0f}));
        }
        disappearingSet.setDuration((long)this.oldCellsRemovalAnimationDuration);
        disappearingSet.setStartDelay((long)this.oldCellsRemovalAnimationStartDelay);
        if (this.animateIndividualCellsSequentially) {
            disappearingSet.playSequentially(fades);
        } else {
            disappearingSet.playTogether(fades);
        }
        return disappearingSet;
    }

    protected AnimatorSet getItemsAddedAnimation(List<FreeFlowItem> added) {
        AnimatorSet appearingSet = new AnimatorSet();
        ArrayList<ObjectAnimator> fadeIns = new ArrayList<ObjectAnimator>();
        for (FreeFlowItem proxy : added) {
            proxy.view.setAlpha(0.0f);
            fadeIns.add(ObjectAnimator.ofFloat((Object)proxy.view, (String)"alpha", (float[])new float[]{1.0f}));
        }
        if (this.animateIndividualCellsSequentially) {
            appearingSet.playSequentially(fadeIns);
        } else {
            appearingSet.playTogether(fadeIns);
        }
        appearingSet.setStartDelay((long)this.newCellsAdditionAnimationStartDelay);
        appearingSet.setDuration((long)this.newCellsAdditionAnimationDurationPerCell);
        return appearingSet;
    }

    protected AnimatorSet getAnimationSequence() {
        if (this.disappearingSet == null && this.appearingSet == null && this.movingSet == null) {
            return null;
        }
        AnimatorSet allAnim = new AnimatorSet();
        ArrayList<AnimatorSet> all = new ArrayList<AnimatorSet>();
        if (this.disappearingSet != null) {
            all.add(this.disappearingSet);
        }
        if (this.appearingSet != null) {
            all.add(this.appearingSet);
        }
        if (this.movingSet != null) {
            all.add(this.movingSet);
        }
        if (this.animateAllSetsSequentially) {
            allAnim.playSequentially(all);
        } else {
            allAnim.playTogether(all);
        }
        return allAnim;
    }

    protected AnimatorSet getItemsMovedAnimation(List<Pair<FreeFlowItem, Rect>> moved) {
        AnimatorSet anim = new AnimatorSet();
        ArrayList<ValueAnimator> moves = new ArrayList<ValueAnimator>();
        for (Pair<FreeFlowItem, Rect> item : moved) {
            FreeFlowItem proxy = FreeFlowItem.clone((FreeFlowItem)item.first);
            View v = proxy.view;
            proxy.frame.left -= this.callback.getViewportLeft();
            proxy.frame.top -= this.callback.getViewportTop();
            proxy.frame.right -= this.callback.getViewportLeft();
            proxy.frame.bottom -= this.callback.getViewportTop();
            moves.add(this.transitionToFrame((Rect)item.second, proxy, v));
        }
        anim.playTogether(moves);
        return anim;
    }

    public ValueAnimator transitionToFrame(final Rect of, final FreeFlowItem nf, final View v) {
        ValueAnimator anim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        anim.setDuration((long)this.cellPositionTransitionAnimationDuration);
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                try {
                    int itemWidth = of.width() + (int)((float)(nf.frame.width() - of.width()) * animation.getAnimatedFraction());
                    int itemHeight = of.height() + (int)((float)(nf.frame.height() - of.height()) * animation.getAnimatedFraction());
                    int widthSpec = View.MeasureSpec.makeMeasureSpec((int)itemWidth, (int)0x40000000);
                    int heightSpec = View.MeasureSpec.makeMeasureSpec((int)itemHeight, (int)0x40000000);
                    v.measure(widthSpec, heightSpec);
                    Rect frame = new Rect();
                    Rect nff = nf.frame;
                    frame.left = (int)((float)of.left + (float)(nff.left - of.left) * animation.getAnimatedFraction());
                    frame.top = (int)((float)of.top + (float)(nff.top - of.top) * animation.getAnimatedFraction());
                    frame.right = frame.left + (int)((float)of.width() + (float)(nff.width() - of.width()) * animation.getAnimatedFraction());
                    frame.bottom = frame.top + (int)((float)of.height() + (float)(nff.height() - of.height()) * animation.getAnimatedFraction());
                    v.layout(frame.left, frame.top, frame.right, frame.bottom);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                    animation.cancel();
                }
            }
        });
        anim.setInterpolator((TimeInterpolator)new DecelerateInterpolator(2.0f));
        return anim;
    }

    public void setDuration(int duration) {
        this.cellPositionTransitionAnimationDuration = duration;
    }

    @Override
    public LayoutChangeSet getChangeSet() {
        return this.changeSet;
    }

    @Override
    public boolean isRunning() {
        return this.mIsRunning;
    }

    @Override
    public void onContainerTouchDown(MotionEvent event) {
        this.cancel();
    }
}

