/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.serenegiant.encoder.IVideoEncoder;
import com.serenegiant.encoder.MediaEncoder;
import com.serenegiant.encoder.MediaVideoEncoder;
import com.serenegiant.glutils.EGLBase;
import com.serenegiant.glutils.GLDrawer2D;
import com.serenegiant.glutils.es1.GLHelper;
import com.serenegiant.widget.CameraViewInterface;

public class UVCCameraTextureView
extends TextureView
implements TextureView.SurfaceTextureListener,
CameraViewInterface {
    private static final boolean DEBUG = true;
    private static final String TAG = "UVCCameraTextureView";
    private double mRequestedAspect = -1.0;
    private boolean mHasSurface;
    private RenderHandler mRenderHandler;
    private final Object mCaptureSync = new Object();
    private Bitmap mTempBitmap;
    private boolean mReqesutCaptureStillImage;
    private CameraViewInterface.Callback mCallback;
    private Surface mPreviewSurface;

    public UVCCameraTextureView(Context context) {
        this(context, null, 0);
    }

    public UVCCameraTextureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public UVCCameraTextureView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setSurfaceTextureListener(this);
    }

    @Override
    public void onResume() {
        Log.v((String)TAG, (String)"onResume:");
        if (this.mHasSurface) {
            this.mRenderHandler = RenderHandler.createHandler(super.getSurfaceTexture(), this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void onPause() {
        Log.v((String)TAG, (String)"onPause:");
        if (this.mRenderHandler != null) {
            this.mRenderHandler.release();
            this.mRenderHandler = null;
        }
        if (this.mTempBitmap != null) {
            this.mTempBitmap.recycle();
            this.mTempBitmap = null;
        }
    }

    @Override
    public void setAspectRatio(double aspectRatio) {
        if (aspectRatio < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.mRequestedAspect != aspectRatio) {
            this.mRequestedAspect = aspectRatio;
            this.requestLayout();
        }
    }

    @Override
    public void setAspectRatio(int width, int height) {
        this.setAspectRatio((double)width / (double)height);
    }

    @Override
    public double getAspectRatio() {
        return this.mRequestedAspect;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mRequestedAspect > 0.0) {
            int vertPadding;
            int initialWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int initialHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int horizPadding = this.getPaddingLeft() + this.getPaddingRight();
            double viewAspectRatio = (double)(initialWidth -= horizPadding) / (double)(initialHeight -= (vertPadding = this.getPaddingTop() + this.getPaddingBottom()));
            double aspectDiff = this.mRequestedAspect / viewAspectRatio - 1.0;
            if (Math.abs(aspectDiff) > 0.01) {
                if (aspectDiff > 0.0) {
                    initialHeight = (int)((double)initialWidth / this.mRequestedAspect);
                } else {
                    initialWidth = (int)((double)initialHeight * this.mRequestedAspect);
                }
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialWidth += horizPadding), (int)0x40000000);
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialHeight += vertPadding), (int)0x40000000);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        Log.v((String)TAG, (String)("onSurfaceTextureAvailable:" + surface));
        if (this.mRenderHandler == null) {
            this.mRenderHandler = RenderHandler.createHandler(surface, width, height);
        } else {
            this.mRenderHandler.resize(width, height);
        }
        this.mHasSurface = true;
        if (this.mCallback != null) {
            this.mCallback.onSurfaceCreated(this, this.getSurface());
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        Log.v((String)TAG, (String)("onSurfaceTextureSizeChanged:" + surface));
        if (this.mRenderHandler != null) {
            this.mRenderHandler.resize(width, height);
        }
        if (this.mCallback != null) {
            this.mCallback.onSurfaceChanged(this, this.getSurface(), width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        Log.v((String)TAG, (String)("onSurfaceTextureDestroyed:" + surface));
        if (this.mRenderHandler != null) {
            this.mRenderHandler.release();
            this.mRenderHandler = null;
        }
        this.mHasSurface = false;
        if (this.mCallback != null) {
            this.mCallback.onSurfaceDestroy(this, this.getSurface());
        }
        if (this.mPreviewSurface != null) {
            this.mPreviewSurface.release();
            this.mPreviewSurface = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        Object object = this.mCaptureSync;
        synchronized (object) {
            if (this.mReqesutCaptureStillImage) {
                this.mReqesutCaptureStillImage = false;
                if (this.mTempBitmap == null) {
                    this.mTempBitmap = this.getBitmap();
                } else {
                    this.getBitmap(this.mTempBitmap);
                }
                this.mCaptureSync.notifyAll();
            }
        }
    }

    @Override
    public boolean hasSurface() {
        return this.mHasSurface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap captureStillImage() {
        Object object = this.mCaptureSync;
        synchronized (object) {
            this.mReqesutCaptureStillImage = true;
            try {
                this.mCaptureSync.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.mTempBitmap;
        }
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.mRenderHandler != null ? this.mRenderHandler.getPreviewTexture() : null;
    }

    @Override
    public Surface getSurface() {
        SurfaceTexture st;
        Log.v((String)TAG, (String)("getSurface:hasSurface=" + this.mHasSurface));
        if (this.mPreviewSurface == null && (st = this.getSurfaceTexture()) != null) {
            this.mPreviewSurface = new Surface(st);
        }
        return this.mPreviewSurface;
    }

    @Override
    public void setVideoEncoder(IVideoEncoder encoder) {
        if (this.mRenderHandler != null) {
            this.mRenderHandler.setVideoEncoder(encoder);
        }
    }

    @Override
    public void setCallback(CameraViewInterface.Callback callback) {
        this.mCallback = callback;
    }

    private static final class RenderHandler
    extends Handler
    implements SurfaceTexture.OnFrameAvailableListener {
        private static final int MSG_REQUEST_RENDER = 1;
        private static final int MSG_SET_ENCODER = 2;
        private static final int MSG_CREATE_SURFACE = 3;
        private static final int MSG_RESIZE = 4;
        private static final int MSG_TERMINATE = 9;
        private RenderThread mThread;
        private boolean mIsActive = true;

        public static final RenderHandler createHandler(SurfaceTexture surface, int width, int height) {
            RenderThread thread = new RenderThread(surface, width, height);
            thread.start();
            return thread.getHandler();
        }

        private RenderHandler(RenderThread thread) {
            this.mThread = thread;
        }

        public final void setVideoEncoder(IVideoEncoder encoder) {
            Log.v((String)UVCCameraTextureView.TAG, (String)"setVideoEncoder:");
            if (this.mIsActive) {
                this.sendMessage(this.obtainMessage(2, encoder));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final SurfaceTexture getPreviewTexture() {
            Log.v((String)UVCCameraTextureView.TAG, (String)"getPreviewTexture:");
            if (this.mIsActive) {
                Object object = this.mThread.mSync;
                synchronized (object) {
                    this.sendEmptyMessage(3);
                    try {
                        this.mThread.mSync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return this.mThread.mPreviewSurface;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resize(int width, int height) {
            Log.v((String)UVCCameraTextureView.TAG, (String)"resize:");
            if (this.mIsActive) {
                Object object = this.mThread.mSync;
                synchronized (object) {
                    this.sendMessage(this.obtainMessage(4, width, height));
                    try {
                        this.mThread.mSync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        public final void release() {
            Log.v((String)UVCCameraTextureView.TAG, (String)"release:");
            if (this.mIsActive) {
                this.mIsActive = false;
                this.removeMessages(1);
                this.removeMessages(2);
                this.sendEmptyMessage(9);
            }
        }

        public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
            if (this.mIsActive) {
                this.sendEmptyMessage(1);
            }
        }

        public final void handleMessage(Message msg) {
            if (this.mThread == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    this.mThread.onDrawFrame();
                    break;
                }
                case 2: {
                    this.mThread.setEncoder((MediaEncoder)msg.obj);
                    break;
                }
                case 3: {
                    this.mThread.updatePreviewSurface();
                    break;
                }
                case 4: {
                    this.mThread.resize(msg.arg1, msg.arg2);
                    break;
                }
                case 9: {
                    Looper.myLooper().quit();
                    this.mThread = null;
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }

        private static final class RenderThread
        extends Thread {
            private final Object mSync = new Object();
            private final SurfaceTexture mSurface;
            private RenderHandler mHandler;
            private EGLBase mEgl;
            private EGLBase.IEglSurface mEglSurface;
            private GLDrawer2D mDrawer;
            private int mTexId = -1;
            private SurfaceTexture mPreviewSurface;
            private final float[] mStMatrix = new float[16];
            private MediaEncoder mEncoder;
            private int mViewWidth;
            private int mViewHeight;

            public RenderThread(SurfaceTexture surface, int width, int height) {
                this.mSurface = surface;
                this.mViewWidth = width;
                this.mViewHeight = height;
                this.setName("RenderThread");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final RenderHandler getHandler() {
                Log.v((String)UVCCameraTextureView.TAG, (String)"RenderThread#getHandler:");
                Object object = this.mSync;
                synchronized (object) {
                    if (this.mHandler == null) {
                        try {
                            this.mSync.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                return this.mHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resize(int width, int height) {
                if (width > 0 && width != this.mViewWidth || height > 0 && height != this.mViewHeight) {
                    this.mViewWidth = width;
                    this.mViewHeight = height;
                    this.updatePreviewSurface();
                } else {
                    Object object = this.mSync;
                    synchronized (object) {
                        this.mSync.notifyAll();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void updatePreviewSurface() {
                Log.i((String)UVCCameraTextureView.TAG, (String)"RenderThread#updatePreviewSurface:");
                Object object = this.mSync;
                synchronized (object) {
                    if (this.mPreviewSurface != null) {
                        Log.d((String)UVCCameraTextureView.TAG, (String)"updatePreviewSurface:release mPreviewSurface");
                        this.mPreviewSurface.setOnFrameAvailableListener(null);
                        this.mPreviewSurface.release();
                        this.mPreviewSurface = null;
                    }
                    this.mEglSurface.makeCurrent();
                    if (this.mTexId >= 0) {
                        this.mDrawer.deleteTex(this.mTexId);
                    }
                    this.mTexId = this.mDrawer.initTex();
                    Log.v((String)UVCCameraTextureView.TAG, (String)("updatePreviewSurface:tex_id=" + this.mTexId));
                    this.mPreviewSurface = new SurfaceTexture(this.mTexId);
                    this.mPreviewSurface.setDefaultBufferSize(this.mViewWidth, this.mViewHeight);
                    this.mPreviewSurface.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this.mHandler);
                    this.mSync.notifyAll();
                }
            }

            public final void setEncoder(MediaEncoder encoder) {
                Log.v((String)UVCCameraTextureView.TAG, (String)("RenderThread#setEncoder:encoder=" + encoder));
                if (encoder != null && encoder instanceof MediaVideoEncoder) {
                    ((MediaVideoEncoder)encoder).setEglContext(this.mEglSurface.getContext(), this.mTexId);
                }
                this.mEncoder = encoder;
            }

            public final void onDrawFrame() {
                this.mEglSurface.makeCurrent();
                this.mPreviewSurface.updateTexImage();
                this.mPreviewSurface.getTransformMatrix(this.mStMatrix);
                if (this.mEncoder != null) {
                    if (this.mEncoder instanceof MediaVideoEncoder) {
                        ((MediaVideoEncoder)this.mEncoder).frameAvailableSoon(this.mStMatrix);
                    } else {
                        this.mEncoder.frameAvailableSoon();
                    }
                }
                this.mDrawer.draw(this.mTexId, this.mStMatrix, 0);
                this.mEglSurface.swap();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                Log.d((String)UVCCameraTextureView.TAG, (String)(this.getName() + " started"));
                this.init();
                Looper.prepare();
                Object object = this.mSync;
                synchronized (object) {
                    this.mHandler = new RenderHandler(this);
                    this.mSync.notify();
                }
                Looper.loop();
                Log.d((String)UVCCameraTextureView.TAG, (String)(this.getName() + " finishing"));
                this.release();
                object = this.mSync;
                synchronized (object) {
                    this.mHandler = null;
                    this.mSync.notify();
                }
            }

            private final void init() {
                Log.v((String)UVCCameraTextureView.TAG, (String)"RenderThread#init:");
                this.mEgl = EGLBase.createFrom(null, (boolean)false, (boolean)false);
                this.mEglSurface = this.mEgl.createFromSurface((Object)this.mSurface);
                this.mEglSurface.makeCurrent();
                this.mDrawer = new GLDrawer2D(true);
            }

            private final void release() {
                Log.v((String)UVCCameraTextureView.TAG, (String)"RenderThread#release:");
                if (this.mDrawer != null) {
                    this.mDrawer.release();
                    this.mDrawer = null;
                }
                if (this.mPreviewSurface != null) {
                    this.mPreviewSurface.release();
                    this.mPreviewSurface = null;
                }
                if (this.mTexId >= 0) {
                    GLHelper.deleteTex((int)this.mTexId);
                    this.mTexId = -1;
                }
                if (this.mEglSurface != null) {
                    this.mEglSurface.release();
                    this.mEglSurface = null;
                }
                if (this.mEgl != null) {
                    this.mEgl.release();
                    this.mEgl = null;
                }
            }
        }
    }
}

