/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.encoder;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import com.serenegiant.encoder.MediaMuxerWrapper;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

public abstract class MediaEncoder
implements Runnable {
    private static final boolean DEBUG = true;
    private static final String TAG = "MediaEncoder";
    protected static final int TIMEOUT_USEC = 10000;
    protected static final int MSG_FRAME_AVAILABLE = 1;
    protected static final int MSG_STOP_RECORDING = 9;
    protected final Object mSync = new Object();
    protected volatile boolean mIsCapturing;
    private int mRequestDrain;
    protected volatile boolean mRequestStop;
    protected boolean mIsEOS;
    protected boolean mMuxerStarted;
    protected int mTrackIndex;
    protected MediaCodec mMediaCodec;
    protected final WeakReference<MediaMuxerWrapper> mWeakMuxer;
    private MediaCodec.BufferInfo mBufferInfo;
    protected final MediaEncoderListener mListener;
    private long prevOutputPTSUs = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaEncoder(MediaMuxerWrapper muxer, MediaEncoderListener listener) {
        if (listener == null) {
            throw new NullPointerException("MediaEncoderListener is null");
        }
        if (muxer == null) {
            throw new NullPointerException("MediaMuxerWrapper is null");
        }
        this.mWeakMuxer = new WeakReference<MediaMuxerWrapper>(muxer);
        muxer.addEncoder(this);
        this.mListener = listener;
        Object object = this.mSync;
        synchronized (object) {
            this.mBufferInfo = new MediaCodec.BufferInfo();
            new Thread((Runnable)this, this.getClass().getSimpleName()).start();
            try {
                this.mSync.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public String getOutputPath() {
        MediaMuxerWrapper muxer = (MediaMuxerWrapper)this.mWeakMuxer.get();
        return muxer != null ? muxer.getOutputPath() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean frameAvailableSoon() {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return false;
            }
            ++this.mRequestDrain;
            this.mSync.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        Object object2 = this.mSync;
        synchronized (object2) {
            this.mRequestStop = false;
            this.mRequestDrain = 0;
            this.mSync.notify();
        }
        boolean isRunning = true;
        while (true) {
            boolean localRequestDrain;
            boolean localRequestStop;
            object = this.mSync;
            synchronized (object) {
                localRequestStop = this.mRequestStop;
                boolean bl = localRequestDrain = this.mRequestDrain > 0;
                if (localRequestDrain) {
                    --this.mRequestDrain;
                }
            }
            if (localRequestStop) {
                this.drain();
                this.signalEndOfInputStream();
                this.drain();
                this.release();
                break;
            }
            if (localRequestDrain) {
                this.drain();
                continue;
            }
            object = this.mSync;
            synchronized (object) {
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        Log.d((String)TAG, (String)"Encoder thread exiting");
        object = this.mSync;
        synchronized (object) {
            this.mRequestStop = true;
            this.mIsCapturing = false;
        }
    }

    abstract void prepare() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startRecording() {
        Log.v((String)TAG, (String)"startRecording");
        Object object = this.mSync;
        synchronized (object) {
            this.mIsCapturing = true;
            this.mRequestStop = false;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopRecording() {
        Log.v((String)TAG, (String)"stopRecording");
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return;
            }
            this.mRequestStop = true;
            this.mSync.notifyAll();
        }
    }

    protected void release() {
        MediaMuxerWrapper muxer;
        Log.d((String)TAG, (String)"release:");
        try {
            this.mListener.onStopped(this);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"failed onStopped", (Throwable)e);
        }
        this.mIsCapturing = false;
        if (this.mMediaCodec != null) {
            try {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"failed releasing MediaCodec", (Throwable)e);
            }
        }
        if (this.mMuxerStarted && (muxer = (MediaMuxerWrapper)this.mWeakMuxer.get()) != null) {
            try {
                muxer.stop();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"failed stopping muxer", (Throwable)e);
            }
        }
        this.mBufferInfo = null;
    }

    protected void signalEndOfInputStream() {
        Log.d((String)TAG, (String)"sending EOS to encoder");
        this.encode((byte[])null, 0, this.getPTSUs());
    }

    protected void encode(byte[] buffer, int length, long presentationTimeUs) {
        if (!this.mIsCapturing) {
            return;
        }
        int ix = 0;
        ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
        while (this.mIsCapturing && ix < length) {
            int inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(10000L);
            if (inputBufferIndex >= 0) {
                ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
                inputBuffer.clear();
                int sz = inputBuffer.remaining();
                int n = sz = ix + sz < length ? sz : length - ix;
                if (sz > 0 && buffer != null) {
                    inputBuffer.put(buffer, ix, sz);
                }
                ix += sz;
                if (length <= 0) {
                    this.mIsEOS = true;
                    Log.i((String)TAG, (String)"send BUFFER_FLAG_END_OF_STREAM");
                    this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, 0, presentationTimeUs, 4);
                    break;
                }
                this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, sz, presentationTimeUs, 0);
                continue;
            }
            if (inputBufferIndex != -1) continue;
        }
    }

    protected void encode(ByteBuffer buffer, int length, long presentationTimeUs) {
        if (!this.mIsCapturing) {
            return;
        }
        int ix = 0;
        ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
        while (this.mIsCapturing && ix < length) {
            int inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(10000L);
            if (inputBufferIndex >= 0) {
                ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
                inputBuffer.clear();
                int sz = inputBuffer.remaining();
                int n = sz = ix + sz < length ? sz : length - ix;
                if (sz > 0 && buffer != null) {
                    buffer.position(ix + sz);
                    buffer.flip();
                    inputBuffer.put(buffer);
                }
                ix += sz;
                if (length <= 0) {
                    this.mIsEOS = true;
                    Log.i((String)TAG, (String)"send BUFFER_FLAG_END_OF_STREAM");
                    this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, 0, presentationTimeUs, 4);
                    break;
                }
                this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, sz, presentationTimeUs, 0);
                continue;
            }
            if (inputBufferIndex != -1) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drain() {
        if (this.mMediaCodec == null) {
            return;
        }
        ByteBuffer[] encoderOutputBuffers = this.mMediaCodec.getOutputBuffers();
        int count = 0;
        MediaMuxerWrapper muxer = (MediaMuxerWrapper)this.mWeakMuxer.get();
        if (muxer == null) {
            Log.w((String)TAG, (String)"muxer is unexpectedly null");
            return;
        }
        block5: while (this.mIsCapturing) {
            int encoderStatus = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, 10000L);
            if (encoderStatus == -1) {
                if (this.mIsEOS || ++count <= 5) continue;
                break;
            }
            if (encoderStatus == -3) {
                Log.v((String)TAG, (String)"INFO_OUTPUT_BUFFERS_CHANGED");
                encoderOutputBuffers = this.mMediaCodec.getOutputBuffers();
                continue;
            }
            if (encoderStatus == -2) {
                Log.v((String)TAG, (String)"INFO_OUTPUT_FORMAT_CHANGED");
                if (this.mMuxerStarted) {
                    throw new RuntimeException("format changed twice");
                }
                MediaFormat format = this.mMediaCodec.getOutputFormat();
                this.mTrackIndex = muxer.addTrack(format);
                this.mMuxerStarted = true;
                if (muxer.start()) continue;
                MediaMuxerWrapper mediaMuxerWrapper = muxer;
                synchronized (mediaMuxerWrapper) {
                    while (!muxer.isStarted()) {
                        try {
                            muxer.wait(100L);
                        }
                        catch (InterruptedException e) {
                            break block5;
                        }
                    }
                    continue;
                }
            }
            if (encoderStatus < 0) {
                Log.w((String)TAG, (String)("drain:unexpected result from encoder#dequeueOutputBuffer: " + encoderStatus));
                continue;
            }
            ByteBuffer encodedData = encoderOutputBuffers[encoderStatus];
            if (encodedData == null) {
                throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
            }
            if ((this.mBufferInfo.flags & 2) != 0) {
                Log.d((String)TAG, (String)"drain:BUFFER_FLAG_CODEC_CONFIG");
                this.mBufferInfo.size = 0;
            }
            if (this.mBufferInfo.size != 0) {
                count = 0;
                if (!this.mMuxerStarted) {
                    throw new RuntimeException("drain:muxer hasn't started");
                }
                this.mBufferInfo.presentationTimeUs = this.getPTSUs();
                muxer.writeSampleData(this.mTrackIndex, encodedData, this.mBufferInfo);
                this.prevOutputPTSUs = this.mBufferInfo.presentationTimeUs;
            }
            this.mMediaCodec.releaseOutputBuffer(encoderStatus, false);
            if ((this.mBufferInfo.flags & 4) == 0) continue;
            this.mIsCapturing = false;
            this.mMuxerStarted = false;
            break;
        }
    }

    protected long getPTSUs() {
        long result = System.nanoTime() / 1000L;
        if (result < this.prevOutputPTSUs) {
            result = this.prevOutputPTSUs - result + result;
        }
        return result;
    }

    public static interface MediaEncoderListener {
        public void onPrepared(MediaEncoder var1);

        public void onStopped(MediaEncoder var1);
    }
}

