/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.NumberKeyListener;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.serenegiant.common.R;
import com.serenegiant.widget.ItemPickerButton;
import java.util.Locale;

public final class ItemPicker
extends LinearLayout {
    private final Handler mHandler = new Handler();
    private final Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            if (ItemPicker.this.mIncrement) {
                ItemPicker.this.changeCurrent(ItemPicker.this.mCurrentValue + 1);
                ItemPicker.this.mHandler.postDelayed((Runnable)this, ItemPicker.this.mSpeed);
            } else if (ItemPicker.this.mDecrement) {
                ItemPicker.this.changeCurrent(ItemPicker.this.mCurrentValue - 1);
                ItemPicker.this.mHandler.postDelayed((Runnable)this, ItemPicker.this.mSpeed);
            }
        }
    };
    private final EditText mText;
    private final InputFilter mNumberInputFilter;
    private String[] mDisplayedValues;
    private int mMinValue;
    private int mMaxValue;
    private int mCurrentValue;
    private int mPrevValue;
    private OnChangedListener mListener;
    private Formatter mFormatter;
    private long mSpeed = 300L;
    private boolean mIncrement;
    private boolean mDecrement;
    private static final char[] DIGIT_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private ItemPickerButton mIncrementButton;
    private ItemPickerButton mDecrementButton;

    public ItemPicker(Context context) {
        this(context, null);
    }

    public ItemPicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ItemPicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        this.setOrientation(0);
        this.setGravity(16);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        inflater.inflate(R.layout.item_picker, (ViewGroup)this, true);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ItemPicker, defStyle, 0);
        int minValue = a.getInt(R.styleable.ItemPicker_ItemPickerMinItemValue, -1);
        int maxValue = a.getInt(R.styleable.ItemPicker_ItemPickerMaxItemValue, -1);
        int displayedValueId = a.getResourceId(R.styleable.ItemPicker_ItemPickerDisplayedValue, -1);
        String[] displayedValue = displayedValueId > -1 ? this.getResources().getStringArray(displayedValueId) : null;
        int incrementBackground = a.getResourceId(R.styleable.ItemPicker_ItemPickerIncrementBackground, -1);
        int decrementBackground = a.getResourceId(R.styleable.ItemPicker_ItemPickerDecrementBackground, -1);
        int incrementSrc = a.getResourceId(R.styleable.ItemPicker_ItemPickerIncrementSrc, -1);
        int decrementSrc = a.getResourceId(R.styleable.ItemPicker_ItemPickerDecrementSrc, -1);
        int editTextBackground = a.getResourceId(R.styleable.ItemPicker_ItemPickerEditTextBackground, -1);
        int currentValue = a.getInt(R.styleable.ItemPicker_ItemPickerCurrentItemValue, -1);
        int speed = a.getInt(R.styleable.ItemPicker_ItemPickerSpeed, -1);
        a.recycle();
        a = null;
        View.OnClickListener clickListener = new View.OnClickListener(){

            public void onClick(View v) {
                ItemPicker.this.validateInput((View)ItemPicker.this.mText);
                if (!ItemPicker.this.mText.hasFocus()) {
                    ItemPicker.this.mText.requestFocus();
                }
                if (R.id.increment == v.getId()) {
                    ItemPicker.this.changeCurrent(ItemPicker.this.mCurrentValue + 1);
                } else if (R.id.decrement == v.getId()) {
                    ItemPicker.this.changeCurrent(ItemPicker.this.mCurrentValue - 1);
                }
            }
        };
        View.OnFocusChangeListener focusListener = new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    ItemPicker.this.validateInput(v);
                }
            }
        };
        View.OnLongClickListener longClickListener = new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                ItemPicker.this.mText.clearFocus();
                if (R.id.increment == v.getId()) {
                    ItemPicker.this.mIncrement = true;
                    ItemPicker.this.mHandler.post(ItemPicker.this.mRunnable);
                } else if (R.id.decrement == v.getId()) {
                    ItemPicker.this.mDecrement = true;
                    ItemPicker.this.mHandler.post(ItemPicker.this.mRunnable);
                }
                return true;
            }
        };
        NumberPickerInputFilter inputFilter = new NumberPickerInputFilter();
        this.mNumberInputFilter = new NumberRangeKeyListener();
        this.mIncrementButton = (ItemPickerButton)this.findViewById(R.id.increment);
        this.mIncrementButton.setOnClickListener(clickListener);
        this.mIncrementButton.setOnLongClickListener(longClickListener);
        this.mIncrementButton.setNumberPicker(this);
        if (incrementBackground != -1) {
            this.mIncrementButton.setBackgroundResource(incrementBackground);
        }
        if (incrementSrc != -1) {
            this.mIncrementButton.setImageResource(incrementSrc);
        }
        this.mDecrementButton = (ItemPickerButton)this.findViewById(R.id.decrement);
        this.mDecrementButton.setOnClickListener(clickListener);
        this.mDecrementButton.setOnLongClickListener(longClickListener);
        this.mDecrementButton.setNumberPicker(this);
        if (decrementBackground != -1) {
            this.mDecrementButton.setBackgroundResource(decrementBackground);
        }
        if (decrementSrc != -1) {
            this.mDecrementButton.setImageResource(decrementSrc);
        }
        this.mText = (EditText)this.findViewById(R.id.input);
        this.mText.setOnFocusChangeListener(focusListener);
        this.mText.setFilters(new InputFilter[]{inputFilter});
        this.mText.setRawInputType(2);
        if (editTextBackground != -1) {
            this.mText.setBackgroundResource(editTextBackground);
        }
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
        if (minValue > -1 && maxValue > -1) {
            if (displayedValue != null) {
                this.setRange(minValue, maxValue, displayedValue);
            } else {
                this.setRange(minValue, maxValue);
            }
        }
        if (currentValue > -1) {
            this.setValue(currentValue);
        }
        if (speed > -1) {
            this.setSpeed(speed);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mIncrementButton.setEnabled(enabled);
        this.mDecrementButton.setEnabled(enabled);
        this.mText.setEnabled(enabled);
    }

    public void setOnKeyListener(View.OnKeyListener listener) {
        super.setOnKeyListener(listener);
        this.mIncrementButton.setOnKeyListener(listener);
        this.mDecrementButton.setOnKeyListener(listener);
        this.mText.setOnKeyListener(listener);
    }

    public void setOnChangeListener(OnChangedListener listener) {
        this.mListener = listener;
    }

    public void setFormatter(Formatter formatter) {
        this.mFormatter = formatter;
    }

    public void setRange(int min, int max) {
        this.setRange(min, max, null);
    }

    public void setRange(int min, int max, String[] displayedValues) {
        this.mDisplayedValues = displayedValues;
        this.mMinValue = min;
        this.mMaxValue = max;
        if (this.mCurrentValue < min || this.mCurrentValue > max) {
            this.mCurrentValue = min;
        }
        this.updateView();
        if (displayedValues != null) {
            this.mText.setRawInputType(524289);
        }
    }

    public void setValue(int value) {
        if (value < this.mMinValue || value > this.mMaxValue) {
            Log.w((String)"ItemPicker", (String)String.format("current(%d) should be between min(%d) to max(%d) changed to min", value, this.mMinValue, this.mMaxValue));
            value = this.mMinValue;
        }
        this.mCurrentValue = value;
        this.updateView();
    }

    public void setSpeed(long speed) {
        this.mSpeed = speed;
    }

    private String formatNumber(int value) {
        return this.mFormatter != null ? this.mFormatter.toString(value) : String.valueOf(value);
    }

    protected void changeCurrent(int current) {
        if (current > this.mMaxValue) {
            current = this.mMinValue;
        } else if (current < this.mMinValue) {
            current = this.mMaxValue;
        }
        this.mPrevValue = this.mCurrentValue;
        this.mCurrentValue = current;
        this.notifyChange();
        this.updateView();
    }

    private void notifyChange() {
        if (this.mListener != null) {
            this.mListener.onChanged(this, this.mPrevValue, this.mCurrentValue);
        }
    }

    private void updateView() {
        if (this.mDisplayedValues == null) {
            this.mText.setText((CharSequence)this.formatNumber(this.mCurrentValue));
        } else {
            this.mText.setText((CharSequence)this.mDisplayedValues[this.mCurrentValue - this.mMinValue]);
        }
        this.mText.setSelection(this.mText.getText().length());
    }

    private void validateCurrentView(CharSequence str) {
        int val = this.getSelectedPos(str.toString());
        if (val >= this.mMinValue && val <= this.mMaxValue && this.mCurrentValue != val) {
            this.mPrevValue = this.mCurrentValue;
            this.mCurrentValue = val;
            this.notifyChange();
        }
        this.updateView();
    }

    private void validateInput(View v) {
        String str = String.valueOf(((TextView)v).getText());
        if (TextUtils.isEmpty((CharSequence)str)) {
            this.updateView();
        } else {
            this.validateCurrentView(str);
        }
    }

    public void cancelIncrement() {
        this.mIncrement = false;
    }

    public void cancelDecrement() {
        this.mDecrement = false;
    }

    private int getSelectedPos(String str) {
        if (this.mDisplayedValues == null) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else {
            for (int i = 0; i < this.mDisplayedValues.length; ++i) {
                str = str.toLowerCase(Locale.US);
                if (!this.mDisplayedValues[i].toLowerCase(Locale.US).startsWith(str)) continue;
                return this.mMinValue + i;
            }
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.mMinValue;
    }

    public int getValue() {
        return this.mCurrentValue;
    }

    protected int getEndRange() {
        return this.mMaxValue;
    }

    protected int getBeginRange() {
        return this.mMinValue;
    }

    private class NumberRangeKeyListener
    extends NumberKeyListener {
        private NumberRangeKeyListener() {
        }

        public int getInputType() {
            return 2;
        }

        protected char[] getAcceptedChars() {
            return DIGIT_CHARACTERS;
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            String result;
            CharSequence filtered = super.filter(source, start, end, dest, dstart, dend);
            if (filtered == null) {
                filtered = source.subSequence(start, end);
            }
            if ("".equals(result = String.valueOf(dest.subSequence(0, dstart)) + filtered + dest.subSequence(dend, dest.length()))) {
                return result;
            }
            int val = ItemPicker.this.getSelectedPos(result);
            if (val > ItemPicker.this.mMaxValue) {
                return "";
            }
            return filtered;
        }
    }

    private class NumberPickerInputFilter
    implements InputFilter {
        private NumberPickerInputFilter() {
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (ItemPicker.this.mDisplayedValues == null) {
                return ItemPicker.this.mNumberInputFilter.filter(source, start, end, dest, dstart, dend);
            }
            String filtered = String.valueOf(source.subSequence(start, end));
            String result = String.valueOf(dest.subSequence(0, dstart)) + filtered + dest.subSequence(dend, dest.length());
            String str = String.valueOf(result).toLowerCase(Locale.US);
            for (String val : ItemPicker.this.mDisplayedValues) {
                if (!(val = val.toLowerCase(Locale.US)).startsWith(str)) continue;
                return filtered;
            }
            return "";
        }
    }

    public static interface Formatter {
        public String toString(int var1);
    }

    public static interface OnChangedListener {
        public void onChanged(ItemPicker var1, int var2, int var3);
    }
}

