/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.os.Build;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPool {
    private static final int CORE_POOL_SIZE = 4;
    private static final int MAX_POOL_SIZE = 32;
    private static final int KEEP_ALIVE_TIME = 10;
    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(4, 32, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public static void preStartAllCoreThreads() {
        EXECUTOR.prestartAllCoreThreads();
    }

    public static void queueEvent(Runnable command) {
        EXECUTOR.execute(command);
    }

    static {
        if (Build.VERSION.SDK_INT >= 9) {
            EXECUTOR.allowCoreThreadTimeOut(true);
        }
    }
}

