/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.UriPermission;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.provider.DocumentFile;
import android.text.TextUtils;
import android.util.Log;
import com.serenegiant.utils.BuildCheck;
import com.serenegiant.utils.UriHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Locale;

public class SDUtils {
    private static final String TAG = SDUtils.class.getSimpleName();

    public static void handleOnResult(Context context, int requestCode, int resultCode, Intent data, handleOnResultDelegater delegater) {
        if (data != null && delegater != null) {
            Uri uri;
            String action = data.getAction();
            if (resultCode == -1 && (uri = data.getData()) != null) {
                try {
                    delegater.onResult(requestCode, uri, data);
                    return;
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
            try {
                SDUtils.clearUri(context, SDUtils.getKey(requestCode));
                delegater.onFailed(requestCode, data);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String getKey(int request_code) {
        return String.format(Locale.US, "SDUtils-%d", request_code);
    }

    private static void saveUri(Context context, String key, Uri uri) {
        SharedPreferences pref = context.getSharedPreferences(context.getPackageName(), 0);
        if (pref != null) {
            pref.edit().putString(key, uri.toString()).apply();
        }
    }

    @Nullable
    private static Uri loadUri(Context context, String key) {
        Uri result = null;
        SharedPreferences pref = context.getSharedPreferences(context.getPackageName(), 0);
        if (pref != null && pref.contains(key)) {
            try {
                result = Uri.parse((String)pref.getString(key, null));
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return result;
    }

    private static void clearUri(Context context, String key) {
        SharedPreferences pref = context.getSharedPreferences(context.getPackageName(), 0);
        if (pref != null && pref.contains(key)) {
            try {
                pref.edit().remove(key).apply();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    @TargetApi(value=19)
    public static void requestOpenDocument(Activity activity, String mime_type, int request_code) {
        if (BuildCheck.isKitKat()) {
            activity.startActivityForResult(SDUtils.prepareOpenDocumentIntent(mime_type), request_code);
        }
    }

    @TargetApi(value=19)
    public static void requestOpenDocument(FragmentActivity activity, String mime_type, int request_code) {
        if (BuildCheck.isKitKat()) {
            activity.startActivityForResult(SDUtils.prepareOpenDocumentIntent(mime_type), request_code);
        }
    }

    @TargetApi(value=19)
    public static void requestOpenDocument(Fragment fragment, String mime_type, int request_code) {
        if (BuildCheck.isKitKat()) {
            fragment.startActivityForResult(SDUtils.prepareOpenDocumentIntent(mime_type), request_code);
        }
    }

    @TargetApi(value=19)
    public static void requestOpenDocument(android.support.v4.app.Fragment fragment, String mime_type, int request_code) {
        if (BuildCheck.isKitKat()) {
            fragment.startActivityForResult(SDUtils.prepareOpenDocumentIntent(mime_type), request_code);
        }
    }

    @TargetApi(value=19)
    private static Intent prepareOpenDocumentIntent(String mime_type) {
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT");
        intent.setType(mime_type);
        return intent;
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(Activity activity, String mime_type, int request_code) {
        if (BuildCheck.isKitKat()) {
            activity.startActivityForResult(SDUtils.prepareCreateDocument(mime_type, null), request_code);
        }
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(Activity activity, String mime_type, String default_name, int request_code) {
        if (BuildCheck.isKitKat()) {
            activity.startActivityForResult(SDUtils.prepareCreateDocument(mime_type, default_name), request_code);
        }
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(FragmentActivity activity, String mime_type, int request_code) {
        if (BuildCheck.isKitKat()) {
            activity.startActivityForResult(SDUtils.prepareCreateDocument(mime_type, null), request_code);
        }
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(FragmentActivity activity, String mime_type, String default_name, int request_code) {
        if (BuildCheck.isKitKat()) {
            activity.startActivityForResult(SDUtils.prepareCreateDocument(mime_type, default_name), request_code);
        }
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(Fragment fragment, String mime_type, int request_code) {
        if (BuildCheck.isKitKat()) {
            fragment.startActivityForResult(SDUtils.prepareCreateDocument(mime_type, null), request_code);
        }
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(Fragment fragment, String mime_type, String default_name, int request_code) {
        if (BuildCheck.isKitKat()) {
            fragment.startActivityForResult(SDUtils.prepareCreateDocument(mime_type, default_name), request_code);
        }
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(android.support.v4.app.Fragment fragment, String mime_type, int request_code) {
        if (BuildCheck.isKitKat()) {
            fragment.startActivityForResult(SDUtils.prepareCreateDocument(mime_type, null), request_code);
        }
    }

    @TargetApi(value=19)
    public static void requestCreateDocument(android.support.v4.app.Fragment fragment, String mime_type, String default_name, int request_code) {
        if (BuildCheck.isKitKat()) {
            fragment.startActivityForResult(SDUtils.prepareCreateDocument(mime_type, default_name), request_code);
        }
    }

    @TargetApi(value=19)
    private static Intent prepareCreateDocument(String mime_type, String default_name) {
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT");
        intent.setType(mime_type);
        if (!TextUtils.isEmpty((CharSequence)default_name)) {
            intent.putExtra("android.intent.extra.TITLE", default_name);
        }
        return intent;
    }

    @TargetApi(value=19)
    public static boolean requestDeleteDocument(Context context, Uri uri) {
        return BuildCheck.isKitKat() && DocumentsContract.deleteDocument((ContentResolver)context.getContentResolver(), (Uri)uri);
    }

    public static boolean hasStorageAccess(Context context, int request_code) {
        Uri uri;
        boolean found = false;
        if (BuildCheck.isLollipop() && (uri = SDUtils.loadUri(context, SDUtils.getKey(request_code))) != null) {
            List list = context.getContentResolver().getPersistedUriPermissions();
            for (UriPermission item : list) {
                if (!item.getUri().equals((Object)uri)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @TargetApi(value=21)
    public static Uri requestStorageAccess(Activity activity, int request_code) {
        if (BuildCheck.isLollipop()) {
            Uri uri = SDUtils.getStorageUri((Context)activity, request_code);
            if (uri == null) {
                activity.startActivityForResult(SDUtils.prepareStorageAccessPermission(), request_code);
            }
            return uri;
        }
        return null;
    }

    @TargetApi(value=21)
    public static Uri requestStorageAccess(FragmentActivity activity, int request_code) {
        if (BuildCheck.isLollipop()) {
            Uri uri = SDUtils.getStorageUri((Context)activity, request_code);
            if (uri == null) {
                activity.startActivityForResult(SDUtils.prepareStorageAccessPermission(), request_code);
            }
            return uri;
        }
        return null;
    }

    @TargetApi(value=21)
    public static Uri requestStorageAccess(Fragment fragment, int request_code) {
        Uri uri = SDUtils.getStorageUri((Context)fragment.getActivity(), request_code);
        if (uri == null) {
            fragment.startActivityForResult(SDUtils.prepareStorageAccessPermission(), request_code);
        }
        return uri;
    }

    @TargetApi(value=21)
    public static Uri requestStorageAccess(android.support.v4.app.Fragment fragment, int request_code) {
        if (BuildCheck.isLollipop()) {
            Uri uri = SDUtils.getStorageUri((Context)fragment.getActivity(), request_code);
            if (uri == null) {
                fragment.startActivityForResult(SDUtils.prepareStorageAccessPermission(), request_code);
            }
            return uri;
        }
        return null;
    }

    @TargetApi(value=21)
    @Nullable
    private static Uri getStorageUri(Context context, int request_code) {
        Uri uri;
        if (BuildCheck.isLollipop() && (uri = SDUtils.loadUri(context, SDUtils.getKey(request_code))) != null) {
            boolean found = false;
            List list = context.getContentResolver().getPersistedUriPermissions();
            for (UriPermission item : list) {
                if (!item.getUri().equals((Object)uri)) continue;
                found = true;
                break;
            }
            if (found) {
                return uri;
            }
        }
        return null;
    }

    @TargetApi(value=21)
    private static Intent prepareStorageAccessPermission() {
        return new Intent("android.intent.action.OPEN_DOCUMENT_TREE");
    }

    @TargetApi(value=21)
    public static Uri requestStorageAccessPermission(Context context, int request_code, Uri tree_uri) {
        if (BuildCheck.isLollipop()) {
            context.getContentResolver().takePersistableUriPermission(tree_uri, 3);
            SDUtils.saveUri(context, SDUtils.getKey(request_code), tree_uri);
            return tree_uri;
        }
        return null;
    }

    @TargetApi(value=21)
    public static void releaseStorageAccessPermission(Context context, int request_code) {
        String key;
        Uri uri;
        if (BuildCheck.isLollipop() && (uri = SDUtils.loadUri(context, key = SDUtils.getKey(request_code))) != null) {
            context.getContentResolver().releasePersistableUriPermission(uri, 3);
            SDUtils.clearUri(context, key);
        }
    }

    @TargetApi(value=21)
    public static File createStorageDir(Context context, int tree_id) {
        Uri tree_uri;
        Log.i((String)TAG, (String)"createStorageDir:");
        if (BuildCheck.isLollipop() && (tree_uri = SDUtils.getStorageUri(context, tree_id)) != null) {
            DocumentFile save_tree = DocumentFile.fromTreeUri((Context)context, (Uri)tree_uri);
            return new File(UriHelper.getPath(context, save_tree.getUri()));
        }
        return null;
    }

    @TargetApi(value=21)
    public static File createStorageFile(Context context, int tree_id, String mime, String file_name) {
        Log.i((String)TAG, (String)("createStorageFile:" + file_name));
        return SDUtils.createStorageFile(context, SDUtils.getStorageUri(context, tree_id), mime, file_name);
    }

    @TargetApi(value=21)
    public static File createStorageFile(Context context, Uri tree_uri, String mime, String file_name) {
        Log.i((String)TAG, (String)("createStorageFile:" + file_name));
        if (BuildCheck.isLollipop() && context != null && tree_uri != null && !TextUtils.isEmpty((CharSequence)file_name)) {
            DocumentFile save_tree = DocumentFile.fromTreeUri((Context)context, (Uri)tree_uri);
            DocumentFile target = save_tree.createFile(mime, file_name);
            return new File(UriHelper.getPath(context, target.getUri()));
        }
        return null;
    }

    @TargetApi(value=21)
    public static int createStorageFileFD(Context context, int tree_id, String mime, String file_name) {
        Log.i((String)TAG, (String)("createStorageFileFD:" + file_name));
        return SDUtils.createStorageFileFD(context, SDUtils.getStorageUri(context, tree_id), mime, file_name);
    }

    @TargetApi(value=21)
    public static int createStorageFileFD(Context context, Uri tree_uri, String mime, String file_name) {
        Log.i((String)TAG, (String)("createStorageFileFD:" + file_name));
        if (BuildCheck.isLollipop() && context != null && tree_uri != null && !TextUtils.isEmpty((CharSequence)file_name)) {
            DocumentFile save_tree = DocumentFile.fromTreeUri((Context)context, (Uri)tree_uri);
            DocumentFile target = save_tree.createFile(mime, file_name);
            try {
                ParcelFileDescriptor fd = context.getContentResolver().openFileDescriptor(target.getUri(), "rw");
                return fd != null ? fd.getFd() : 0;
            }
            catch (FileNotFoundException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return 0;
    }

    public static interface handleOnResultDelegater {
        public void onResult(int var1, Uri var2, Intent var3);

        public void onFailed(int var1, Intent var2);
    }
}

